/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.fragment.app.Fragment;
import androidx.lifecycle.ViewModelProvider;
import com.b2lmobitech.fieldcloudplus.dashboard;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.TimeSheetVM;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class DumpFragment
extends Fragment {
    Preference preference;
    HcmDatabase hcmDatabase;
    DBViewModel dbViewModel;
    TimeSheetVM timeSheetVM;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(2131493166, container, false);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.dbViewModel = (DBViewModel)ViewModelProvider.AndroidViewModelFactory.getInstance((Application)this.getActivity().getApplication()).create(DBViewModel.class);
        this.timeSheetVM = (TimeSheetVM)ViewModelProvider.AndroidViewModelFactory.getInstance((Application)this.getActivity().getApplication()).create(TimeSheetVM.class);
        this.preference = Preference.getInstance((Context)this.getActivity());
        this.hcmDatabase = HcmDatabase.getInstance((Context)this.getActivity());
        this.getAttendance();
    }

    private void getAttendance() {
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", this.preference.getEmailId());
        params.put("companyname", this.preference.getCompanyName());
        params.put("enddate", DateUtils.getCurrentDate());
        params.put("startdate", new SimpleDateFormat("yyyy-MM-dd").format(c.getTime()));
        MyRequestQueue.getInstance(this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_attendancecurrentmonth.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        DumpFragment.this.dbViewModel.inserAttendanceHistory(jsonObject.getJSONArray("list"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                DumpFragment.this.getTimesheet();
            }
        });
    }

    private void getTimesheet() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", this.preference.getEmailId());
        params.put("companyname", this.preference.getCompanyName());
        MyRequestQueue.getInstance(this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_timesheetfull.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        DumpFragment.this.timeSheetVM.inserTimesheetHistory(jsonObject.getJSONArray("list"));
                        DumpFragment.this.hcmDatabase.insertTimesheet(jsonObject.getJSONArray("list"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                DumpFragment.this.getLeaves();
            }
        });
    }

    private void getLeaves() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", this.preference.getEmailId());
        params.put("companyname", this.preference.getCompanyName());
        MyRequestQueue.getInstance(this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_leavefull.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        DumpFragment.this.hcmDatabase.insertLeaves(jsonObject.getJSONArray("list"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                DumpFragment.this.nextActivity();
            }
        });
    }

    private void nextActivity() {
        this.preference.putString(globalvariables.logout_initialdump, "Yes");
        Intent intent = new Intent((Context)this.getActivity(), dashboard.class);
        intent.addFlags(0x14000000);
        this.startActivity(intent);
        this.getActivity().finish();
    }
}

