/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.os.Bundle;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.text.TextUtils;
import android.util.Log;
import android.util.Patterns;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.AutoCompleteTextView;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import com.b2lmobitech.fieldcloudplus.DumpFragment;
import com.b2lmobitech.fieldcloudplus.dashboard;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.google.android.material.snackbar.Snackbar;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class LoginActivity
extends AppCompatActivity {
    private Context mycontext;
    private AutoCompleteTextView mEmailView;
    private EditText mPasswordView;
    private View mProgressView;
    private View mLoginFormView;
    private static String url_check_passworddetails = "";
    private String enteredmail = "";
    private int checkin_success = 0;
    private int forgotstatus = 0;
    public static Activity loginactivity;
    private Snackbar snackBar;
    private InputMethodManager imm;
    public static LinearLayout loginfulllayout;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492961);
        this.mycontext = this;
        loginactivity = this;
        this.getSupportActionBar().hide();
        this.getWidgets();
    }

    private void getWidgets() {
        this.mEmailView = (AutoCompleteTextView)this.findViewById(2131296717);
        this.mPasswordView = (EditText)this.findViewById(2131297144);
        ((ImageView)this.findViewById(2131296723)).setImageResource(2131230906);
        ((ImageView)this.findViewById(2131297209)).setImageResource(2131230922);
        this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
        this.imm = (InputMethodManager)this.getSystemService("input_method");
        this.findViewById(2131296722).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginActivity.this.snackBar.dismiss();
                try {
                    LoginActivity.this.imm.hideSoftInputFromWindow(LoginActivity.this.getCurrentFocus().getWindowToken(), 0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (LoginActivity.this.isValid()) {
                    LoginActivity.this.login();
                }
            }
        });
        this.findViewById(2131296719).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoginActivity.this.snackBar.dismiss();
                LoginActivity.this.imm.hideSoftInputFromWindow(LoginActivity.this.getCurrentFocus().getWindowToken(), 0);
                LoginActivity.this.mEmailView.setText((CharSequence)"");
                LoginActivity.this.mPasswordView.setText((CharSequence)"");
            }
        });
        this.findViewById(2131296779).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                LoginActivity.this.imm.hideSoftInputFromWindow(LoginActivity.this.getCurrentFocus().getWindowToken(), 0);
                LoginActivity.this.enteredmail = String.valueOf(LoginActivity.this.mEmailView.getText());
                if (TextUtils.isEmpty((CharSequence)LoginActivity.this.enteredmail)) {
                    LoginActivity.this.mEmailView.setError((CharSequence)LoginActivity.this.getString(2131820628));
                } else if (!Patterns.EMAIL_ADDRESS.matcher(LoginActivity.this.mEmailView.getText().toString()).matches()) {
                    LoginActivity.this.mEmailView.setError((CharSequence)LoginActivity.this.getString(2131820631));
                } else {
                    AlertDialog.Builder alertdialog = new AlertDialog.Builder(LoginActivity.this.mycontext);
                    alertdialog.setTitle((CharSequence)"Forgot password");
                    alertdialog.setIcon(2131230908);
                    alertdialog.setMessage((CharSequence)"Password will be send to this mail address?");
                    alertdialog.setPositiveButton((CharSequence)"Ok", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int whichButton) {
                            try {
                                if (LoginActivity.this.isNetworkAvailable()) {
                                    LoginActivity.this.forgot();
                                } else {
                                    LoginActivity.this.snackBar.dismiss();
                                    LoginActivity.this.snackBar = Snackbar.make((View)LoginActivity.this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
                                    LoginActivity.this.toast();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    alertdialog.setNegativeButton((CharSequence)"No,thanks", new DialogInterface.OnClickListener(){

                        public void onClick(DialogInterface dialog, int which) {
                        }
                    }).create();
                    alertdialog.show();
                }
            }
        });
        this.mLoginFormView = this.findViewById(2131296987);
        this.mProgressView = this.findViewById(2131296988);
    }

    private boolean isValid() {
        this.mEmailView.setError(null);
        this.mPasswordView.setError(null);
        if (this.mEmailView.getText().toString().isEmpty()) {
            this.mEmailView.setError((CharSequence)this.getString(2131820628));
            this.mEmailView.requestFocus();
            return false;
        }
        if (!Patterns.EMAIL_ADDRESS.matcher(this.mEmailView.getText().toString()).matches()) {
            this.mEmailView.setError((CharSequence)this.getString(2131820631));
            this.mEmailView.requestFocus();
            return false;
        }
        if (this.mPasswordView.getText().toString().isEmpty()) {
            this.mPasswordView.setError((CharSequence)"This field is required");
            this.mPasswordView.requestFocus();
            return false;
        }
        if (this.mPasswordView.getText().toString().length() < 4) {
            this.mPasswordView.setError((CharSequence)this.getString(2131820632));
            this.mPasswordView.requestFocus();
            return false;
        }
        if (MyRequestQueue.getInstance((Activity)this).isNoInternet()) {
            this.snackBar.dismiss();
            this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
            this.toast();
            return false;
        }
        return ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_PHONE_STATE") == 0;
    }

    private String getImei() {
        String imei = null;
        TelephonyManager tm = (TelephonyManager)this.getSystemService("phone");
        try {
            imei = tm.getDeviceId();
            if (Build.VERSION.SDK_INT >= 26) {
                imei = tm.getImei();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (imei == null && Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"android_id") != null) {
            imei = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"android_id");
        }
        return imei;
    }

    private void login() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", this.mEmailView.getText().toString());
        params.put("pass", this.mPasswordView.getText().toString());
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.READ_PHONE_STATE") != 0) {
            return;
        }
        params.put("imei", this.getImei());
        params.put("updated", DateUtils.formatDate(this.apkUpdateTime()));
        params.put("installed", DateUtils.formatDate(this.getInstallTime()));
        params.put("verision_name", "21");
        params.put("verision_code", String.valueOf(21));
        Log.d((String)"params", (String)((Object)params).toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/login.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    LoginActivity.this.login(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void login(JSONObject jsonObject) throws JSONException {
        if (jsonObject.getInt("s") == 1) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(globalvariables.logout_companyname, jsonObject.getString("companyname"));
            hashMap.put(globalvariables.logout_companytype, jsonObject.getString("companytype"));
            hashMap.put(globalvariables.logout_emailid, jsonObject.getString("emailid"));
            hashMap.put(globalvariables.logout_employeename, jsonObject.getString("employeename"));
            hashMap.put(globalvariables.logout_designation, jsonObject.getString("designation"));
            hashMap.put(globalvariables.logout_group, jsonObject.getString("group"));
            hashMap.put(globalvariables.logout_subgroup, jsonObject.getString("subgroup"));
            hashMap.put(globalvariables.logout_team, jsonObject.getString("team"));
            hashMap.put("empcompanytype", jsonObject.getString("empcompanytype"));
            hashMap.put(globalvariables.logout_signout, "no");
            hashMap.put("profile", jsonObject.getString("profilepic"));
            hashMap.put(globalvariables.latitude, jsonObject.getString("latitude"));
            hashMap.put(globalvariables.longitude, jsonObject.getString("longitude"));
            hashMap.put(globalvariables.geo_enabled, jsonObject.getString("geofencing"));
            hashMap.put(globalvariables.geo_distance, jsonObject.getString("geo_distance"));
            Preference.getInstance((Context)this).putString(hashMap);
            this.updateLoginDetails(jsonObject.getString("emailid"));
        } else if (jsonObject.getInt("s") == 0) {
            this.mPasswordView.setError((CharSequence)jsonObject.getString("m"));
            this.mPasswordView.requestFocus();
        } else {
            this.mEmailView.setError((CharSequence)jsonObject.getString("m"));
            this.mEmailView.requestFocus();
        }
    }

    private void updateLoginDetails(String emailId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", emailId);
        params.put("time", DateUtils.getCurrentDateTime());
        params.put("updated_on", DateUtils.formatDate(this.apkUpdateTime()));
        params.put("installed_on", DateUtils.formatDate(this.getInstallTime()));
        params.put("version_name", "21");
        params.put("version_code", String.valueOf(21));
        Log.d((String)"params", (String)((Object)params).toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/update_logindetails.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                LoginActivity.this.nextActivity();
            }
        });
    }

    private void nextActivity() {
        if (Preference.getInstance((Context)this).getString(globalvariables.logout_initialdump).isEmpty()) {
            DumpFragment dumpFragment = new DumpFragment();
            this.getSupportFragmentManager().beginTransaction().replace(2131296784, (Fragment)dumpFragment).commitNow();
        } else {
            Intent intent = new Intent(this.mycontext, dashboard.class);
            this.startActivity(intent);
            this.finish();
        }
    }

    private void showProgress(final boolean show) {
        int shortAnimTime = this.getResources().getInteger(0x10E0000);
        this.mLoginFormView.setVisibility(show ? 8 : 0);
        this.mLoginFormView.animate().setDuration((long)shortAnimTime).alpha(show ? 0.0f : 1.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                LoginActivity.this.mLoginFormView.setVisibility(show ? 8 : 0);
            }
        });
        this.mProgressView.setVisibility(show ? 0 : 8);
        this.mProgressView.animate().setDuration((long)shortAnimTime).alpha(show ? 1.0f : 0.0f).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                LoginActivity.this.mProgressView.setVisibility(show ? 0 : 8);
            }
        });
        if (this.mLoginFormView.getVisibility() == 0) {
            this.snackBar.dismiss();
        } else {
            this.snackBar.dismiss();
            this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please do not press back", (int)-2);
            this.toast();
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mycontext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (cm.getNetworkInfo(1).isConnectedOrConnecting()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private void toast() {
        this.snackBar.setAction((CharSequence)"CLOSE", new View.OnClickListener(){

            public void onClick(View v) {
                LoginActivity.this.snackBar.dismiss();
            }
        }).setActionTextColor(this.getResources().getColor(17170451)).show();
    }

    private void forgot() {
        this.snackBar.dismiss();
        this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please do not press back", (int)-2);
        this.toast();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("emailid", this.mEmailView.getText().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/fieldcloud_forgot.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        LoginActivity.this.snackBar.dismiss();
                        LoginActivity.this.snackBar = Snackbar.make((View)LoginActivity.this.findViewById(0x1020002), (CharSequence)"Password sent to this mail address,please check it.", (int)-2);
                        LoginActivity.this.toast();
                    } else if (LoginActivity.this.forgotstatus == 0) {
                        LoginActivity.this.mEmailView.setError((CharSequence)"This email address is not registered");
                        LoginActivity.this.mEmailView.requestFocus();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public Date getInstallTime() {
        if (this.installTimeFromPackageManager() != null) {
            return this.installTimeFromPackageManager();
        }
        return this.apkUpdateTime();
    }

    private Date apkUpdateTime() {
        try {
            ApplicationInfo info = this.getPackageManager().getApplicationInfo("com.b2lmobitech.fieldcloudplus", 0);
            File apkFile = new File(info.sourceDir);
            return apkFile.exists() ? new Date(apkFile.lastModified()) : null;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private Date installTimeFromPackageManager() {
        try {
            PackageInfo info = this.getPackageManager().getPackageInfo("com.b2lmobitech.fieldcloudplus", 0);
            Field field = PackageInfo.class.getField("firstInstallTime");
            long timestamp = field.getLong(info);
            return new Date(timestamp);
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }
}

