/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProfileActivity
extends AppCompatActivity {
    LinearLayout mainLayout;
    private final String NDA = "no data available";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492981);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Profile");
        this.mainLayout = (LinearLayout)this.findViewById(2131296993);
        this.getProfile();
    }

    private void getProfile() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_profile.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    ProfileActivity.this.getProfile(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getProfile(JSONObject jsonObject) throws JSONException {
        if (jsonObject.getJSONArray("profile").length() != 0) {
            this.addProfile(jsonObject.getJSONArray("profile").getJSONObject(0));
        }
        if (jsonObject.getJSONArray("account").length() != 0) {
            this.addBank(jsonObject.getJSONArray("account").getJSONObject(0));
        }
        if (jsonObject.getJSONArray("passport").length() != 0) {
            this.addPassport(jsonObject.getJSONArray("passport").getJSONObject(0));
        }
        if (jsonObject.getJSONArray("education").length() != 0) {
            this.addEducation(jsonObject.getJSONArray("education"));
        }
        if (jsonObject.getJSONArray("experience").length() != 0) {
            this.addExperience(jsonObject.getJSONArray("experience"));
        }
        if (jsonObject.getJSONArray("address").length() != 0) {
            this.addAddress(jsonObject.getJSONArray("address").getJSONObject(0));
        }
        if (jsonObject.getJSONArray("dependent").length() != 0) {
            this.addDependent(jsonObject.getJSONArray("dependent"));
        }
    }

    private void addProfile(JSONObject jsonObject) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493243, null);
        TextView title = (TextView)view.findViewById(2131296669);
        final LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        final ImageView imageView = (ImageView)view.findViewById(2131297340);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (senderLayout.getVisibility() == 0) {
                    senderLayout.setVisibility(8);
                    imageView.setImageResource(2131230974);
                } else {
                    senderLayout.setVisibility(0);
                    imageView.setImageResource(2131230973);
                }
            }
        });
        title.setText((CharSequence)"Profile");
        imageView.setImageResource(2131230973);
        this.addView(senderLayout, "Employee Id", jsonObject.getString("emp_id"));
        this.addView(senderLayout, "First Name", jsonObject.getString("employeename"));
        this.addView(senderLayout, "Middle Name", jsonObject.getString("middle_name"));
        this.addView(senderLayout, "Last Name", jsonObject.getString("middle_name"));
        this.addView(senderLayout, "Nationality", jsonObject.getString("nationality"));
        this.addView(senderLayout, "Date of Birth", jsonObject.getString("date_of_birth"));
        this.addView(senderLayout, "Gender", jsonObject.getString("gender"));
        this.addView(senderLayout, "Designation", jsonObject.getString("designation"));
        this.addView(senderLayout, "Group Name", jsonObject.getString("groups"));
        this.addView(senderLayout, "SubGroup I", jsonObject.getString("subgroup1"));
        this.addView(senderLayout, "SubGroup II", jsonObject.getString("subgroup2"));
        this.addView(senderLayout, "Gender", jsonObject.getString("gender"));
        this.addView(senderLayout, "Email", jsonObject.getString("emailid"));
        this.addView(senderLayout, "Mobile", jsonObject.getString("mobilenumber"));
        this.mainLayout.addView(view);
    }

    private void addBank(JSONObject jsonObject) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493243, null);
        TextView title = (TextView)view.findViewById(2131296669);
        final LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setText((CharSequence)"Bank Account");
        final ImageView imageView = (ImageView)view.findViewById(2131297340);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (senderLayout.getVisibility() == 0) {
                    senderLayout.setVisibility(8);
                    imageView.setImageResource(2131230974);
                } else {
                    senderLayout.setVisibility(0);
                    imageView.setImageResource(2131230973);
                }
            }
        });
        senderLayout.setVisibility(8);
        this.addView(senderLayout, "Bank Name", jsonObject.getString("bank_name"));
        this.addView(senderLayout, "Account Number", jsonObject.getString("account_number"));
        this.addView(senderLayout, "IFSC Code", jsonObject.getString("ifsc_code"));
        this.addView(senderLayout, "Branch", jsonObject.getString("account_type"));
        this.mainLayout.addView(view);
    }

    private void addAddress(JSONObject jsonObject) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493243, null);
        TextView title = (TextView)view.findViewById(2131296669);
        final LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setText((CharSequence)"Contact Information");
        final ImageView imageView = (ImageView)view.findViewById(2131297340);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (senderLayout.getVisibility() == 0) {
                    senderLayout.setVisibility(8);
                    imageView.setImageResource(2131230974);
                } else {
                    senderLayout.setVisibility(0);
                    imageView.setImageResource(2131230973);
                }
            }
        });
        senderLayout.setVisibility(8);
        this.addAddressView1(jsonObject, senderLayout);
        this.addAddressView2(jsonObject, senderLayout);
        this.mainLayout.addView(view);
    }

    private void addDependent(JSONArray jsonArray) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493243, null);
        TextView title = (TextView)view.findViewById(2131296669);
        final LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setText((CharSequence)"Dependent");
        final ImageView imageView = (ImageView)view.findViewById(2131297340);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (senderLayout.getVisibility() == 0) {
                    senderLayout.setVisibility(8);
                    imageView.setImageResource(2131230974);
                } else {
                    senderLayout.setVisibility(0);
                    imageView.setImageResource(2131230973);
                }
            }
        });
        senderLayout.setVisibility(8);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.addDependentView(jsonArray.getJSONObject(i), senderLayout);
        }
        this.mainLayout.addView(view);
    }

    private void addExperience(JSONArray jsonArray) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493243, null);
        TextView title = (TextView)view.findViewById(2131296669);
        final LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setText((CharSequence)"Work Experience");
        final ImageView imageView = (ImageView)view.findViewById(2131297340);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (senderLayout.getVisibility() == 0) {
                    senderLayout.setVisibility(8);
                    imageView.setImageResource(2131230974);
                } else {
                    senderLayout.setVisibility(0);
                    imageView.setImageResource(2131230973);
                }
            }
        });
        senderLayout.setVisibility(8);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.addExperienceView(jsonArray.getJSONObject(i), senderLayout);
        }
        this.mainLayout.addView(view);
    }

    private void addEducation(JSONArray jsonArray) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493243, null);
        TextView title = (TextView)view.findViewById(2131296669);
        final LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setText((CharSequence)"Education");
        final ImageView imageView = (ImageView)view.findViewById(2131297340);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (senderLayout.getVisibility() == 0) {
                    senderLayout.setVisibility(8);
                    imageView.setImageResource(2131230974);
                } else {
                    senderLayout.setVisibility(0);
                    imageView.setImageResource(2131230973);
                }
            }
        });
        senderLayout.setVisibility(8);
        for (int i = 0; i < jsonArray.length(); ++i) {
            this.addEducationsView(jsonArray.getJSONObject(i), senderLayout);
        }
        this.mainLayout.addView(view);
    }

    private void addPassport(JSONObject jsonObject) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493243, null);
        TextView title = (TextView)view.findViewById(2131296669);
        final LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        final ImageView imageView = (ImageView)view.findViewById(2131297340);
        imageView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (senderLayout.getVisibility() == 0) {
                    senderLayout.setVisibility(8);
                    imageView.setImageResource(2131230974);
                } else {
                    senderLayout.setVisibility(0);
                    imageView.setImageResource(2131230973);
                }
            }
        });
        senderLayout.setVisibility(8);
        title.setText((CharSequence)"Passport");
        this.addView(senderLayout, "Passport Number", jsonObject.getString("pass_number"));
        this.addView(senderLayout, "PassPort Type", jsonObject.getString("surname"));
        this.addView(senderLayout, "Place of Issue", jsonObject.getString("pass_Authority"));
        this.addView(senderLayout, "Issued Date", jsonObject.getString("pass_date_issue"));
        this.addView(senderLayout, "Expiry Date", jsonObject.getString("pass_expiry"));
        this.mainLayout.addView(view);
    }

    private void addAddressView1(JSONObject jsonObject, LinearLayout mainLayout) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493242, null);
        TextView title = (TextView)view.findViewById(2131296669);
        LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setText((CharSequence)"Permanant Address");
        this.addView(senderLayout, "No", jsonObject.getString("permanent_door"));
        this.addView(senderLayout, "Address 1", jsonObject.getString("permanent_addr1"));
        this.addView(senderLayout, "Address 2", jsonObject.getString("permanent_addr2"));
        this.addView(senderLayout, "Country", jsonObject.getString("permanent_country"));
        this.addView(senderLayout, "State", jsonObject.getString("permanent_state"));
        this.addView(senderLayout, "City", jsonObject.getString("permanent_city"));
        this.addView(senderLayout, "Poistal  code", jsonObject.getString("permanent_zipcode"));
        mainLayout.addView(view);
    }

    private void addAddressView2(JSONObject jsonObject, LinearLayout mainLayout) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493242, null);
        TextView title = (TextView)view.findViewById(2131296669);
        LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setText((CharSequence)"Present Address");
        this.addView(senderLayout, "No", jsonObject.getString("present_door"));
        this.addView(senderLayout, "Address 1", jsonObject.getString("present_addr1"));
        this.addView(senderLayout, "Address 2", jsonObject.getString("present_addr2"));
        this.addView(senderLayout, "Country", jsonObject.getString("present_country"));
        this.addView(senderLayout, "State", jsonObject.getString("present_state"));
        this.addView(senderLayout, "City", jsonObject.getString("present_city"));
        this.addView(senderLayout, "Poistal  code", jsonObject.getString("present_zipcode"));
        mainLayout.addView(view);
    }

    private void addEducationsView(JSONObject jsonObject, LinearLayout mainLayout) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493242, null);
        TextView title = (TextView)view.findViewById(2131296669);
        LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setVisibility(8);
        this.addView(senderLayout, "Institution Name", jsonObject.getString("institution_name"));
        this.addView(senderLayout, "Degree/Diploma", jsonObject.getString("degree"));
        this.addView(senderLayout, "Field of Study", jsonObject.getString("fieldofstudy"));
        this.addView(senderLayout, "Date of Completion", jsonObject.getString("dateofcompletion"));
        this.addView(senderLayout, "Additional Notes", jsonObject.getString("interests"));
        mainLayout.addView(view);
    }

    private void addExperienceView(JSONObject jsonObject, LinearLayout mainLayout) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493242, null);
        TextView title = (TextView)view.findViewById(2131296669);
        LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setVisibility(8);
        this.addView(senderLayout, "Company Name", jsonObject.getString("companyname"));
        this.addView(senderLayout, "Job Title", jsonObject.getString("jobtitle"));
        this.addView(senderLayout, "From Date", jsonObject.getString("from_date"));
        this.addView(senderLayout, "To Date", jsonObject.getString("to_date"));
        this.addView(senderLayout, "Job Description", jsonObject.getString("job_description"));
        mainLayout.addView(view);
    }

    private void addDependentView(JSONObject jsonObject, LinearLayout mainLayout) throws JSONException {
        View view = this.getLayoutInflater().inflate(2131493242, null);
        TextView title = (TextView)view.findViewById(2131296669);
        LinearLayout senderLayout = (LinearLayout)view.findViewById(2131296672);
        title.setVisibility(8);
        this.addView(senderLayout, "Name", jsonObject.getString("dependent_name"));
        this.addView(senderLayout, "Relationship", jsonObject.getString("relationship"));
        this.addView(senderLayout, "Mobile Number", jsonObject.getString("mobile"));
        mainLayout.addView(view);
    }

    private void addView(LinearLayout linearLayout, String titleText, String valueText) {
        View view = this.getLayoutInflater().inflate(2131493252, null);
        TextView title = (TextView)view.findViewById(2131297569);
        TextView value = (TextView)view.findViewById(2131297706);
        title.setText((CharSequence)titleText);
        value.setText((CharSequence)valueText);
        if (!valueText.equalsIgnoreCase("no data available") && !valueText.isEmpty()) {
            linearLayout.addView(view);
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

