/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus;

import android.annotation.TargetApi;
import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemClock;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.preference.RingtonePreference;
import android.text.TextUtils;
import android.view.MenuItem;
import android.widget.Toast;
import androidx.appcompat.app.ActionBar;
import androidx.core.app.NavUtils;
import com.b2lmobitech.fieldcloudplus.serviceold.AppCompatPreferenceActivity;
import com.b2lmobitech.fieldcloudplus.serviceold.locationbroadcast;
import java.util.List;

public class SettingsActivity
extends AppCompatPreferenceActivity {
    private Context mycontext;
    private static AlarmManager am;
    private static PendingIntent pendindintent;
    private static Preference.OnPreferenceChangeListener sBindPreferenceSummaryToValueListener;

    private static boolean isXLargeTablet(Context context) {
        return (context.getResources().getConfiguration().screenLayout & 0xF) >= 4;
    }

    private static void bindPreferenceSummaryToValue(Preference preference) {
        preference.setOnPreferenceChangeListener(sBindPreferenceSummaryToValueListener);
        sBindPreferenceSummaryToValueListener.onPreferenceChange(preference, (Object)PreferenceManager.getDefaultSharedPreferences((Context)preference.getContext()).getString(preference.getKey(), ""));
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setupActionBar();
        this.mycontext = this;
    }

    private void setupActionBar() {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
        }
    }

    public boolean onMenuItemSelected(int featureId, MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 16908332) {
            if (!super.onMenuItemSelected(featureId, item)) {
                NavUtils.navigateUpFromSameTask((Activity)this);
            }
            return true;
        }
        return super.onMenuItemSelected(featureId, item);
    }

    public boolean onIsMultiPane() {
        return SettingsActivity.isXLargeTablet((Context)this);
    }

    @TargetApi(value=11)
    public void onBuildHeaders(List<PreferenceActivity.Header> target) {
        this.loadHeadersFromResource(2132017157, target);
    }

    protected boolean isValidFragment(String fragmentName) {
        return PreferenceFragment.class.getName().equals(fragmentName) || DataSyncPreferenceFragment.class.getName().equals(fragmentName) || NotificationPreferenceFragment.class.getName().equals(fragmentName);
    }

    static {
        sBindPreferenceSummaryToValueListener = new Preference.OnPreferenceChangeListener(){

            public boolean onPreferenceChange(Preference preference, Object value) {
                String stringValue = value.toString();
                if (preference instanceof ListPreference) {
                    ListPreference listPreference = (ListPreference)preference;
                    int index = listPreference.findIndexOfValue(stringValue);
                    preference.setSummary(index >= 0 ? listPreference.getEntries()[index] : null);
                } else if (preference instanceof RingtonePreference) {
                    if (TextUtils.isEmpty((CharSequence)stringValue)) {
                        preference.setSummary(2131820697);
                    } else {
                        Ringtone ringtone = RingtoneManager.getRingtone((Context)preference.getContext(), (Uri)Uri.parse((String)stringValue));
                        if (ringtone == null) {
                            preference.setSummary(null);
                        } else {
                            String name = ringtone.getTitle(preference.getContext());
                            preference.setSummary((CharSequence)name);
                        }
                    }
                } else {
                    preference.setSummary((CharSequence)stringValue);
                }
                return true;
            }
        };
    }

    @TargetApi(value=11)
    public static class DataSyncPreferenceFragment
    extends PreferenceFragment {
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.addPreferencesFromResource(2132017155);
            this.setHasOptionsMenu(true);
            ListPreference locationfrequency = (ListPreference)this.findPreference("location_frequency");
            if (locationfrequency != null) {
                locationfrequency.setOnPreferenceChangeListener(new Preference.OnPreferenceChangeListener(){

                    public boolean onPreferenceChange(Preference preference, Object newValue) {
                        ListPreference listPreference = (ListPreference)preference;
                        int index = listPreference.findIndexOfValue(newValue.toString());
                        preference.setSummary(index >= 0 ? listPreference.getEntries()[index] : null);
                        this.frequency(Integer.valueOf(newValue.toString()));
                        return true;
                    }
                });
                sBindPreferenceSummaryToValueListener.onPreferenceChange(this.findPreference("location_frequency"), (Object)PreferenceManager.getDefaultSharedPreferences((Context)this.findPreference("location_frequency").getContext()).getString(this.findPreference("location_frequency").getKey(), ""));
            }
        }

        public boolean onOptionsItemSelected(MenuItem item) {
            int id2 = item.getItemId();
            if (id2 == 16908332) {
                this.startActivity(new Intent((Context)this.getActivity(), SettingsActivity.class));
                return true;
            }
            return super.onOptionsItemSelected(item);
        }

        private void frequency(int mins) {
            if (am != null) {
                am.cancel(pendindintent);
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)"Manual update of location enabled.", (int)1).show();
            }
            if (mins != 0) {
                Toast.makeText((Context)this.getActivity().getApplicationContext(), (CharSequence)"Done", (int)0).show();
                Intent intent = new Intent(this.getActivity().getApplicationContext(), locationbroadcast.class);
                pendindintent = PendingIntent.getBroadcast((Context)this.getActivity().getApplicationContext(), (int)0, (Intent)intent, (int)0);
                long firstTime = SystemClock.elapsedRealtime();
                am = (AlarmManager)this.getActivity().getApplicationContext().getSystemService("alarm");
                am.setRepeating(0, firstTime += 3000L, (long)(mins * 60 * 1000), pendindintent);
            }
        }
    }

    @TargetApi(value=11)
    public static class NotificationPreferenceFragment
    extends PreferenceFragment {
        public void onCreate(Bundle savedInstanceState) {
            super.onCreate(savedInstanceState);
            this.addPreferencesFromResource(2132017158);
            this.setHasOptionsMenu(true);
            SettingsActivity.bindPreferenceSummaryToValue(this.findPreference("notifications_new_message_ringtone"));
        }

        public boolean onOptionsItemSelected(MenuItem item) {
            int id2 = item.getItemId();
            if (id2 == 16908332) {
                this.startActivity(new Intent((Context)this.getActivity(), SettingsActivity.class));
                return true;
            }
            return super.onOptionsItemSelected(item);
        }
    }
}

