/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.hcm.AttendanceReport;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.attendancereportadapter;
import com.github.mikephil.charting.charts.HorizontalBarChart;
import com.github.mikephil.charting.data.BarData;
import com.github.mikephil.charting.data.BarDataSet;
import com.github.mikephil.charting.data.BarEntry;
import com.github.mikephil.charting.data.ChartData;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AttendanceReportDaily
extends AppCompatActivity {
    TextView total;
    TextView month;
    TextView present;
    TextView leave;
    TextView absent;
    TextView result;
    ListView attendancelv;
    private Context mycontext;
    private ProgressDialog pDialog;
    JSONArray employees = null;
    JSONParser jsonParser = new JSONParser();
    private static final String ALL_EMP_URL = "http://fieldcloud.in/App/get_allemployee.php";
    private static final String ATTENDANCE_EMP_URL = "http://fieldcloud.in/App/get_attendancereportdaily.php";
    private static final String LEAVE_EMP_URL = "http://fieldcloud.in/App/get_leavereportdaily.php";
    private static final String EMP_SUCCESS = "success";
    private static final String EMP_MESSAGE = "message";
    JSONArray products = null;
    String registeredcompany;
    String registeredemailid;
    String startdate = "";
    String enddate = "";
    int totalemp = 0;
    ActionBar ab;
    int first = 0;
    String[] collectpresent = null;
    String[] collectleave = null;
    String[] collectabsent = null;
    String[] presentdate = null;
    String[] leavefrom = null;
    String[] leaveto = null;
    MenuItem chart;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493082);
        this.mycontext = this;
        Intent intent = this.getIntent();
        this.startdate = intent.getStringExtra("startdate");
        this.enddate = intent.getStringExtra("enddate");
        this.total = (TextView)this.findViewById(2131297585);
        this.month = (TextView)this.findViewById(2131297024);
        this.present = (TextView)this.findViewById(2131297173);
        this.leave = (TextView)this.findViewById(2131296929);
        this.absent = (TextView)this.findViewById(2131296280);
        this.result = (TextView)this.findViewById(2131297274);
        this.attendancelv = (ListView)this.findViewById(2131296420);
        DisplayMetrics displaymetrics = new DisplayMetrics();
        this.getWindowManager().getDefaultDisplay().getMetrics(displaymetrics);
        int width = displaymetrics.widthPixels;
        int txtwidth = (width - 10) / 4;
        this.month.setWidth(txtwidth);
        this.present.setWidth(txtwidth);
        this.leave.setWidth(txtwidth);
        this.absent.setWidth(txtwidth);
        globalvariables.Logoutsharedpreference = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        this.registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        if (this.isNetworkAvailable()) {
            this.getSummary();
        } else {
            this.result.setVisibility(0);
            this.result.setText((CharSequence)"No Internet Connection");
            this.total.setVisibility(8);
            this.present.setVisibility(8);
            this.leave.setVisibility(8);
            this.month.setVisibility(8);
            this.attendancelv.setVisibility(8);
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(this.mycontext);
            alertdialog.setTitle((CharSequence)"No Internet Connection");
            alertdialog.setIcon(2131230915);
            alertdialog.setMessage((CharSequence)"Try Again!!");
            alertdialog.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    AttendanceReportDaily.this.finish();
                }
            }).create();
            alertdialog.show();
        }
        this.getSupportActionBar().setBackgroundDrawable((Drawable)new ColorDrawable(Color.parseColor((String)"#8bbb4b")));
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mycontext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (cm.getNetworkInfo(1).isConnectedOrConnecting()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public void onBackPressed() {
        Intent intent = new Intent(this.getApplicationContext(), AttendanceReport.class);
        intent.setFlags(0x4008000);
        this.startActivity(intent);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131558405, menu2);
        this.chart = menu2.findItem(2131296510);
        this.chart.setVisible(false);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        switch (id2) {
            case 2131296510: {
                this.setContentView(2131492924);
                HorizontalBarChart barChart = (HorizontalBarChart)this.findViewById(2131296510);
                ArrayList<BarEntry> bargroup1 = new ArrayList<BarEntry>();
                for (int i = 0; i < this.presentdate.length; ++i) {
                    bargroup1.add(new BarEntry((float)Double.parseDouble(this.collectpresent[i]), i));
                }
                ArrayList<BarEntry> bargroup2 = new ArrayList<BarEntry>();
                for (int i = 0; i < this.presentdate.length; ++i) {
                    bargroup2.add(new BarEntry((float)Double.parseDouble(this.collectleave[i]), i));
                }
                ArrayList<BarEntry> bargroup3 = new ArrayList<BarEntry>();
                for (int i = 0; i < this.presentdate.length; ++i) {
                    bargroup3.add(new BarEntry((float)Double.parseDouble(this.collectabsent[i]), i));
                }
                BarDataSet barDataSet1 = new BarDataSet(bargroup1, "Present");
                barDataSet1.setColor(Color.rgb((int)0, (int)155, (int)0));
                BarDataSet barDataSet2 = new BarDataSet(bargroup2, "Leave");
                barDataSet2.setColor(Color.rgb((int)0, (int)0, (int)155));
                BarDataSet barDataSet3 = new BarDataSet(bargroup3, "Absent");
                barDataSet3.setColor(Color.rgb((int)155, (int)0, (int)0));
                ArrayList<String> labels = new ArrayList<String>();
                for (int i = 0; i < this.presentdate.length; ++i) {
                    labels.add(this.presentdate[i]);
                }
                ArrayList<BarDataSet> dataSets = new ArrayList<BarDataSet>();
                dataSets.add(barDataSet1);
                dataSets.add(barDataSet2);
                dataSets.add(barDataSet3);
                BarData data = new BarData(labels, dataSets);
                barChart.setData((ChartData)data);
                break;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private ArrayList<String> getXAxisValues() {
        ArrayList<String> labels = new ArrayList<String>();
        for (int i = 0; i < this.presentdate.length; ++i) {
            labels.add(this.presentdate[i]);
        }
        return labels;
    }

    private void getSummary() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("startdate", this.startdate);
        params.put("enddate", this.enddate);
        params.put("companyname", this.registeredcompany);
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_attendancesummary.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    AttendanceReportDaily.this.setSummary(jsonObject);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setSummary(JSONObject jsonObject) throws JSONException {
        this.totalemp = jsonObject.getJSONArray("emp").length();
        if (this.totalemp == 0) {
            this.result.setVisibility(0);
            this.result.setText((CharSequence)"No Employees Added");
            this.total.setVisibility(8);
            this.present.setVisibility(8);
            this.leave.setVisibility(8);
            this.month.setVisibility(8);
            this.attendancelv.setVisibility(8);
            return;
        }
        JSONArray present = jsonObject.getJSONArray("present");
        if (present.length() != 0) {
            int count = present.length();
            this.collectpresent = new String[count];
            this.collectleave = new String[count];
            this.collectabsent = new String[count];
            this.presentdate = new String[count];
            for (int i = 0; i < count; ++i) {
                JSONObject photoobj = present.getJSONObject(i);
                this.collectpresent[i] = photoobj.getString("present");
                this.collectleave[i] = "0";
                this.collectabsent[i] = "0";
                this.presentdate[i] = photoobj.getString("date");
            }
        } else {
            this.result.setVisibility(0);
            this.result.setText((CharSequence)"No Results!!");
            this.total.setVisibility(8);
            this.present.setVisibility(8);
            this.leave.setVisibility(8);
            this.absent.setVisibility(8);
            this.month.setVisibility(8);
            this.attendancelv.setVisibility(8);
            this.chart.setVisible(false);
            return;
        }
        JSONArray leaves = jsonObject.getJSONArray("leaves");
        if (leaves.length() != 0) {
            int count = leaves.length();
            this.leavefrom = new String[count];
            this.leaveto = new String[count];
            for (int i = 0; i < count; ++i) {
                JSONObject photoobj = leaves.getJSONObject(i);
                this.leavefrom[i] = photoobj.getString("leavefrom");
                this.leaveto[i] = photoobj.getString("leaveto");
            }
        }
        this.setViews();
    }

    private void setViews() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        if (this.presentdate != null && this.leavefrom != null) {
            int i;
            this.collectleave = null;
            this.collectleave = new String[this.presentdate.length];
            this.collectabsent = null;
            this.collectabsent = new String[this.presentdate.length];
            for (i = 0; i < this.presentdate.length; ++i) {
                this.collectleave[i] = "0";
                this.collectabsent[i] = "0";
            }
            for (i = 0; i < this.presentdate.length; ++i) {
                int leave = 0;
                for (int j = 0; j < this.leavefrom.length; ++j) {
                    try {
                        if (sdf.parse(this.presentdate[i]).compareTo(sdf.parse(this.leavefrom[j])) <= 0 && sdf.parse(this.presentdate[i]).compareTo(sdf.parse(this.leavefrom[j])) != 0 || sdf.parse(this.presentdate[i]).compareTo(sdf.parse(this.leaveto[j])) >= 0 && sdf.parse(this.presentdate[i]).compareTo(sdf.parse(this.leaveto[j])) != 0) continue;
                        this.collectleave[i] = String.valueOf(++leave);
                        continue;
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
            this.total.setText((CharSequence)("Total employees: " + String.valueOf(this.totalemp)));
            for (i = 0; i < this.presentdate.length; ++i) {
                int absent = this.totalemp - (Integer.parseInt(this.collectpresent[i]) + Integer.parseInt(this.collectleave[i]));
                this.collectabsent[i] = String.valueOf(absent);
            }
            attendancereportadapter adapter2 = new attendancereportadapter((Activity)this, this.presentdate, this.collectpresent, this.collectleave, this.collectabsent);
            this.attendancelv.setAdapter((ListAdapter)adapter2);
            this.chart.setVisible(true);
        } else if (this.presentdate != null && this.leavefrom == null) {
            for (int i = 0; i < this.presentdate.length; ++i) {
                int absent = this.totalemp - (Integer.parseInt(this.collectpresent[i]) + Integer.parseInt(this.collectleave[i]));
                this.collectabsent[i] = String.valueOf(absent);
            }
            this.total.setText((CharSequence)("Total employees: " + String.valueOf(this.totalemp)));
            attendancereportadapter adapter3 = new attendancereportadapter((Activity)this, this.presentdate, this.collectpresent, this.collectleave, this.collectabsent);
            this.attendancelv.setAdapter((ListAdapter)adapter3);
            this.chart.setVisible(true);
        } else {
            this.result.setVisibility(0);
            this.result.setText((CharSequence)"No Results!!");
            this.total.setVisibility(8);
            this.present.setVisibility(8);
            this.leave.setVisibility(8);
            this.absent.setVisibility(8);
            this.month.setVisibility(8);
            this.attendancelv.setVisibility(8);
            this.chart.setVisible(false);
        }
    }
}

