/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.emp_timesheetadapter;
import com.google.android.material.snackbar.Snackbar;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Employee_Timesheet
extends AppCompatActivity {
    private Context mycontext;
    private String registeredcompany = "";
    private String todaydate = "";
    private String registeredemailid = "";
    private sqldatabase mDbHelper;
    private ListView list;
    private emp_timesheetadapter adapter;
    private ArrayList<String> timesheetdates;
    private ArrayList<String> teams;
    private ArrayList<String> starttimes;
    private ArrayList<String> endtimes;
    private ArrayList<String> activities;
    private TextView nohistory;
    private Snackbar snackBar;
    int status = 0;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492927);
        Toolbar toolbar = (Toolbar)this.findViewById(2131297581);
        this.setSupportActionBar(toolbar);
        this.mycontext = this;
        this.mDbHelper = new sqldatabase(this.mycontext);
        this.timesheetdates = new ArrayList();
        this.teams = new ArrayList();
        this.starttimes = new ArrayList();
        this.endtimes = new ArrayList();
        this.activities = new ArrayList();
        ProgressBar progressbar = (ProgressBar)this.findViewById(2131297189);
        this.list = (ListView)this.findViewById(2131296502);
        this.nohistory = (TextView)this.findViewById(2131297101);
        this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
        SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd");
        this.todaydate = dateFormatter.format(new Date());
        globalvariables.Logoutsharedpreference = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        Intent intent = this.getIntent();
        this.registeredemailid = intent.getStringExtra("emp_mail");
        if (this.isNetworkAvailable()) {
            this.nohistory.setVisibility(8);
            this.getData();
        } else {
            this.snackBar.dismiss();
            this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
            this.toast();
        }
    }

    protected void onResume() {
        super.onResume();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131558406, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
            }
        }
        return true;
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mycontext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (cm.getNetworkInfo(1).isConnectedOrConnecting()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    protected void onDestroy() {
        this.mDbHelper.close();
        super.onDestroy();
    }

    private void toast() {
        this.snackBar.setAction((CharSequence)"CLOSE", new View.OnClickListener(){

            public void onClick(View v) {
                Employee_Timesheet.this.snackBar.dismiss();
            }
        }).setActionTextColor(this.getResources().getColor(17170451)).show();
    }

    private void getData() {
        Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please wait..", (int)0).setAction((CharSequence)"Action", null).show();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("date", DateUtils.getCurrentDate());
        params.put("companyname", this.registeredcompany);
        params.put("employeemailid", this.registeredemailid);
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_employee_timesheet.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    Employee_Timesheet.this.setData(jsonObject);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setData(JSONObject jsonObjec) throws JSONException {
        JSONArray jsonArray = jsonObjec.getJSONArray("list");
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject object = jsonArray.getJSONObject(i);
            this.timesheetdates.add(object.getString("timesheetdate"));
            this.teams.add(object.getString("attendenceteam"));
            this.activities.add(object.getString("activity"));
            this.starttimes.add(object.getString("starttime"));
            this.endtimes.add(object.getString("endtime"));
        }
        if (jsonArray.length() != 0) {
            emp_timesheetadapter adapter2 = new emp_timesheetadapter(this.mycontext, this.timesheetdates, this.teams, this.starttimes, this.endtimes, this.activities);
            this.list.setAdapter((ListAdapter)adapter2);
        } else {
            this.nohistory.setVisibility(0);
            this.nohistory.setText((CharSequence)"Not yet Added Timesheet!!");
        }
        this.snackBar.dismiss();
    }
}

