/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.leaveadapter;
import com.b2lmobitech.fieldcloudplus.hcm.leaveapply;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class Leaveactivity
extends AppCompatActivity
implements leaveadapter.leaveListener {
    private FloatingActionButton fab;
    private FloatingActionButton fab1;
    private FloatingActionButton fab2;
    private Context mycontext;
    private Animation fab_open;
    private Animation fab_close;
    private Animation rotate_forward;
    private Animation rotate_backward;
    private Boolean isFabOpen = false;
    private TextView addcalendartext;
    private TextView applyleavetext;
    private TextView history;
    private TextView pull;
    private ImageView refreshicon;
    private String registeredcompany;
    private String registeredemailid;
    private Snackbar snackBar;
    private ListView leavelistview;
    private ArrayList<String> status;
    private ArrayList<String> leavedays;
    private ArrayList<String> permissioninminutes;
    private ArrayList<String> leavefrom;
    private ArrayList<String> leaveto;
    private ArrayList<String> permissionfrom;
    private ArrayList<String> permissionto;
    private ArrayList<String> leavetype;
    private ArrayList<String> applieddateandtime;
    private ArrayList<String> leavereason;
    private ArrayList<String> rejectedreason;
    private ArrayList<String> optionfordelete;
    private ArrayList<String> synctoshow;
    private SwipeRefreshLayout swipeContainer;
    private sqldatabase mDbHelper;
    private ArrayList<String> selectleavetype;
    private ArrayList<String> selectstatustype;
    private String selectedleavetype = "";
    private String selectedstatustype = "";
    public ProgressBar progressBar;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492955);
        Toolbar toolbar = (Toolbar)this.findViewById(2131297581);
        this.setSupportActionBar(toolbar);
        this.mycontext = this;
        this.mDbHelper = new sqldatabase(this.mycontext);
        globalvariables.Logoutsharedpreference = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        this.registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.status = new ArrayList();
        this.leavedays = new ArrayList();
        this.permissioninminutes = new ArrayList();
        this.leavefrom = new ArrayList();
        this.leaveto = new ArrayList();
        this.permissionfrom = new ArrayList();
        this.permissionto = new ArrayList();
        this.leavetype = new ArrayList();
        this.applieddateandtime = new ArrayList();
        this.leavereason = new ArrayList();
        this.rejectedreason = new ArrayList();
        this.selectleavetype = new ArrayList();
        this.selectstatustype = new ArrayList();
        this.optionfordelete = new ArrayList();
        this.synctoshow = new ArrayList();
        this.getWidgets();
        this.setListeners();
        this.setAdapter();
        this.getLeaves();
    }

    protected void onRestart() {
        super.onRestart();
        this.setAdapter();
        this.syncData();
    }

    private void getWidgets() {
        this.fab = (FloatingActionButton)this.findViewById(2131296752);
        this.fab1 = (FloatingActionButton)this.findViewById(2131296753);
        this.fab2 = (FloatingActionButton)this.findViewById(2131296754);
        this.fab_open = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130771997);
        this.fab_close = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130771996);
        this.rotate_forward = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130772007);
        this.rotate_backward = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130772006);
        this.applyleavetext = (TextView)this.findViewById(2131296391);
        this.addcalendartext = (TextView)this.findViewById(2131296359);
        this.leavelistview = (ListView)this.findViewById(2131296935);
        this.history = (TextView)this.findViewById(2131296827);
        this.refreshicon = (ImageView)this.findViewById(2131297248);
        this.pull = (TextView)this.findViewById(2131297206);
        this.swipeContainer = (SwipeRefreshLayout)this.findViewById(2131297440);
        this.progressBar = (ProgressBar)this.findViewById(2131297189);
    }

    private void setListeners() {
        this.fab1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent(Leaveactivity.this.mycontext, leaveapply.class);
                Leaveactivity.this.startActivity(intent);
            }
        });
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Leaveactivity.this.animateFAB();
            }
        });
        this.swipeContainer.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                Leaveactivity.this.snackBar.dismiss();
                if (Leaveactivity.this.isNetworkAvailable()) {
                    Leaveactivity.this.getLeaves();
                } else {
                    Leaveactivity.this.setAdapter();
                }
                Leaveactivity.this.swipeContainer.setRefreshing(false);
            }
        });
        this.fab2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Leaveactivity.this.showLeaveFilter();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131558411, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 2131296931) {
            try {
                if (this.isNetworkAvailable()) {
                    this.syncData();
                    this.snackBar.dismiss();
                } else {
                    this.toast();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void animateFAB() {
        if (this.isFabOpen.booleanValue()) {
            this.fab.startAnimation(this.rotate_backward);
            this.fab1.startAnimation(this.fab_close);
            this.fab2.startAnimation(this.fab_close);
            this.applyleavetext.setVisibility(8);
            this.addcalendartext.setVisibility(8);
            this.fab1.setClickable(false);
            this.fab2.setClickable(false);
            this.isFabOpen = false;
        } else {
            this.fab.startAnimation(this.rotate_forward);
            this.fab1.startAnimation(this.fab_open);
            this.fab2.startAnimation(this.fab_open);
            this.applyleavetext.setVisibility(0);
            this.addcalendartext.setVisibility(0);
            this.fab1.setClickable(true);
            this.fab2.setClickable(true);
            this.isFabOpen = true;
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mycontext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (cm.getNetworkInfo(1).isConnectedOrConnecting()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private void toast() {
        this.snackBar.setAction((CharSequence)"CLOSE", new View.OnClickListener(){

            public void onClick(View v) {
                Leaveactivity.this.snackBar.dismiss();
            }
        }).setActionTextColor(this.getResources().getColor(17170451)).show();
    }

    protected void onDestroy() {
        this.mDbHelper.close();
        super.onDestroy();
    }

    private void getLeaves() {
        final HcmDatabase hcmDatabase = HcmDatabase.getInstance((Context)this);
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("email", preference.getEmailId());
        params.put("companyname", preference.getCompanyName());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_leavefull.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        hcmDatabase.insertLeaves(jsonObject.getJSONArray("list"));
                    }
                    Leaveactivity.this.setAdapter();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private String displaydelete(String syncvalue, String statusvalue, String leavetype, String permissiondate, String permissionstarttime, String leavestartdate) {
        String deleteicon;
        block13: {
            deleteicon = "No";
            if (syncvalue.equalsIgnoreCase("No")) {
                deleteicon = "Yes";
            } else if (statusvalue.equalsIgnoreCase("rejected")) {
                deleteicon = "No";
            } else if (leavetype.equalsIgnoreCase("Permission")) {
                SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
                String todaydate = sdf2.format(new Date());
                String todaytime = sdf.format(new Date());
                if (todaydate.equals(permissiondate)) {
                    try {
                        Date date1 = sdf.parse(todaytime);
                        Date date2 = sdf.parse(permissionstarttime);
                        long difference = date2.getTime() - date1.getTime();
                        int days = (int)(difference / 86400000L);
                        int hours = (int)((difference - (long)(86400000 * days)) / 3600000L);
                        int min = (int)(difference - (long)(86400000 * days) - (long)(3600000 * hours)) / 60000;
                        if (min > 0) {
                            deleteicon = "Yes";
                            break block13;
                        }
                        deleteicon = "No";
                    }
                    catch (Exception e) {
                        deleteicon = "No";
                    }
                } else {
                    deleteicon = "No";
                }
            } else {
                SimpleDateFormat sdf3 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String todaydateandtime = sdf3.format(new Date());
                try {
                    Date date3 = sdf3.parse(todaydateandtime);
                    Date date4 = sdf3.parse(leavestartdate + " 10:00:00");
                    long difference = date4.getTime() - date3.getTime();
                    int days = (int)(difference / 86400000L);
                    int hours = (int)((difference - (long)(86400000 * days)) / 3600000L);
                    int min = (int)(difference - (long)(86400000 * days) - (long)(3600000 * hours)) / 60000;
                    deleteicon = min > 0 ? "Yes" : "No";
                }
                catch (Exception e) {
                    deleteicon = "No";
                }
            }
        }
        return deleteicon;
    }

    private void setAdapter() {
        Cursor leavecursor = this.mDbHelper.get_leavetable(this.registeredcompany, this.registeredemailid);
        this.setAdapter(leavecursor);
    }

    private void setAdapter(Cursor leavecursor) {
        this.status.clear();
        this.leavedays.clear();
        this.permissioninminutes.clear();
        this.leavefrom.clear();
        this.leaveto.clear();
        this.permissionfrom.clear();
        this.permissionto.clear();
        this.leavereason.clear();
        this.rejectedreason.clear();
        this.optionfordelete.clear();
        this.applieddateandtime.clear();
        this.leavetype.clear();
        if (leavecursor != null && leavecursor.moveToFirst()) {
            do {
                this.status.add(leavecursor.getString(leavecursor.getColumnIndex("status")));
                this.leavedays.add(leavecursor.getString(leavecursor.getColumnIndex("leavedays")));
                this.permissioninminutes.add(leavecursor.getString(leavecursor.getColumnIndex("permissioninminutes")));
                this.leavefrom.add(leavecursor.getString(leavecursor.getColumnIndex("leavefrom")));
                this.leaveto.add(leavecursor.getString(leavecursor.getColumnIndex("leaveto")));
                this.permissionfrom.add(leavecursor.getString(leavecursor.getColumnIndex("permissionfrom")));
                this.permissionto.add(leavecursor.getString(leavecursor.getColumnIndex("permissionto")));
                this.leavetype.add(leavecursor.getString(leavecursor.getColumnIndex("leavetype")));
                this.applieddateandtime.add(leavecursor.getString(leavecursor.getColumnIndex("appliedateandtime")));
                this.leavereason.add(leavecursor.getString(leavecursor.getColumnIndex("reasonforleaveorpermission")));
                this.rejectedreason.add(leavecursor.getString(leavecursor.getColumnIndex("rejectedreason")));
                this.optionfordelete.add(this.displaydelete(leavecursor.getString(leavecursor.getColumnIndex("SYNC")), leavecursor.getString(leavecursor.getColumnIndex("status")), leavecursor.getString(leavecursor.getColumnIndex("leavetype")), leavecursor.getString(leavecursor.getColumnIndex("permissiondate")), leavecursor.getString(leavecursor.getColumnIndex("permissionfrom")), leavecursor.getString(leavecursor.getColumnIndex("leavefrom"))));
                this.synctoshow.add(leavecursor.getString(leavecursor.getColumnIndex("SYNC")));
            } while (leavecursor.moveToNext());
            this.history.setVisibility(8);
            this.refreshicon.setVisibility(8);
            this.pull.setVisibility(8);
            leaveadapter adapter2 = new leaveadapter(this.mycontext, this.status, this.leavedays, this.permissioninminutes, this.leavefrom, this.leaveto, this.permissionfrom, this.permissionto, this.leavetype, this.applieddateandtime, this.leavereason, this.rejectedreason, this.optionfordelete, this.synctoshow);
            Parcelable parcelable = this.leavelistview.onSaveInstanceState();
            this.leavelistview.setAdapter((ListAdapter)adapter2);
            if (parcelable != null) {
                this.leavelistview.onRestoreInstanceState(parcelable);
            }
            this.leavelistview.setVisibility(0);
        } else {
            this.history.setVisibility(0);
            this.refreshicon.setVisibility(0);
            this.pull.setVisibility(0);
            this.leavelistview.setVisibility(8);
        }
    }

    private void showLeaveFilter() {
        AlertDialog.Builder dialogBuilder = new AlertDialog.Builder(this.mycontext);
        LayoutInflater inflater = (LayoutInflater)this.mycontext.getSystemService("layout_inflater");
        View dialogView = inflater.inflate(2131493134, null);
        dialogBuilder.setView(dialogView);
        final Spinner leavetypespinner = (Spinner)dialogView.findViewById(2131296946);
        final Spinner statustypespinner = (Spinner)dialogView.findViewById(2131297420);
        Button cancel = (Button)dialogView.findViewById(2131296474);
        Button apply = (Button)dialogView.findViewById(2131296390);
        final AlertDialog alertDialog = dialogBuilder.create();
        alertDialog.show();
        this.selectleavetype.clear();
        this.selectleavetype.add("Select Leave type");
        this.selectleavetype.add("All");
        this.selectleavetype.add("Permission");
        this.selectleavetype.add("Sick Leave");
        this.selectleavetype.add("Casual Leave");
        this.selectleavetype.add("Earned Leave");
        ArrayAdapter leavetypeAdapter = new ArrayAdapter(this.mycontext, 17367048, this.selectleavetype);
        leavetypeAdapter.setDropDownViewResource(0x1090009);
        leavetypespinner.setAdapter((SpinnerAdapter)leavetypeAdapter);
        this.selectstatustype.clear();
        this.selectstatustype.add("Select Status type");
        this.selectstatustype.add("All");
        this.selectstatustype.add("accepted");
        this.selectstatustype.add("rejected");
        this.selectstatustype.add("pending");
        ArrayAdapter statustypeAdapter = new ArrayAdapter(this.mycontext, 17367048, this.selectstatustype);
        statustypeAdapter.setDropDownViewResource(0x1090009);
        statustypespinner.setAdapter((SpinnerAdapter)statustypeAdapter);
        leavetypespinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                Leaveactivity.this.selectedleavetype = leavetypespinner.getSelectedItem().toString();
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        statustypespinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> parent, View view, int position, long id2) {
                Leaveactivity.this.selectedstatustype = statustypespinner.getSelectedItem().toString();
            }

            public void onNothingSelected(AdapterView<?> parent) {
            }
        });
        cancel.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                alertDialog.dismiss();
            }
        });
        apply.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Leaveactivity.this.snackBar.dismiss();
                if (Leaveactivity.this.selectedleavetype.equalsIgnoreCase("Select Leave type") || Leaveactivity.this.selectedstatustype.equalsIgnoreCase("Select Status type")) {
                    Toast.makeText((Context)Leaveactivity.this.mycontext, (CharSequence)"All fields are manditory", (int)1).show();
                } else {
                    try {
                        alertDialog.dismiss();
                        Cursor showcursor = Leaveactivity.this.mDbHelper.get_leavetable_filter(Leaveactivity.this.registeredcompany, Leaveactivity.this.registeredemailid, Leaveactivity.this.selectedleavetype, Leaveactivity.this.selectedstatustype);
                        Leaveactivity.this.setAdapter(showcursor);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
    }

    private void syncData() {
        final HcmDatabase hcmDatabase = HcmDatabase.getInstance((Context)this);
        this.snackBar.dismiss();
        Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please wait..", (int)-1).setAction((CharSequence)"Action", null).show();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("JSON", hcmDatabase.getLeavesNotSynced().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/insert_leaves.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    hcmDatabase.updateLeavesSynced(jsonObject.getJSONArray("list"));
                    Leaveactivity.this.getLeaves();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @Override
    public void deleteLeave(final String type, final String datetime) {
        final HcmDatabase hcmDatabase = HcmDatabase.getInstance((Context)this);
        Preference preference = Preference.getInstance((Context)this);
        this.snackBar.dismiss();
        Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please wait..", (int)-1).setAction((CharSequence)"Action", null).show();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("companyname", preference.getCompanyName());
        params.put("employeemailid", preference.getEmailId());
        params.put("leavetype", type);
        params.put("appliedateandtime", datetime);
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/delete_leave.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    Leaveactivity.this.snackBar.dismiss();
                    if (jsonObject.getInt("s") == 1) {
                        hcmDatabase.updateLeaveDeleted(type, datetime);
                    }
                    Leaveactivity.this.setAdapter();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

