/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.database.Cursor;
import android.location.Address;
import android.location.Geocoder;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Looper;
import android.os.Parcelable;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageButton;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.app.ActivityCompat;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.locationadapter;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.impl.client.DefaultHttpClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Location
extends AppCompatActivity
implements GoogleApiClient.OnConnectionFailedListener {
    private Context mycontext;
    private Animation fab_open;
    private Animation fab_close;
    private Animation rotate_forward;
    private Animation rotate_backward;
    private Boolean isFabOpen = false;
    private FloatingActionButton fab;
    private FloatingActionButton addfab;
    private FloatingActionButton viewfab;
    private boolean isBottom = false;
    private RelativeLayout locationsublayout;
    private ListView locationlistview;
    private ArrayList<String> date;
    private ArrayList<String> locationval;
    private ArrayList<String> customcheckin;
    private ArrayList<String> time;
    private ArrayList<String> syncval;
    private ImageButton autolocater;
    private TextView locationdetail;
    private TextView explanation;
    private TextView locationhistory;
    private TextView addlocationtext;
    private TextView addcalendartext;
    private Boolean autolocaterclick = false;
    private SimpleDateFormat sdf;
    private SimpleDateFormat sdf2;
    private sqldatabase mDbHelper;
    private String registeredemailid;
    private String registeredcompany;
    private String table_latitude = "0.0";
    private String table_longitude;
    private String table_location;
    private String table_date = " ";
    private String table_time = " ";
    private String table_checkinname = "";
    private String month;
    private String day;
    private boolean running = false;
    private String currentlocation = "Not found";
    private Double currentlocationlaltitue = 0.0;
    private Double currentlocationlongitude = 0.0;
    private List<Address> addresses = null;
    private static final HttpClient ANDROID_HTTP_CLIENT = new DefaultHttpClient();
    private Button okbutton;
    private Button cancelbutton;
    private EditText checkinname;
    private SwipeRefreshLayout swipeContainer;
    private Snackbar snackBar;
    GoogleApiClient mGoogleApiClient;
    FusedLocationProviderClient mFusedLocationClient;
    LocationRequest mLocationRequest;
    private long UPDATE_INTERVAL = 10000L;
    private long FASTEST_INTERVAL = 1000L;
    LocationManager locationManager;
    private CoordinatorLayout coordinatorLayout;
    LocationCallback mLocationCallback = new LocationCallback(){

        public void onLocationResult(LocationResult locationResult) {
            for (android.location.Location location : locationResult.getLocations()) {
                Log.i((String)"MapsActivity", (String)("Location: " + location.getLatitude() + " " + location.getLongitude()));
                android.location.Location mLastLocation = location;
                Log.e((String)"Location", (String)(mLastLocation.getLatitude() + "" + mLastLocation.getLongitude()));
            }
        }
    };

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492960);
        Toolbar toolbar = (Toolbar)this.findViewById(2131297581);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.fab = (FloatingActionButton)this.findViewById(2131296973);
        this.addfab = (FloatingActionButton)this.findViewById(2131296362);
        this.addlocationtext = (TextView)this.findViewById(2131296363);
        this.viewfab = (FloatingActionButton)this.findViewById(2131297345);
        this.addcalendartext = (TextView)this.findViewById(2131296359);
        this.locationsublayout = (RelativeLayout)this.findViewById(2131296982);
        this.locationlistview = (ListView)this.findViewById(2131296980);
        this.autolocater = (ImageButton)this.findViewById(2131296426);
        this.locationdetail = (TextView)this.findViewById(2131296972);
        this.explanation = (TextView)this.findViewById(2131296749);
        this.locationhistory = (TextView)this.findViewById(2131296976);
        this.okbutton = (Button)this.findViewById(2131297114);
        this.cancelbutton = (Button)this.findViewById(2131296474);
        this.checkinname = (EditText)this.findViewById(2131296511);
        this.date = new ArrayList();
        this.locationval = new ArrayList();
        this.customcheckin = new ArrayList();
        this.time = new ArrayList();
        this.syncval = new ArrayList();
        this.mycontext = this;
        this.mDbHelper = new sqldatabase(this.mycontext);
        globalvariables.Logoutsharedpreference = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        this.registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        this.swipeContainer = (SwipeRefreshLayout)this.findViewById(2131297440);
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Location.this.animateFAB();
            }
        });
        this.addfab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (Location.this.isBottom) {
                    Location.this.locationsublayout.setVisibility(8);
                    Location.this.isBottom = false;
                } else {
                    Location.this.locationsublayout.setVisibility(0);
                    Location.this.isBottom = true;
                }
            }
        });
        this.viewfab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Calendar c = Calendar.getInstance();
                int mYear = c.get(1);
                int mMonth = c.get(2);
                int mDay = c.get(5);
                DatePickerDialog datePickerDialog = new DatePickerDialog(Location.this.mycontext, new DatePickerDialog.OnDateSetListener(){

                    public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                        if (++monthOfYear < 10) {
                            Location.this.month = "0" + monthOfYear;
                        } else {
                            Location.this.month = "" + monthOfYear;
                        }
                        if (dayOfMonth < 10) {
                            Location.this.day = "0" + dayOfMonth;
                        } else {
                            Location.this.day = "" + dayOfMonth;
                        }
                        Cursor locationlist_cursor = Location.this.mDbHelper.get_location_datewise(Location.this.registeredcompany, Location.this.registeredemailid, year + "-" + Location.this.month + "-" + Location.this.day);
                        Location.this.setAdapter(locationlist_cursor);
                    }
                }, mYear, mMonth, mDay);
                datePickerDialog.show();
            }
        });
        this.autolocater.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Location.this.findlocation();
            }
        });
        this.okbutton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Location.this.table_checkinname = Location.this.checkinname.getText().toString();
                try {
                    Cursor locationcursor = Location.this.mDbHelper.get_location_duplicacy(Location.this.registeredcompany, Location.this.registeredemailid, Location.this.table_date, Location.this.table_time);
                    if (locationcursor.getCount() == 0) {
                        if (Location.this.locationdetail.getText().equals("")) {
                            Location.this.showSnack("please click autolocate", true);
                        } else {
                            if (Location.this.currentlocation.equalsIgnoreCase("Not found") || Location.this.currentlocation.equalsIgnoreCase("ot foun")) {
                                Location.this.mDbHelper.insert_locationtable(Location.this.registeredcompany, Location.this.registeredemailid, Location.this.table_latitude + "," + Location.this.table_longitude, Location.this.table_checkinname, Location.this.table_latitude, Location.this.table_longitude, Location.this.table_date, Location.this.table_time, "No");
                                Location.this.explanation.setText((CharSequence)("You have successfully 'In' at " + Location.this.sdf.format(new Date()) + " from " + Location.this.currentlocationlaltitue + "," + Location.this.currentlocationlongitude));
                            } else {
                                Location.this.mDbHelper.insert_locationtable(Location.this.registeredcompany, Location.this.registeredemailid, Location.this.table_location, Location.this.table_checkinname, Location.this.table_latitude, Location.this.table_longitude, Location.this.table_date, Location.this.table_time, "No");
                                Location.this.explanation.setText((CharSequence)("You have successfully 'In' at " + Location.this.sdf.format(new Date()) + " from " + Location.this.currentlocation));
                            }
                            Location.this.setAdapter();
                            try {
                                if (Location.this.isNetworkAvailable()) {
                                    Location.this.syncData();
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    } else if (Location.this.locationdetail.getText().equals("")) {
                        Location.this.showSnack("please click autolocate", true);
                    } else {
                        Location.this.showSnack("Data is already entered", true);
                    }
                    locationcursor.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.cancelbutton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Location.this.checkinname.getText().clear();
                Location.this.locationdetail.setText((CharSequence)"");
                Location.this.explanation.setText((CharSequence)"");
                if (Location.this.isBottom) {
                    Location.this.locationsublayout.setVisibility(8);
                    Location.this.isBottom = false;
                } else {
                    Location.this.locationsublayout.setVisibility(0);
                    Location.this.isBottom = true;
                }
            }
        });
        this.swipeContainer.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                Location.this.setAdapter();
            }
        });
        this.setAdapter();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(2131558412, menu2);
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        int id2 = item.getItemId();
        if (id2 == 2131296969) {
            try {
                if (this.isNetworkAvailable()) {
                    this.syncData();
                } else {
                    this.showSnack("Please check internet connection", true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void animateFAB() {
        this.fab_open = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130771997);
        this.fab_close = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130771996);
        this.rotate_forward = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130772007);
        this.rotate_backward = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130772006);
        if (this.isFabOpen.booleanValue()) {
            this.fab.startAnimation(this.rotate_backward);
            this.addfab.startAnimation(this.fab_close);
            this.addlocationtext.setVisibility(8);
            this.addcalendartext.setVisibility(8);
            this.viewfab.startAnimation(this.fab_close);
            this.addfab.setClickable(false);
            this.viewfab.setClickable(false);
            this.isFabOpen = false;
        } else {
            this.fab.startAnimation(this.rotate_forward);
            this.addfab.startAnimation(this.fab_open);
            this.addlocationtext.setVisibility(0);
            this.addcalendartext.setVisibility(0);
            this.viewfab.startAnimation(this.fab_open);
            this.addfab.setClickable(true);
            this.viewfab.setClickable(true);
            this.isFabOpen = true;
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mycontext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (cm.getNetworkInfo(1).isConnectedOrConnecting()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    public void findlocation() {
        this.locationManager = (LocationManager)this.getSystemService("location");
        boolean isGPSEnabled = this.locationManager.isProviderEnabled("gps");
        boolean isNetworkEnabled = this.locationManager.isProviderEnabled("network");
        if (!isGPSEnabled || !isNetworkEnabled) {
            String message = "";
            String positivebutton = "";
            String title = "";
            AlertDialog.Builder alertdialog = new AlertDialog.Builder((Context)this);
            alertdialog.setIcon(2131230915);
            alertdialog.setCancelable(false);
            if (!isGPSEnabled && !isNetworkEnabled) {
                message = "No location provider is enabled for location access!!";
                positivebutton = "Turn On";
                title = "Enable Lcoation";
            } else {
                message = "Change Lcoation accuracy to high";
                positivebutton = "Change";
                title = "Accuracy is Low";
            }
            alertdialog.setTitle((CharSequence)title);
            alertdialog.setMessage((CharSequence)message);
            alertdialog.setPositiveButton((CharSequence)positivebutton, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    Location.this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
                }
            });
            alertdialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            alertdialog.show();
            return;
        }
        try {
            final Geocoder geocoder = new Geocoder(this.mycontext, Locale.getDefault());
            this.locationManager = (LocationManager)this.mycontext.getSystemService("location");
            isGPSEnabled = this.locationManager.isProviderEnabled("gps");
            this.showSnack("Please wait...", true);
            this.autolocaterclick = true;
            this.mGoogleApiClient = new GoogleApiClient.Builder((Context)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
            this.mGoogleApiClient.connect();
            this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Activity)this);
            if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return;
            }
            this.mLocationRequest = new LocationRequest();
            this.mLocationRequest.setPriority(100);
            this.mLocationRequest.setInterval(this.UPDATE_INTERVAL);
            this.mLocationRequest.setFastestInterval(this.FASTEST_INTERVAL);
            this.mLocationRequest.setMaxWaitTime(2000L);
            this.mLocationRequest.setNumUpdates(1);
            this.mLocationRequest.setExpirationDuration(5000L);
            LocationCallback locationCallback2 = new LocationCallback(){

                public void onLocationResult(LocationResult locationResult) {
                    Log.e((String)"Location", (String)"in result");
                    if (locationResult.getLocations().size() == 0) {
                        Log.e((String)"Location", (String)"No lcoations found");
                        return;
                    }
                    android.location.Location location = locationResult.getLastLocation();
                    Log.e((String)"Location", (String)(location.getLatitude() + "" + location.getLongitude()));
                    Location.this.currentlocationlaltitue = location.getLatitude();
                    Location.this.currentlocationlongitude = location.getLongitude();
                    try {
                        Location.this.addresses = geocoder.getFromLocation(Location.this.currentlocationlaltitue.doubleValue(), Location.this.currentlocationlongitude.doubleValue(), 1);
                        Address address2 = (Address)Location.this.addresses.get(0);
                        if (address2 != null) {
                            Location.this.currentlocation = address2.getAddressLine(0);
                        } else {
                            Location.this.currentlocation = Location.this.currentlocationlaltitue + "," + Location.this.currentlocationlongitude;
                        }
                    }
                    catch (Exception e) {
                        Location.this.currentlocation = Location.this.currentlocationlaltitue + "," + Location.this.currentlocationlongitude;
                    }
                    if (Location.this.autolocaterclick.booleanValue()) {
                        Location.this.sdf = new SimpleDateFormat("HH:mm:ss");
                        Location.this.sdf2 = new SimpleDateFormat("yyyy-MM-dd");
                        if (Location.this.currentlocation.equalsIgnoreCase("Not found") || Location.this.currentlocation.equalsIgnoreCase("ot foun")) {
                            Location.this.locationdetail.setText((CharSequence)(Location.this.currentlocationlaltitue + "," + Location.this.currentlocationlongitude));
                        } else {
                            Location.this.locationdetail.setText((CharSequence)Location.this.currentlocation);
                        }
                        Location.this.table_latitude = String.valueOf(Location.this.currentlocationlaltitue);
                        Location.this.table_longitude = String.valueOf(Location.this.currentlocationlongitude);
                        Location.this.table_location = Location.this.currentlocation;
                        Location.this.table_date = Location.this.sdf2.format(new Date());
                        Location.this.table_time = Location.this.sdf.format(new Date());
                        Location.this.autolocaterclick = false;
                    }
                }
            };
            Log.e((String)"called", (String)"yes");
            this.mFusedLocationClient.requestLocationUpdates(this.mLocationRequest, locationCallback2, Looper.myLooper());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void getLocation(String provider) {
        final Geocoder geocoder = new Geocoder(this.mycontext, Locale.getDefault());
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        GoogleApiClient mGoogleApiClient = new GoogleApiClient.Builder((Context)this).addOnConnectionFailedListener((GoogleApiClient.OnConnectionFailedListener)this).addApi(LocationServices.API).build();
        mGoogleApiClient.connect();
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        LocationServices.getFusedLocationProviderClient((Activity)this).getLastLocation().addOnSuccessListener((Activity)this, (OnSuccessListener)new OnSuccessListener<android.location.Location>(){

            public void onSuccess(android.location.Location location) {
                block5: {
                    if (location != null) {
                        Log.e((String)"Location", (String)(location.getLatitude() + "" + location.getLongitude()));
                        Location.this.currentlocationlaltitue = location.getLatitude();
                        Location.this.currentlocationlongitude = location.getLongitude();
                        try {
                            Location.this.addresses = geocoder.getFromLocation(Location.this.currentlocationlaltitue.doubleValue(), Location.this.currentlocationlongitude.doubleValue(), 1);
                            Address address2 = (Address)Location.this.addresses.get(0);
                            if (address2 != null) {
                                Location.this.currentlocation = address2.getAddressLine(0);
                                break block5;
                            }
                            Location.this.currentlocation = Location.this.currentlocationlaltitue + "," + Location.this.currentlocationlongitude;
                        }
                        catch (Exception e) {
                            Location.this.currentlocation = Location.this.currentlocationlaltitue + "," + Location.this.currentlocationlongitude;
                        }
                    } else {
                        Log.e((String)"Location", (String)"Not Found");
                    }
                }
            }
        });
    }

    public void fetchCityName(final Context contex, final android.location.Location location) {
        if (this.running) {
            return;
        }
        new AsyncTask<Void, Void, String>(){

            protected void onPreExecute() {
                Location.this.running = true;
            }

            protected String doInBackground(Void ... params) {
                String cityName = null;
                if (Geocoder.isPresent()) {
                    try {
                        Geocoder geocoder = new Geocoder(contex, Locale.getDefault());
                        List addresses = geocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
                        if (addresses.size() > 0) {
                            cityName = ((Address)addresses.get(0)).getLocality();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (cityName != null) {
                    return cityName;
                }
                return this.fetchCityNameUsingGoogleMap();
            }

            private String fetchCityNameUsingGoogleMap() {
                String googleMapUrl = "http://maps.googleapis.com/maps/api/geocode/json?latlng=" + location.getLatitude() + "," + location.getLongitude() + "&sensor=false&language=fr";
                try {
                    JSONObject googleMapResponse = new JSONObject((String)ANDROID_HTTP_CLIENT.execute((HttpUriRequest)new HttpGet(googleMapUrl), (ResponseHandler)new BasicResponseHandler()));
                    JSONArray results = (JSONArray)googleMapResponse.get("results");
                    String cityName = results.getJSONObject(0).getString("formatted_address");
                    return cityName;
                }
                catch (Exception ignored) {
                    ignored.printStackTrace();
                    return null;
                }
            }

            protected void onPostExecute(String cityName) {
                Location.this.running = false;
                if (cityName != null) {
                    Location.this.currentlocation = cityName;
                    Location.this.currentlocation = Location.this.currentlocation.substring(1, Location.this.currentlocation.length() - 1);
                }
            }
        }.execute((Object[])new Void[0]);
    }

    protected void onDestroy() {
        this.mDbHelper.close();
        super.onDestroy();
    }

    private void syncData() {
        final HcmDatabase hcmDatabase = HcmDatabase.getInstance((Context)this);
        this.showSnack("Please wait.", false);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("JSON", hcmDatabase.getLocationNotSynced().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/insert_location.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    hcmDatabase.updateLocationSynced(jsonObject.getJSONArray("list"));
                    Location.this.showSnack("Data is synced.", false);
                    Location.this.setAdapter();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void toast() {
    }

    public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
    }

    private void setAdapter() {
        Cursor locationcursor = this.mDbHelper.get_location(this.registeredcompany, this.registeredemailid);
        this.setAdapter(locationcursor);
    }

    private void setAdapter(Cursor locationlist_cursor) {
        this.date.clear();
        this.locationval.clear();
        this.customcheckin.clear();
        this.time.clear();
        this.syncval.clear();
        if (locationlist_cursor.moveToFirst()) {
            do {
                this.date.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex("DATE")));
                this.locationval.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex("LOCATION")));
                this.customcheckin.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex("CHECKINNAME")));
                this.time.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex("TIME")));
                this.syncval.add(locationlist_cursor.getString(locationlist_cursor.getColumnIndex("SYNC")));
            } while (locationlist_cursor.moveToNext());
        }
        Parcelable parcelable = this.locationlistview.onSaveInstanceState();
        locationadapter adapter2 = new locationadapter(this.mycontext, this.date, this.locationval, this.customcheckin, this.time, this.syncval);
        locationlist_cursor.close();
        this.locationlistview.setAdapter((ListAdapter)adapter2);
        if (parcelable != null) {
            this.locationlistview.onRestoreInstanceState(parcelable);
        }
    }

    private void showSnack(String text, boolean infinity) {
        if (this.coordinatorLayout == null) {
            this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296593);
        }
        if (this.snackBar != null && this.snackBar.isShown()) {
            this.snackBar.dismiss();
        }
        this.snackBar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)text, (int)0);
        if (infinity) {
            this.snackBar.setDuration(-2);
        }
        this.snackBar.setAction((CharSequence)"CLOSE", new View.OnClickListener(){

            public void onClick(View v) {
                Location.this.snackBar.dismiss();
            }
        });
        this.snackBar.setActionTextColor(this.getResources().getColor(17170451));
        this.snackBar.show();
    }
}

