/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.hcm.activities.AdvanceInfoActivity;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.AdvanceAdapter;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AdvancesActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    TextView errorText;
    AdvanceAdapter advanceAdapter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492909);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Advances");
        this.errorText = (TextView)this.findViewById(2131296737);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.getAdvances();
    }

    private void getAdvances() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_advances.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    AdvancesActivity.this.getAdvances(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getAdvances(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray = jsonObject.getJSONArray("list");
        this.advanceAdapter = new AdvanceAdapter((Context)this, jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.advanceAdapter);
        if (jsonArray.length() == 0) {
            this.errorText.setText((CharSequence)"No Advances Taken");
            this.errorText.setVisibility(0);
        } else if (this.errorText.getVisibility() == 0) {
            this.errorText.setVisibility(8);
        }
    }

    @Override
    public void itemClicked(int position) {
        Intent intent = new Intent(this.getApplicationContext(), AdvanceInfoActivity.class);
        try {
            intent.putExtra("json", this.advanceAdapter.getJsonArray().getJSONObject(position).toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.startActivity(intent);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

