/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.hcm.activities.TravelApplyActivtiy;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import org.json.JSONException;
import org.json.JSONObject;

public class ExpenseInfoActivity
extends AppCompatActivity {
    LinearLayout mainLayout;
    String expenseId;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493056);
        this.mainLayout = (LinearLayout)this.findViewById(2131296993);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Expense Details");
        this.expenseId = this.getIntent().getStringExtra("id");
        try {
            this.addDetais();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void addDetais() throws JSONException {
        JSONObject jsonObject = HcmDatabase.getInstance((Context)this).getExpenseInfo(this.expenseId);
        this.mainLayout.removeAllViews();
        this.addView("Travel Id", jsonObject.getString("tr_id"));
        this.addView("Expense Id", jsonObject.getString("exp_id"));
        this.addView("Start", jsonObject.getString("exp_from_location"));
        this.addView("End", jsonObject.getString("exp_to_location"));
        this.addView("Amount", jsonObject.getString("exp_amount"));
        this.addView("Expense Type", jsonObject.getString("exp_type"));
        this.addView("Created By", jsonObject.getString("exp_created_by"));
        this.addView("Created Datetime", jsonObject.getString("exp_datetime"));
        this.addViewWithImage("Scanned Copy", jsonObject.getString("img_path"));
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493227, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.mainLayout.addView(view);
    }

    private void addViewWithImage(String key, final String pair) {
        final View view = this.getLayoutInflater().inflate(2131493240, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        final TextView pairText = (TextView)view.findViewById(2131297136);
        pairText.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                ImageView imageView = (ImageView)view.findViewById(2131296843);
                Glide.with((Context)ExpenseInfoActivity.this.getApplicationContext()).load("http://fieldcloud.in/Eversendai/" + pair).apply((BaseRequestOptions)RequestOptions.placeholderOf((int)2131230993)).into(imageView);
                pairText.setVisibility(8);
            }
        });
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)"Load Image");
        this.mainLayout.addView(view);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296352: {
                this.startActivity(new Intent(this.getApplicationContext(), TravelApplyActivtiy.class));
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

