/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.content.FileProvider;
import com.b2lmobitech.fieldcloudplus.hcm.activities.TravelsByStatusActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.Validations;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.google.android.material.textfield.TextInputLayout;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class NewExpenseActivity
extends AppCompatActivity {
    TextInputLayout travelId;
    TextInputLayout fromLocation;
    TextInputLayout toLocation;
    TextInputLayout expenseAmount;
    TextInputLayout expenseType;
    ImageView openCamera;
    ImageView snappedImage;
    TextView removeImage;
    private final int TRAVEL_REQUEST_CODE = 23;
    String imageString = "";
    Uri imageUri;
    File mediaFile = null;
    Bitmap cambmp;
    protected static final int CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE = 0;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492970);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"New Expense");
        this.getWidgets();
    }

    private void getWidgets() {
        this.travelId = (TextInputLayout)this.findViewById(2131297602);
        this.fromLocation = (TextInputLayout)this.findViewById(2131296786);
        this.toLocation = (TextInputLayout)this.findViewById(2131297573);
        this.expenseAmount = (TextInputLayout)this.findViewById(2131296744);
        this.expenseType = (TextInputLayout)this.findViewById(2131296745);
        this.openCamera = (ImageView)this.findViewById(2131297120);
        this.snappedImage = (ImageView)this.findViewById(2131297373);
        this.removeImage = (TextView)this.findViewById(2131297255);
        this.removeImage.setVisibility(8);
        this.snappedImage.setVisibility(8);
        this.openCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewExpenseActivity.this.openCamera();
            }
        });
        this.removeImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                NewExpenseActivity.this.imageString = "";
                NewExpenseActivity.this.removeImage.setVisibility(8);
                NewExpenseActivity.this.snappedImage.setVisibility(8);
                NewExpenseActivity.this.openCamera.setVisibility(0);
            }
        });
        this.travelId.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(NewExpenseActivity.this.getApplicationContext(), TravelsByStatusActivity.class);
                intent.putExtra("status", "approved");
                intent.putExtra("title", "Select Travel");
                intent.putExtra("result", true);
                NewExpenseActivity.this.startActivityForResult(intent, 23);
            }
        });
    }

    protected void openCamera() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.imageUri = this.getOutputMediaFileUri();
        intent.putExtra("output", (Parcelable)this.imageUri);
        this.startActivityForResult(intent, 0);
    }

    public Uri getOutputMediaFileUri() {
        this.mediaFile = Utility.getCapturedImageFile();
        Uri uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)this, (String)"com.b2lmobitech.fieldcloudplus.provider", (File)this.mediaFile) : Uri.fromFile((File)this.mediaFile);
        return uri;
    }

    /*
     * Unable to fully structure code
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        switch (requestCode) {
            case 23: {
                if (resultCode != -1) break;
                this.travelId.getEditText().setText((CharSequence)data.getStringExtra("id"));
                this.toLocation.getEditText().setText((CharSequence)data.getStringExtra("to"));
                this.expenseType.getEditText().setText((CharSequence)data.getStringExtra("type"));
                break;
            }
            case 0: {
                if (resultCode != -1) ** GOTO lbl28
                try {
                    if (this.imageUri != null) {
                        try {
                            this.cambmp = BitmapFactory.decodeStream((InputStream)this.getContentResolver().openInputStream(this.imageUri), null, null);
                            this.cambmp = Utility.processImage(this.cambmp);
                            this.snappedImage.setImageBitmap(this.cambmp);
                            this.snappedImage.setVisibility(0);
                            this.removeImage.setVisibility(0);
                            this.openCamera.setVisibility(8);
                        }
                        catch (FileNotFoundException var4_4) {
                            // empty catch block
                        }
                        this.imageString = Utility.bitmap2string(this.cambmp);
                    }
                    ** GOTO lbl32
                }
                catch (Exception e) {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"please try again", (int)0).show();
                }
                ** GOTO lbl32
lbl28:
                // 1 sources

                if (resultCode == 0) {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"You cancelled image capture", (int)0).show();
                } else {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Sorry! Failed to capture image", (int)0).show();
                }
lbl32:
                // 5 sources

                if (this.mediaFile == null) break;
                this.mediaFile.delete();
            }
        }
    }

    private boolean isValid() {
        boolean valid = true;
        Validations validations = Validations.getInstance((Context)this);
        if (this.travelId.getEditText().getText().toString().isEmpty()) {
            validations.setError(this.travelId, "Select Travel Id");
            valid = false;
        }
        if (this.fromLocation.getEditText().getText().toString().isEmpty()) {
            validations.setError(this.fromLocation, "Provide Lcoation");
            valid = false;
        }
        if (this.toLocation.getEditText().getText().toString().isEmpty()) {
            validations.setError(this.toLocation, "Provide Lcoation");
            valid = false;
        }
        if (this.expenseAmount.getEditText().getText().toString().isEmpty()) {
            Validations.getInstance((Context)this).setError(this.expenseAmount, "Enter Amount");
            valid = false;
        }
        if (this.expenseType.getEditText().getText().toString().isEmpty()) {
            Validations.getInstance((Context)this).setError(this.expenseType, "Enter Expense Type");
            valid = false;
        }
        if (this.imageString.isEmpty()) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please Capture Source Image", (int)0).show();
            valid = false;
        }
        return valid;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                this.closeKeyboard();
                if (!this.isValid()) break;
                try {
                    this.addExpense();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void addExpense() throws JSONException {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cname", (Object)preference.getCompanyName());
        jsonObject.put("mail", (Object)preference.getEmailId());
        jsonObject.put("type", (Object)preference.getCompnayType());
        jsonObject.put("role", (Object)preference.getDesignation());
        jsonObject.put("id", (Object)this.travelId.getEditText().getText().toString().trim());
        jsonObject.put("from", (Object)this.fromLocation.getEditText().getText().toString().trim());
        jsonObject.put("to", (Object)this.toLocation.getEditText().getText().toString().trim());
        jsonObject.put("amount", (Object)this.expenseAmount.getEditText().getText().toString().trim());
        jsonObject.put("type", (Object)this.expenseType.getEditText().getText().toString().trim());
        jsonObject.put("image", (Object)this.imageString);
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/add_expense.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)NewExpenseActivity.this.getApplicationContext(), (CharSequence)"Travel Added Successfully", (int)0).show();
                        NewExpenseActivity.this.finish();
                    } else {
                        Toast.makeText((Context)NewExpenseActivity.this.getApplicationContext(), (CharSequence)"Unable to Add", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void closeKeyboard() {
        InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
        inputManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
    }
}

