/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.DatePicker;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.Preference;
import com.b2lmobitech.fieldcloudplus.others.utils.Validations;
import com.google.android.material.textfield.TextInputLayout;
import fr.ganfra.materialspinner.MaterialSpinner;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class TravelApplyActivtiy
extends AppCompatActivity {
    TextInputLayout purposeOfVisit;
    TextInputLayout customerName;
    TextInputLayout travelDuration;
    TextInputLayout aDate;
    TextInputLayout dDate;
    TextInputLayout travelPlace;
    MaterialSpinner travelType;
    RadioGroup customerBillable;
    RadioButton billable;
    RadioButton nonBillable;
    Calendar calendarStart = Calendar.getInstance();
    Calendar calendarEnd = Calendar.getInstance();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493054);
        this.getSupportActionBar().setTitle((CharSequence)"Request Travel");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getWidgets();
        this.setLsiteners();
    }

    private void getWidgets() {
        this.purposeOfVisit = (TextInputLayout)this.findViewById(2131297207);
        this.customerName = (TextInputLayout)this.findViewById(2131296610);
        this.travelDuration = (TextInputLayout)this.findViewById(2131297600);
        this.aDate = (TextInputLayout)this.findViewById(2131296279);
        this.dDate = (TextInputLayout)this.findViewById(2131296625);
        this.travelPlace = (TextInputLayout)this.findViewById(2131297603);
        this.travelType = (MaterialSpinner)this.findViewById(2131297604);
        this.customerBillable = (RadioGroup)this.findViewById(2131296609);
        this.billable = (RadioButton)this.findViewById(2131296440);
        this.nonBillable = (RadioButton)this.findViewById(2131297102);
        this.nonBillable.setChecked(true);
    }

    private void setLsiteners() {
        this.aDate.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TravelApplyActivtiy.this.selectEndDate();
            }
        });
        this.dDate.getEditText().setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                TravelApplyActivtiy.this.selectStartDate();
            }
        });
    }

    private void selectStartDate() {
        DatePickerDialog.OnDateSetListener fromDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                TravelApplyActivtiy.this.calendarStart.set(1, year);
                TravelApplyActivtiy.this.calendarStart.set(2, monthOfYear);
                TravelApplyActivtiy.this.calendarStart.set(5, dayOfMonth);
                String myFormat = "yyyy-MM-dd";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                TravelApplyActivtiy.this.dDate.getEditText().setText((CharSequence)sdf.format(TravelApplyActivtiy.this.calendarStart.getTime()));
                TravelApplyActivtiy.this.aDate.getEditText().getText().clear();
            }
        };
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, fromDate, this.calendarStart.get(1), this.calendarStart.get(2), this.calendarStart.get(5));
        datePicker.setTitle((CharSequence)"Start Date");
        datePicker.show();
    }

    private void selectEndDate() {
        DatePickerDialog.OnDateSetListener toDate = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                TravelApplyActivtiy.this.calendarEnd.set(1, year);
                TravelApplyActivtiy.this.calendarEnd.set(2, monthOfYear);
                TravelApplyActivtiy.this.calendarEnd.set(5, dayOfMonth);
                String myFormat = "yyyy-MM-dd";
                SimpleDateFormat sdf = new SimpleDateFormat(myFormat, Locale.US);
                TravelApplyActivtiy.this.aDate.getEditText().setText((CharSequence)sdf.format(TravelApplyActivtiy.this.calendarEnd.getTime()));
            }
        };
        if (this.dDate.getEditText().getText().toString().isEmpty()) {
            Validations.getInstance((Context)this).setError(this.dDate, "Select Departure Date");
            return;
        }
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, toDate, this.calendarEnd.get(1), this.calendarEnd.get(2), this.calendarEnd.get(5));
        datePicker.getDatePicker().setMinDate(this.calendarStart.getTimeInMillis());
        datePicker.setTitle((CharSequence)"End Date");
        datePicker.show();
    }

    private boolean isValid() {
        boolean valid = true;
        Validations validations = Validations.getInstance((Context)this);
        if (this.purposeOfVisit.getEditText().getText().toString().isEmpty()) {
            validations.setError(this.purposeOfVisit, "Provide Purpose of Visit");
            valid = false;
        }
        if (this.customerName.getEditText().getText().toString().isEmpty()) {
            validations.setError(this.customerName, "Provide Customer Name");
            valid = false;
        }
        if (this.travelDuration.getEditText().getText().toString().isEmpty()) {
            validations.setError(this.travelDuration, "Provide Travel Duration");
            valid = false;
        }
        if (this.dDate.getEditText().getText().toString().isEmpty()) {
            Validations.getInstance((Context)this).setError(this.dDate, "Select Departure Date");
            valid = false;
        }
        if (this.aDate.getEditText().getText().toString().isEmpty()) {
            Validations.getInstance((Context)this).setError(this.aDate, "Select Arrival Date");
            valid = false;
        }
        if (this.travelPlace.getEditText().getText().toString().isEmpty()) {
            validations.setError(this.travelPlace, "Provide Travel Place");
            valid = false;
        }
        if (this.travelType.getSelectedItemPosition() == 0) {
            Validations.getInstance((Context)this).setError(this.travelType, "Select Travel Type");
            valid = false;
        }
        return valid;
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                this.closeKeyboard();
                if (!this.isValid()) break;
                try {
                    this.requestTravel();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void closeKeyboard() {
        InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
        inputManager.hideSoftInputFromWindow(this.getCurrentFocus().getWindowToken(), 2);
    }

    private void requestTravel() throws JSONException {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("cname", (Object)preference.getCompanyName());
        jsonObject.put("mail", (Object)preference.getEmailId());
        jsonObject.put("type", (Object)preference.getCompnayType());
        jsonObject.put("role", (Object)preference.getDesignation());
        String[] arrayList = this.getResources().getStringArray(2130903056);
        jsonObject.put("place", (Object)this.travelPlace.getEditText().getText().toString().trim());
        jsonObject.put("travel_type", (Object)arrayList[this.travelType.getSelectedItemPosition() - 1]);
        if (this.nonBillable.isChecked()) {
            jsonObject.put("billable", (Object)"no");
        } else {
            jsonObject.put("billable", (Object)"yes");
        }
        jsonObject.put("customer", (Object)this.customerName.getEditText().getText().toString().trim());
        jsonObject.put("purpose", (Object)this.purposeOfVisit.getEditText().getText().toString().trim());
        jsonObject.put("start", (Object)this.dDate.getEditText().getText().toString().trim());
        jsonObject.put("end", (Object)this.aDate.getEditText().getText().toString().trim());
        jsonObject.put("duration", (Object)this.travelDuration.getEditText().getText().toString().trim());
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/add_travel.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)TravelApplyActivtiy.this.getApplicationContext(), (CharSequence)"Travel Requested Successfully", (int)0).show();
                        TravelApplyActivtiy.this.finish();
                    } else {
                        Toast.makeText((Context)TravelApplyActivtiy.this.getApplicationContext(), (CharSequence)"Unable to Request Travel", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

