/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm.activities;

import android.app.Activity;
import android.app.SearchManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SearchView;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.hcm.activities.ExpenseInfoActivity;
import com.b2lmobitech.fieldcloudplus.hcm.adapter.ExpenseAdapter;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TravelExpenseActivity
extends AppCompatActivity
implements OnItemClickListener {
    JSONArray jsonArray;
    JSONArray adapterArray;
    RecyclerView recyclerView;
    ExpenseAdapter expenseAdapter;
    TextView errorText;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493055);
        this.errorText = (TextView)this.findViewById(2131296737);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Expenses");
        this.getExpenses();
    }

    protected void onResume() {
        super.onResume();
        this.getExpensesOffline();
    }

    private void getExpenses() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/get_expenses.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    TravelExpenseActivity.this.getExpenses(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getExpenses(JSONObject jsonObject) throws JSONException {
        HcmDatabase hcmDatabase = HcmDatabase.getInstance((Context)this);
        hcmDatabase.insertExpenses(jsonObject.getJSONArray("list"));
        this.getExpensesOffline();
    }

    private void getExpensesOffline() {
        this.jsonArray = HcmDatabase.getInstance((Context)this).getExpenses();
        this.setAdapter();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558409, menu2);
        MenuItem search = menu2.findItem(2131296337);
        SearchManager searchManager = (SearchManager)this.getSystemService("search");
        SearchView searchView = (SearchView)search.getActionView();
        searchView.performClick();
        searchView.setIconified(true);
        searchManager.setOnDismissListener(new SearchManager.OnDismissListener(){

            public void onDismiss() {
                TravelExpenseActivity.this.setAdapter();
            }
        });
        searchManager.setOnCancelListener(new SearchManager.OnCancelListener(){

            public void onCancel() {
                TravelExpenseActivity.this.setAdapter();
            }
        });
        searchView.setOnQueryTextListener(new SearchView.OnQueryTextListener(){

            public boolean onQueryTextSubmit(String s) {
                return false;
            }

            public boolean onQueryTextChange(String s) {
                if (s.isEmpty()) {
                    TravelExpenseActivity.this.setAdapter();
                } else {
                    try {
                        TravelExpenseActivity.this.setFilteredAdapter(s);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                return false;
            }
        });
        return true;
    }

    private void setFilteredAdapter(String string2) throws JSONException {
        this.adapterArray = new JSONArray();
        for (int i = 0; i < this.jsonArray.length(); ++i) {
            JSONObject jsonObject = this.jsonArray.getJSONObject(i);
            if (!jsonObject.toString().contains(string2)) continue;
            this.adapterArray.put((Object)jsonObject);
        }
        this.expenseAdapter = new ExpenseAdapter((Context)this, this.adapterArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.expenseAdapter);
        if (this.adapterArray.length() == 0) {
            this.errorText.setText((CharSequence)"No Matched Found");
            this.errorText.setVisibility(0);
        } else if (this.errorText.getVisibility() == 0) {
            this.errorText.setVisibility(8);
        }
    }

    private void setAdapter() {
        this.expenseAdapter = new ExpenseAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.expenseAdapter);
        if (this.jsonArray.length() == 0) {
            this.errorText.setText((CharSequence)"No Expense Found");
            this.errorText.setVisibility(0);
        } else if (this.errorText.getVisibility() == 0) {
            this.errorText.setVisibility(8);
        }
    }

    @Override
    public void itemClicked(int position) {
        try {
            Intent intent = new Intent(this.getApplicationContext(), ExpenseInfoActivity.class);
            intent.putExtra("id", this.expenseAdapter.getJsonArray().getJSONObject(position).getString("exp_id"));
            this.startActivity(intent);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

