/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel;

import android.app.Application;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Base64;
import androidx.lifecycle.AndroidViewModel;
import androidx.lifecycle.LiveData;
import androidx.paging.LivePagedListBuilder;
import androidx.paging.PagedList;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.LocalDatabase;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.FacilityDOA;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.doa.TimeSheetDOA;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.FacilityEntity;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.entities.TimesheetEntity;
import com.b2lmobitech.fieldcloudplus.hcm.new_sql.viewModel.DBViewModel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u0013J&\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00170\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u00102\b\b\u0002\u0010\u001a\u001a\u00020\u0010J\u0012\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00140\u0013J\u000e\u0010\u001c\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001a\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u00182\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 J\u001e\u0010!\u001a\u00020\u000e2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00180\u00142\b\b\u0002\u0010#\u001a\u00020$J\u001a\u0010%\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010&J*\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00180\u00140\u00132\u0006\u0010(\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u0010R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/b2lmobitech/fieldcloudplus/hcm/new_sql/viewModel/TimeSheetVM;", "Landroidx/lifecycle/AndroidViewModel;", "application", "Landroid/app/Application;", "(Landroid/app/Application;)V", "executorService", "Ljava/util/concurrent/ExecutorService;", "facilityDOA", "Lcom/b2lmobitech/fieldcloudplus/hcm/new_sql/doa/FacilityDOA;", "timeSheetDOA", "Lcom/b2lmobitech/fieldcloudplus/hcm/new_sql/doa/TimeSheetDOA;", "addAllFacilities", "", "jsonArray", "Lorg/json/JSONArray;", "fileToImage", "", "path", "getAllFacilities", "Landroidx/lifecycle/LiveData;", "", "Lcom/b2lmobitech/fieldcloudplus/hcm/new_sql/entities/FacilityEntity;", "getAllTS", "Landroidx/paging/PagedList;", "Lcom/b2lmobitech/fieldcloudplus/hcm/new_sql/entities/TimesheetEntity;", "startDate", "endDate", "getNotSynced", "inserTimesheetHistory", "saveTimesheet", "timesheetEntity", "completedCallBack", "Lcom/b2lmobitech/fieldcloudplus/hcm/new_sql/viewModel/TimeSheetVM$CompletedCallBack;", "toJSON", "list", "isCheckIn", "", "updateAttendanceSynced", "Lcom/b2lmobitech/fieldcloudplus/hcm/new_sql/viewModel/DBViewModel$CompletedCallBack;", "validateTimesheet", "startTime", "endTime", "date", "CompletedCallBack", "app_debug"})
@SourceDebugExtension(value={"SMAP\nTimeSheetVM.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TimeSheetVM.kt\ncom/b2lmobitech/fieldcloudplus/hcm/new_sql/viewModel/TimeSheetVM\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,184:1\n1855#2,2:185\n*S KotlinDebug\n*F\n+ 1 TimeSheetVM.kt\ncom/b2lmobitech/fieldcloudplus/hcm/new_sql/viewModel/TimeSheetVM\n*L\n135#1:185,2\n*E\n"})
public final class TimeSheetVM
extends AndroidViewModel {
    private FacilityDOA facilityDOA;
    private TimeSheetDOA timeSheetDOA;
    @NotNull
    private ExecutorService executorService;

    public TimeSheetVM(@NotNull Application application) {
        Intrinsics.checkNotNullParameter((Object)application, (String)"application");
        super(application);
        LocalDatabase localDatabase = LocalDatabase.Companion.getAppDataBase((Context)application);
        if (localDatabase != null) {
            LocalDatabase it = localDatabase;
            boolean bl = false;
            this.facilityDOA = it.facilityDOA();
            this.timeSheetDOA = it.timeSheetDOA();
        }
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newSingleThreadExecutor(...)");
        this.executorService = executorService;
    }

    public final void inserTimesheetHistory(@NotNull JSONArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        this.executorService.execute(() -> TimeSheetVM.inserTimesheetHistory$lambda$1(this));
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                String string2 = jsonObject.getString("companyname");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
                String string3 = jsonObject.getString("employeemailid");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(...)");
                String string4 = jsonObject.getString("attendancegroup");
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(...)");
                String string5 = jsonObject.getString("attendancesubgroup");
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(...)");
                String string6 = jsonObject.getString("attendenceteam");
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(...)");
                String string7 = jsonObject.getString("activity");
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(...)");
                String string8 = jsonObject.getString("latitude");
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(...)");
                String string9 = jsonObject.getString("longitude");
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"getString(...)");
                String string10 = jsonObject.getString("timesheetdate");
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getString(...)");
                String string11 = jsonObject.getString("starttime");
                Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getString(...)");
                String string12 = jsonObject.getString("endtime");
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getString(...)");
                String string13 = jsonObject.getString("dateandtime");
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getString(...)");
                String string14 = jsonObject.getString("facility_id");
                Intrinsics.checkNotNullExpressionValue((Object)string14, (String)"getString(...)");
                TimesheetEntity timesheetEntity = new TimesheetEntity(0, string2, string3, string4, string5, string6, string7, string8, string9, null, string10, string11, string12, string13, "Yes", string14, 513, null);
                this.executorService.execute(() -> TimeSheetVM.inserTimesheetHistory$lambda$2(this, timesheetEntity));
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public final void addAllFacilities(@NotNull JSONArray jsonArray) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        ArrayList<FacilityEntity> list = new ArrayList<FacilityEntity>();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            String string2 = jsonObject.getString("companyname");
            String string3 = jsonObject.getString("atmid");
            String string4 = jsonObject.getString("state");
            String string5 = jsonObject.getString("location");
            String string6 = jsonObject.getString("atmaddress");
            String string7 = jsonObject.getString("sitename");
            String string8 = jsonObject.getString("country");
            String string9 = jsonObject.getString("latitude");
            String string10 = jsonObject.getString("longitude");
            String string11 = jsonObject.getString("geofencing");
            String string12 = jsonObject.getString("geo_distance");
            Intrinsics.checkNotNull((Object)string3);
            Intrinsics.checkNotNull((Object)string2);
            Intrinsics.checkNotNull((Object)string4);
            Intrinsics.checkNotNull((Object)string8);
            Intrinsics.checkNotNull((Object)string5);
            Intrinsics.checkNotNull((Object)string6);
            Intrinsics.checkNotNull((Object)string7);
            Intrinsics.checkNotNull((Object)string9);
            Intrinsics.checkNotNull((Object)string10);
            Intrinsics.checkNotNull((Object)string11);
            Intrinsics.checkNotNull((Object)string12);
            FacilityEntity facilityEntity = new FacilityEntity(string3, string2, string4, string8, string5, string6, string7, string9, string10, string11, string12);
            list.add(facilityEntity);
        }
        this.executorService.execute(() -> TimeSheetVM.addAllFacilities$lambda$3(this, list));
    }

    @NotNull
    public final LiveData<List<FacilityEntity>> getAllFacilities() {
        FacilityDOA facilityDOA = this.facilityDOA;
        if (facilityDOA == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"facilityDOA");
            facilityDOA = null;
        }
        return facilityDOA.fetchAll();
    }

    @NotNull
    public final LiveData<List<TimesheetEntity>> getNotSynced() {
        TimeSheetDOA timeSheetDOA = this.timeSheetDOA;
        if (timeSheetDOA == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timeSheetDOA");
            timeSheetDOA = null;
        }
        return timeSheetDOA.fetchNotSynced();
    }

    @NotNull
    public final LiveData<PagedList<TimesheetEntity>> getAllTS(@NotNull String startDate, @NotNull String endDate) {
        Intrinsics.checkNotNullParameter((Object)startDate, (String)"startDate");
        Intrinsics.checkNotNullParameter((Object)endDate, (String)"endDate");
        LiveData list = null;
        if (((CharSequence)startDate).length() == 0) {
            TimeSheetDOA timeSheetDOA = this.timeSheetDOA;
            if (timeSheetDOA == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timeSheetDOA");
                timeSheetDOA = null;
            }
            LiveData liveData = new LivePagedListBuilder(timeSheetDOA.fetchAll(), 500).build();
            Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"build(...)");
            list = liveData;
        } else {
            TimeSheetDOA timeSheetDOA = this.timeSheetDOA;
            if (timeSheetDOA == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timeSheetDOA");
                timeSheetDOA = null;
            }
            LiveData liveData = new LivePagedListBuilder(timeSheetDOA.fetchAll(startDate, endDate), 500).build();
            Intrinsics.checkNotNullExpressionValue((Object)liveData, (String)"build(...)");
            list = liveData;
        }
        return list;
    }

    public static /* synthetic */ LiveData getAllTS$default(TimeSheetVM timeSheetVM, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = "";
        }
        if ((n & 2) != 0) {
            string3 = "";
        }
        return timeSheetVM.getAllTS(string2, string3);
    }

    public final void saveTimesheet(@NotNull TimesheetEntity timesheetEntity, @Nullable CompletedCallBack completedCallBack) {
        Intrinsics.checkNotNullParameter((Object)timesheetEntity, (String)"timesheetEntity");
        this.executorService.execute(() -> TimeSheetVM.saveTimesheet$lambda$4(this, timesheetEntity, completedCallBack));
    }

    public static /* synthetic */ void saveTimesheet$default(TimeSheetVM timeSheetVM, TimesheetEntity timesheetEntity, CompletedCallBack completedCallBack, int n, Object object) {
        if ((n & 2) != 0) {
            completedCallBack = null;
        }
        timeSheetVM.saveTimesheet(timesheetEntity, completedCallBack);
    }

    @NotNull
    public final LiveData<List<TimesheetEntity>> validateTimesheet(@NotNull String startTime, @NotNull String endTime, @NotNull String date) {
        Intrinsics.checkNotNullParameter((Object)startTime, (String)"startTime");
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        TimeSheetDOA timeSheetDOA = this.timeSheetDOA;
        if (timeSheetDOA == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timeSheetDOA");
            timeSheetDOA = null;
        }
        return timeSheetDOA.validateTimesheet(startTime, endTime, date);
    }

    @NotNull
    public final JSONArray toJSON(@NotNull List<TimesheetEntity> list, boolean isCheckIn) {
        Intrinsics.checkNotNullParameter(list, (String)"list");
        JSONArray jsonArray = new JSONArray();
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimesheetEntity it = (TimesheetEntity)element$iv;
            boolean bl = false;
            JSONObject json = new JSONObject();
            json.put("companyname", (Object)it.getCompanyname());
            json.put("activity", (Object)it.getActivity());
            json.put("attendancegroup", (Object)it.getAttendancegroup());
            json.put("attendenceteam", (Object)it.getAttendenceteam());
            json.put("dateandtime", (Object)it.getDateandtime());
            json.put("employeemailid", (Object)it.getEmployeemailid());
            json.put("endtime", (Object)it.getEndtime());
            json.put("facility_id", (Object)it.getFacility_id());
            json.put("latitude", (Object)it.getLatitude());
            json.put("_id", it.getId());
            json.put("longitude", (Object)it.getLongitude());
            json.put("starttime", (Object)it.getStarttime());
            json.put("timesheetdate", (Object)it.getTimesheetdate());
            jsonArray.put((Object)json);
        }
        return jsonArray;
    }

    public static /* synthetic */ JSONArray toJSON$default(TimeSheetVM timeSheetVM, List list, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = true;
        }
        return timeSheetVM.toJSON(list, bl);
    }

    public final void updateAttendanceSynced(@NotNull JSONArray jsonArray, @Nullable DBViewModel.CompletedCallBack completedCallBack) {
        Intrinsics.checkNotNullParameter((Object)jsonArray, (String)"jsonArray");
        ArrayList<Integer> ids = new ArrayList<Integer>();
        int n = jsonArray.length();
        for (int i = 0; i < n; ++i) {
            ids.add(jsonArray.getInt(i));
        }
        this.executorService.execute(() -> TimeSheetVM.updateAttendanceSynced$lambda$6(this, ids, completedCallBack));
    }

    public static /* synthetic */ void updateAttendanceSynced$default(TimeSheetVM timeSheetVM, JSONArray jSONArray, DBViewModel.CompletedCallBack completedCallBack, int n, Object object) {
        if ((n & 2) != 0) {
            completedCallBack = null;
        }
        timeSheetVM.updateAttendanceSynced(jSONArray, completedCallBack);
    }

    @Nullable
    public final String fileToImage(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        File file = new File(path);
        if (file.exists() && file.length() > 0L) {
            Bitmap bm = BitmapFactory.decodeFile((String)path);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)bOut);
            return Base64.encodeToString((byte[])bOut.toByteArray(), (int)0);
        }
        return null;
    }

    private static final void inserTimesheetHistory$lambda$1(TimeSheetVM this$0) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        TimeSheetDOA timeSheetDOA = this$0.timeSheetDOA;
        if (timeSheetDOA == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timeSheetDOA");
            timeSheetDOA = null;
        }
        timeSheetDOA.deleteAll();
    }

    private static final void inserTimesheetHistory$lambda$2(TimeSheetVM this$0, TimesheetEntity $timesheetEntity) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$timesheetEntity, (String)"$timesheetEntity");
        TimeSheetDOA timeSheetDOA = this$0.timeSheetDOA;
        if (timeSheetDOA == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"timeSheetDOA");
            timeSheetDOA = null;
        }
        timeSheetDOA.save($timesheetEntity);
    }

    private static final void addAllFacilities$lambda$3(TimeSheetVM this$0, ArrayList $list) {
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$list, (String)"$list");
        FacilityDOA facilityDOA = this$0.facilityDOA;
        if (facilityDOA == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"facilityDOA");
            facilityDOA = null;
        }
        facilityDOA.deleteAll();
        FacilityDOA facilityDOA2 = this$0.facilityDOA;
        if (facilityDOA2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"facilityDOA");
            facilityDOA2 = null;
        }
        facilityDOA2.saveAll($list);
        this$0.getAllFacilities();
    }

    private static final void saveTimesheet$lambda$4(TimeSheetVM this$0, TimesheetEntity $timesheetEntity, CompletedCallBack $completedCallBack) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$timesheetEntity, (String)"$timesheetEntity");
            TimeSheetDOA timeSheetDOA = this$0.timeSheetDOA;
            if (timeSheetDOA == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timeSheetDOA");
                timeSheetDOA = null;
            }
            timeSheetDOA.save($timesheetEntity);
            CompletedCallBack completedCallBack = $completedCallBack;
            if (completedCallBack == null) break block1;
            completedCallBack.onTaskCompleted();
        }
    }

    private static final void updateAttendanceSynced$lambda$6(TimeSheetVM this$0, ArrayList $ids, DBViewModel.CompletedCallBack $completedCallBack) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$ids, (String)"$ids");
            TimeSheetDOA timeSheetDOA = this$0.timeSheetDOA;
            if (timeSheetDOA == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"timeSheetDOA");
                timeSheetDOA = null;
            }
            timeSheetDOA.updateSynced($ids);
            DBViewModel.CompletedCallBack completedCallBack = $completedCallBack;
            if (completedCallBack == null) break block1;
            completedCallBack.onTaskCompleted();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/b2lmobitech/fieldcloudplus/hcm/new_sql/viewModel/TimeSheetVM$CompletedCallBack;", "", "onTaskCompleted", "", "app_debug"})
    public static interface CompletedCallBack {
        public void onTaskCompleted();
    }
}

