/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm.others;

import android.content.Context;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationManager;
import android.os.Looper;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.WorkerParameters;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.hcm.sql.HcmDatabase;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationResult;
import com.google.android.gms.location.LocationServices;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class LocationUpdate
extends ListenableWorker {
    FusedLocationProviderClient mFusedLocationClient;
    LocationRequest mLocationRequest;
    LocationManager locationManager;
    private String currentlocation = "0.0,0.0";
    private Double currentlocationlaltitue = 0.0;
    private Double currentlocationlongitude = 0.0;
    String registeredcompany;
    String registeredemailid;

    public LocationUpdate(@NonNull Context appContext, @NonNull WorkerParameters params) {
        super(appContext, params);
    }

    public ListenableFuture<ListenableWorker.Result> startWork() {
        Data input = this.getInputData();
        if (input != null) {
            this.registeredcompany = input.getString("registeredcompany");
            this.registeredemailid = input.getString("registeredemailid");
            this.findlocation();
        }
        return null;
    }

    public void onStopped() {
    }

    public void findlocation() {
        try {
            final Geocoder geocoder = new Geocoder(this.getApplicationContext(), Locale.getDefault());
            this.locationManager = (LocationManager)this.getApplicationContext().getSystemService("location");
            this.mFusedLocationClient = LocationServices.getFusedLocationProviderClient((Context)this.getApplicationContext());
            if (ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this.getApplicationContext(), (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
                return;
            }
            this.mLocationRequest = new LocationRequest();
            this.mLocationRequest.setPriority(102);
            long UPDATE_INTERVAL = 10000L;
            this.mLocationRequest.setInterval(UPDATE_INTERVAL);
            long FASTEST_INTERVAL = 1000L;
            this.mLocationRequest.setFastestInterval(FASTEST_INTERVAL);
            this.mLocationRequest.setMaxWaitTime(2000L);
            this.mLocationRequest.setNumUpdates(1);
            this.mLocationRequest.setExpirationDuration(5000L);
            LocationCallback locationCallback2 = new LocationCallback(){

                public void onLocationResult(LocationResult locationResult) {
                    Log.e((String)"Location", (String)"in result");
                    if (locationResult.getLocations().size() == 0) {
                        Log.e((String)"Location", (String)"No lcoations found");
                        return;
                    }
                    Location location = locationResult.getLastLocation();
                    Log.e((String)"Location", (String)(location.getLatitude() + "" + location.getLongitude()));
                    LocationUpdate.this.currentlocationlaltitue = location.getLatitude();
                    LocationUpdate.this.currentlocationlongitude = location.getLongitude();
                    try {
                        List addresses = geocoder.getFromLocation(LocationUpdate.this.currentlocationlaltitue.doubleValue(), LocationUpdate.this.currentlocationlongitude.doubleValue(), 1);
                        Address address2 = (Address)addresses.get(0);
                        if (address2 != null) {
                            LocationUpdate.this.currentlocation = address2.getAddressLine(0);
                        } else {
                            LocationUpdate.this.currentlocation = LocationUpdate.this.currentlocationlaltitue + "," + LocationUpdate.this.currentlocationlongitude;
                        }
                    }
                    catch (Exception e) {
                        LocationUpdate.this.currentlocation = LocationUpdate.this.currentlocationlaltitue + "," + LocationUpdate.this.currentlocationlongitude;
                    }
                    HcmDatabase.getInstance(LocationUpdate.this.getApplicationContext()).insertLocation(LocationUpdate.this.registeredcompany, LocationUpdate.this.registeredemailid, LocationUpdate.this.currentlocation, "", LocationUpdate.this.currentlocationlaltitue.toString(), LocationUpdate.this.currentlocationlongitude.toString());
                    LocationUpdate.this.syncData();
                }
            };
            Log.e((String)"called", (String)"yes");
            this.mFusedLocationClient.requestLocationUpdates(this.mLocationRequest, locationCallback2, Looper.myLooper());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void syncData() {
        final HcmDatabase hcmDatabase = HcmDatabase.getInstance(this.getApplicationContext());
        StringRequest postRequest2 = new StringRequest(1, "http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/hcm/insert_location.php", (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.d((String)"Response", (String)response);
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    hcmDatabase.updateLocationSynced(jsonObject.getJSONArray("list"));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Log.d((String)"Error.Response", (String)error.toString());
            }
        }){

            protected Map<String, String> getParams() {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("JSON", hcmDatabase.getLocationNotSynced().toString());
                return params;
            }
        };
        Volley.newRequestQueue((Context)this.getApplicationContext()).add((Request)postRequest2);
    }
}

