/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.hcm.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.util.Base64;
import android.util.Log;
import com.android.volley.RequestQueue;
import com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper.sqldatabase;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class HcmDatabase {
    private static HcmDatabase mInstance;
    private RequestQueue mRequestQueue;
    private static Context mContext;
    private static sqldatabase sqliteHelper;

    private HcmDatabase(Context context) {
        mContext = context;
        sqliteHelper = new sqldatabase(context);
    }

    public static synchronized HcmDatabase getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new HcmDatabase(context);
        }
        return mInstance;
    }

    public JSONArray getTravelsList(String status) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        JSONArray jsonArray = new JSONArray();
        String query = "SELECT * FROM travel WHERE tr_status='" + status + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                do {
                    try {
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("id", (Object)cursor.getString(cursor.getColumnIndexOrThrow("tr_id")));
                        jsonObject.put("dt", (Object)cursor.getString(cursor.getColumnIndexOrThrow("updated_datetime")));
                        jsonArray.put((Object)jsonObject);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (cursor.moveToNext());
            }
            cursor.close();
        }
        return jsonArray;
    }

    public JSONArray getTravels(String status) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM travel WHERE tr_status='" + status + "'";
        switch (status.toLowerCase()) {
            case "request": {
                query = query + " ORDER BY " + "t_datetime" + " DESC";
                break;
            }
            case "approved": {
                query = query + " ORDER BY " + "tr_start" + " ASC";
                break;
            }
            case "cancel": {
                query = query + " ORDER BY " + "tr_end" + " DESC";
            }
        }
        Cursor cursor = sdb.rawQuery(query, null);
        return HcmDatabase.cursorToArray(cursor);
    }

    public JSONArray getExpenses() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM travel_expense WHERE exp_deleted='no'";
        query = query + " ORDER BY " + "exp_datetime" + " DESC";
        Cursor cursor = sdb.rawQuery(query, null);
        return HcmDatabase.cursorToArray(cursor);
    }

    public JSONObject getTravelInfo(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM travel WHERE tr_id='" + id2 + "'", null);
        if (cursor != null) {
            cursor.moveToFirst();
            return HcmDatabase.cursorToJson(cursor);
        }
        return null;
    }

    public JSONObject getExpenseInfo(String id2) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM travel_expense WHERE exp_id='" + id2 + "'", null);
        if (cursor != null) {
            cursor.moveToFirst();
            return HcmDatabase.cursorToJson(cursor);
        }
        return null;
    }

    public void insertTravels(JSONArray jsonArray) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = JSONUtils.jsonToValues(jsonObject);
            sdb.insertWithOnConflict("travel", null, cv, 5);
        }
        sdb.close();
    }

    public void insertExpenses(JSONArray jsonArray) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = JSONUtils.jsonToValues(jsonObject);
            sdb.insertWithOnConflict("travel_expense", null, cv, 5);
        }
        sdb.close();
    }

    public void insetAttendanceTable(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                ContentValues cv = new ContentValues();
                cv.put("companyname", jsonObject.getString("companyname"));
                cv.put("emailid", jsonObject.getString("emailid"));
                cv.put("date", jsonObject.getString("date"));
                cv.put("checkintime", jsonObject.getString("checkintime"));
                cv.put("checkouttime", jsonObject.getString("checkouttime"));
                cv.put("checkinlocation", jsonObject.getString("checkinlocation"));
                cv.put("checkoutlocation", jsonObject.getString("checkoutlocation"));
                cv.put("status", jsonObject.getString("status"));
                cv.put("totaltime", jsonObject.getString("totaltime"));
                cv.put("INSYNC", "Yes");
                if (jsonObject.getString("checkouttime").equalsIgnoreCase("00:00:00")) {
                    cv.put("OUTSYNC", "No");
                } else {
                    cv.put("OUTSYNC", "Yes");
                }
                sdb.insertWithOnConflict("attendancetable", null, cv, 5);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void insertTimesheet(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                ContentValues cv = new ContentValues();
                cv.put("companyname", jsonObject.getString("companyname"));
                cv.put("employeemailid", jsonObject.getString("employeemailid"));
                cv.put("attendancegroup", jsonObject.getString("attendancegroup"));
                cv.put("attendancesubgroup", jsonObject.getString("attendancesubgroup"));
                cv.put("attendanceteam", jsonObject.getString("attendenceteam"));
                cv.put("activity", jsonObject.getString("activity"));
                cv.put("latitude", jsonObject.getString("latitude"));
                cv.put("longitude", jsonObject.getString("longitude"));
                cv.put("location", jsonObject.getString("location"));
                cv.put("timesheetdate", jsonObject.getString("timesheetdate"));
                cv.put("starttime", jsonObject.getString("starttime"));
                cv.put("endtime", jsonObject.getString("endtime"));
                cv.put("dateandtime", jsonObject.getString("dateandtime"));
                cv.put("sync", "yes");
                sdb.insertWithOnConflict("timesheettable", null, cv, 5);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void insertLeaves(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            try {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                ContentValues cv = new ContentValues();
                cv.put("companyname", jsonObject.getString("companyname"));
                cv.put("employeemailid", jsonObject.getString("employeemailid"));
                cv.put("leavetype", jsonObject.getString("leavetype"));
                cv.put("leavefrom", jsonObject.getString("leavefrom"));
                cv.put("leaveto", jsonObject.getString("leaveto"));
                cv.put("leavedays", jsonObject.getString("leavedays"));
                cv.put("permissiondate", jsonObject.getString("permissiondate"));
                cv.put("permissionfrom", jsonObject.getString("permissionfrom"));
                cv.put("permissionto", jsonObject.getString("permissionto"));
                cv.put("permissioninminutes", jsonObject.getString("permissioninminutes"));
                cv.put("appliedateandtime", jsonObject.getString("appliedateandtime"));
                cv.put("reasonforleaveorpermission", jsonObject.getString("reasonforleaveorpermission"));
                cv.put("status", jsonObject.getString("status"));
                cv.put("acceptedorrejecteddateandtime", jsonObject.getString("acceptedorrejecteddateandtime"));
                cv.put("rejectedreason", jsonObject.getString("rejectedreason"));
                cv.put("priority", jsonObject.getString("priority"));
                cv.put("SYNC", "Yes");
                cv.put("syncwithserver", "No");
                sdb.insertWithOnConflict("leavetable", null, cv, 5);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public JSONArray getLocationNotSynced() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query("locationtable", null, "SYNC = ? ", new String[]{"No"}, null, null, "_id DESC ");
        return HcmDatabase.cursorToArray(c);
    }

    public JSONArray getTimesheetNotSynced() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query("timesheettable", null, "sync = ? ", new String[]{"no"}, null, null, "_id ASC ");
        return HcmDatabase.cursorToArray(c);
    }

    public JSONArray getLeavesNotSynced() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query("leavetable", null, "SYNC = ? ", new String[]{"No"}, null, null, "_id ASC ");
        return HcmDatabase.cursorToArray(c);
    }

    public JSONArray getAttendanceNotSynced() throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query("attendancetable", null, "INSYNC = ? AND OUTSYNC = ? ", new String[]{"No", "No"}, null, null, "_id DESC ");
        JSONArray jsonArray = new JSONArray();
        if (c.moveToFirst()) {
            do {
                JSONObject JSONList = new JSONObject();
                JSONList.put("companyname", (Object)c.getString(c.getColumnIndexOrThrow("companyname")));
                JSONList.put("emailid", (Object)c.getString(c.getColumnIndexOrThrow("emailid")));
                JSONList.put("date", (Object)c.getString(c.getColumnIndexOrThrow("date")));
                JSONList.put("checkintime", (Object)c.getString(c.getColumnIndexOrThrow("checkintime")));
                JSONList.put("checkouttime", (Object)c.getString(c.getColumnIndexOrThrow("checkouttime")));
                JSONList.put("checkinlocation", (Object)c.getString(c.getColumnIndexOrThrow("checkinlocation")));
                JSONList.put("checkoutlocation", (Object)c.getString(c.getColumnIndexOrThrow("checkoutlocation")));
                JSONList.put("status", (Object)c.getString(c.getColumnIndexOrThrow("status")));
                JSONList.put("totaltime", (Object)c.getString(c.getColumnIndexOrThrow("totaltime")));
                JSONList.put("_id", (Object)c.getString(c.getColumnIndexOrThrow("_id")));
                byte[] cam = c.getBlob(c.getColumnIndexOrThrow("attendanceimage"));
                String temp = null;
                if (cam != null) {
                    temp = Base64.encodeToString((byte[])cam, (int)0);
                }
                JSONList.put("checkinimage", (Object)temp);
                JSONList.put("checkinimagepath", (Object)c.getString(c.getColumnIndexOrThrow("imagepath")));
                byte[] cam1 = c.getBlob(c.getColumnIndexOrThrow("signature"));
                String temp1 = null;
                if (cam1 != null) {
                    temp1 = Base64.encodeToString((byte[])cam1, (int)0);
                }
                JSONList.put("checkinsignature", (Object)temp1);
                JSONList.put("checkinsignaturepath", (Object)c.getString(c.getColumnIndexOrThrow("signaturepath")));
                jsonArray.put((Object)JSONList);
            } while (c.moveToNext());
        }
        return jsonArray;
    }

    public JSONArray getAttendanceCheckOutNotSynced() throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query("attendancetable", null, "INSYNC = ? OR OUTSYNC = ? ", new String[]{"No", "No"}, null, null, "_id DESC ");
        JSONArray jsonArray = new JSONArray();
        if (c.moveToFirst()) {
            do {
                JSONObject JSONList = new JSONObject();
                JSONList.put("companyname", (Object)c.getString(c.getColumnIndexOrThrow("companyname")));
                JSONList.put("emailid", (Object)c.getString(c.getColumnIndexOrThrow("emailid")));
                JSONList.put("date", (Object)c.getString(c.getColumnIndexOrThrow("date")));
                JSONList.put("checkintime", (Object)c.getString(c.getColumnIndexOrThrow("checkintime")));
                JSONList.put("checkouttime", (Object)c.getString(c.getColumnIndexOrThrow("checkouttime")));
                JSONList.put("checkinlocation", (Object)c.getString(c.getColumnIndexOrThrow("checkinlocation")));
                JSONList.put("checkoutlocation", (Object)c.getString(c.getColumnIndexOrThrow("checkoutlocation")));
                JSONList.put("status", (Object)c.getString(c.getColumnIndexOrThrow("status")));
                JSONList.put("totaltime", (Object)c.getString(c.getColumnIndexOrThrow("totaltime")));
                JSONList.put("_id", (Object)c.getString(c.getColumnIndexOrThrow("_id")));
                jsonArray.put((Object)JSONList);
            } while (c.moveToNext());
        }
        return jsonArray;
    }

    public void updateLocationSynced(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ContentValues cv = new ContentValues();
            cv.put("SYNC", "Yes");
            try {
                sdb.update("locationtable", cv, "_id = ? ", new String[]{jsonArray.getString(i)});
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateTimesheetSynced(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ContentValues cv = new ContentValues();
            cv.put("sync", "Yes");
            try {
                sdb.update("timesheettable", cv, "_id = ? ", new String[]{jsonArray.getString(i)});
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateAttendanceSynced(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ContentValues cv = new ContentValues();
            cv.put("INSYNC", "Yes");
            try {
                sdb.update("attendancetable", cv, "status = ?  AND _id = ? ", new String[]{"IN", jsonArray.getString(i)});
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            cv.put("OUTSYNC", "Yes");
            try {
                sdb.update("attendancetable", cv, "status = ?  AND _id = ? ", new String[]{"Present", jsonArray.getString(i)});
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLeavesSynced(JSONArray jsonArray) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            ContentValues cv = new ContentValues();
            cv.put("SYNC", "Yes");
            try {
                sdb.update("leavetable", cv, "_id = ? ", new String[]{jsonArray.getString(i)});
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLeaveDeleted(String leavetype, String applieddatenadtime) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        sdb.delete("leavetable", "leavetype = ? AND appliedateandtime = ? ", new String[]{leavetype, applieddatenadtime});
    }

    private static JSONObject cursorToJson(Cursor c) throws JSONException {
        JSONObject retVal = new JSONObject();
        block6: for (int i = 0; i < c.getColumnCount(); ++i) {
            String cName = c.getColumnName(i);
            switch (c.getType(i)) {
                case 1: {
                    retVal.put(cName, c.getInt(i));
                    continue block6;
                }
                case 2: {
                    retVal.put(cName, (double)c.getFloat(i));
                    continue block6;
                }
                case 3: {
                    retVal.put(cName, (Object)c.getString(i));
                    continue block6;
                }
                case 4: {
                    retVal.put(cName, (Object)Utility.getString(c.getBlob(i)));
                }
            }
        }
        return retVal;
    }

    private static JSONArray cursorToArray(Cursor c) {
        JSONArray jsonArray = new JSONArray();
        if (c != null) {
            if (c.getCount() > 0) {
                c.moveToFirst();
                do {
                    try {
                        jsonArray.put((Object)HcmDatabase.cursorToJson(c));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (c.moveToNext());
            }
            c.close();
        }
        return jsonArray;
    }

    public void insertLocation(String Companyname, String emailid, String location, String checkinname, String latitude, String longitude) {
        try {
            SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("COMPANYNAME", Companyname);
            cv.put("EMAILID", emailid);
            cv.put("LOCATION", location);
            cv.put("CHECKINNAME", checkinname);
            cv.put("LATITUDE", latitude);
            cv.put("LONGITUDE", longitude);
            cv.put("DATE", DateUtils.getCurrentDate());
            cv.put("TIME", DateUtils.getCurrentTime());
            cv.put("SYNC", "No");
            sdb.insert("locationtable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCheckinTime() throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query("attendancetable", null, "date = ? ", new String[]{DateUtils.getCurrentDate()}, null, null, "_id DESC ");
        String time = null;
        JSONArray jsonArray = new JSONArray();
        if (c.moveToFirst()) {
            do {
                time = c.getString(c.getColumnIndexOrThrow("checkintime"));
            } while (c.moveToNext());
        }
        return time;
    }

    public boolean isCheckedIn() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.query("attendancetable", null, "date = ? ", new String[]{DateUtils.getCurrentDate()}, null, null, "_id DESC ");
        return c != null && c.moveToFirst();
    }

    public String getLeavesmonthlycount(String startdate, String enddate) throws JSONException {
        String leaves = "0";
        Log.d((String)"beforeleaves", (String)leaves);
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query1 = "  SELECT leavefrom FROM leavetable";
        String query = "  SELECT SUM(Final.dayscount) AS TotalLeaves FROM (( SELECT  CASE  WHEN leavefrom < '" + startdate + "' AND  " + "leaveto" + "  > '" + enddate + "' THEN (JULIANDAY('" + enddate + "')-JULIANDAY('" + startdate + "')+1 ) WHEN " + "leavefrom" + " < '" + startdate + "' AND  " + "leaveto" + "  <= '" + enddate + "' THEN (JULIANDAY( " + "leaveto" + ")-JULIANDAY('" + startdate + "')+1 )  WHEN " + "leavefrom" + " >= '" + startdate + "' AND  " + "leaveto" + "  > '" + enddate + "' THEN (JULIANDAY('" + enddate + "')-JULIANDAY( " + "leavefrom" + " )+1 )  WHEN " + "leavefrom" + "  >= '" + startdate + "' AND  " + "leaveto" + "  <= '" + enddate + "' THEN (JULIANDAY( " + "leaveto" + " )-JULIANDAY( " + "leavefrom" + " )+1 )  ELSE (JULIANDAY( " + "leaveto" + " )-JULIANDAY( " + "leavefrom" + " )+1 )  END AS dayscount," + "leavetype" + ", " + "leavefrom" + " ," + "leaveto" + "," + "leavedays" + "," + "status" + "," + "reasonforleaveorpermission" + " FROM " + "leavetable" + " where  " + "status" + " != 'pending'    and " + "leavedays" + " !=0 AND ( " + "leavefrom" + "  >= '" + startdate + "' and  " + "leaveto" + "  <= '" + enddate + "') or ( " + "leavefrom" + "  <= '" + enddate + "' and  " + "leaveto" + "  >= '" + enddate + "')  or ( " + "leavefrom" + "  <= '" + startdate + "' and  " + "leaveto" + "  >= '" + startdate + "') ORDER by  " + "leavefrom" + "  ASC ) AS Final ) ";
        Cursor c = sdb.rawQuery(query, null);
        if (c.moveToFirst()) {
            Log.d((String)"c count", (String)("" + c.getCount()));
            try {
                leaves = c.getString(c.getColumnIndexOrThrow("TotalLeaves")) == null ? "0" : c.getString(c.getColumnIndexOrThrow("TotalLeaves"));
            }
            catch (Throwable t) {
                Log.d((String)"Message", (String)t.getCause().getMessage());
                leaves = "0";
            }
            Log.d((String)"leaves", (String)leaves.toString());
        }
        return leaves;
    }

    public ArrayList<String> getLeavesmonthlydates(String startdate, String enddate) {
        String leavefromvalue = null;
        String leavetovalue = null;
        Date leavefromvalue_date = null;
        Date leavetovalue_date = null;
        Date startdate_date = null;
        Date enddate_date = null;
        ArrayList<String> Leave_dates = new ArrayList<String>();
        HashSet<String> set = new HashSet<String>(Leave_dates);
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "  SELECT leavetype, leavefrom ,leaveto,leavedays,status,reasonforleaveorpermission FROM leavetable where  status != 'pending'    and leavedays !=0 AND ( leavefrom  >= '" + startdate + "' and  " + "leaveto" + "  <= '" + enddate + "') or ( " + "leavefrom" + "  <= '" + enddate + "' and  " + "leaveto" + "  >= '" + enddate + "')  or ( " + "leavefrom" + "  <= '" + startdate + "' and  " + "leaveto" + "  >= '" + startdate + "') ORDER by  " + "leavefrom" + "  ASC  ";
        Cursor c = sdb.rawQuery(query, null);
        Calendar cal1 = null;
        Calendar cal2 = null;
        if (c.moveToFirst()) {
            do {
                leavefromvalue = c.getString(c.getColumnIndexOrThrow("leavefrom"));
                leavetovalue = c.getString(c.getColumnIndexOrThrow("leaveto"));
                SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                try {
                    leavefromvalue_date = format.parse(leavefromvalue);
                    leavetovalue_date = format.parse(leavetovalue);
                    startdate_date = format.parse(startdate);
                    enddate_date = format.parse(enddate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                cal1 = Calendar.getInstance();
                cal2 = Calendar.getInstance();
                if (startdate_date.compareTo(leavefromvalue_date) > 0 && leavetovalue_date.compareTo(enddate_date) > 0) {
                    cal1.setTime(startdate_date);
                    cal2.setTime(enddate_date);
                    while (!cal1.after(cal2)) {
                        set.add(format.format(cal1.getTime()).toString());
                        cal1.add(5, 1);
                    }
                } else if (startdate_date.compareTo(leavefromvalue_date) > 0 && enddate_date.compareTo(leavetovalue_date) > 0) {
                    cal1.setTime(startdate_date);
                    cal2.setTime(leavetovalue_date);
                    while (!cal1.after(cal2)) {
                        set.add(format.format(cal1.getTime()).toString());
                        cal1.add(5, 1);
                    }
                } else if (leavefromvalue_date.compareTo(startdate_date) > 0 && leavetovalue_date.compareTo(enddate_date) > 0) {
                    cal1.setTime(leavefromvalue_date);
                    cal2.setTime(enddate_date);
                    while (!cal1.after(cal2)) {
                        set.add(format.format(cal1.getTime()).toString());
                        cal1.add(5, 1);
                    }
                } else {
                    if (leavefromvalue_date.compareTo(startdate_date) <= 0 || enddate_date.compareTo(leavetovalue_date) <= 0) continue;
                    cal1.setTime(leavefromvalue_date);
                    cal2.setTime(leavetovalue_date);
                    while (!cal1.after(cal2)) {
                        set.add(format.format(cal1.getTime()).toString());
                        cal1.add(5, 1);
                    }
                }
            } while (c.moveToNext());
            Leave_dates.addAll(set);
        }
        return Leave_dates;
    }

    public ArrayList<String> getLeavedetail_selecteddate(String selecteddate) {
        String query;
        ArrayList<String> Leave_details = new ArrayList<String>();
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor c = sdb.rawQuery(query = "  SELECT leavetype, permissiondate, permissionfrom, permissionto, permissioninminutes, leavefrom ,leaveto,leavedays,status,reasonforleaveorpermission FROM leavetable where  status != 'pending' AND leavedays !=0   AND (('" + selecteddate + "' >= " + "leavefrom" + "  and  '" + selecteddate + "' <= " + "leaveto" + ") ) ORDER by  " + "leavefrom" + "  ASC  ", null);
        if (c != null) {
            if (c.getCount() > 0) {
                c.moveToFirst();
                try {
                    SimpleDateFormat formatter1 = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);
                    SimpleDateFormat formatter2 = new SimpleDateFormat("dd MMM yyyy", Locale.ENGLISH);
                    Leave_details.add(formatter2.format(formatter1.parse(c.getString(c.getColumnIndexOrThrow("leavefrom")))).toString());
                    Leave_details.add(formatter2.format(formatter1.parse(c.getString(c.getColumnIndexOrThrow("leaveto")))).toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Leave_details.add(c.getString(c.getColumnIndexOrThrow("leavedays")));
                Leave_details.add(c.getString(c.getColumnIndexOrThrow("reasonforleaveorpermission")));
                Leave_details.add(c.getString(c.getColumnIndexOrThrow("leavetype")));
            }
            c.close();
        }
        return Leave_details;
    }

    private String changetimeformat(String input) {
        TimeZone utc = TimeZone.getTimeZone("etc/UTC");
        SimpleDateFormat inputFormat = new SimpleDateFormat("HH:mm:ss", Locale.US);
        inputFormat.setTimeZone(utc);
        SimpleDateFormat outputFormat = new SimpleDateFormat("hh:mm aa", Locale.US);
        outputFormat.setTimeZone(utc);
        Date date = null;
        try {
            date = inputFormat.parse(input);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        String output = outputFormat.format(date);
        return output;
    }
}

