/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.notes.room;

import android.database.Cursor;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.lifecycle.LiveData;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.b2lmobitech.fieldcloudplus.notes.room.NoteEntity;
import com.b2lmobitech.fieldcloudplus.notes.room.NotesDAO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;

public final class NotesDAO_Impl
implements NotesDAO {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<NoteEntity> __insertionAdapterOfNoteEntity;
    private final EntityDeletionOrUpdateAdapter<NoteEntity> __deletionAdapterOfNoteEntity;
    private final EntityDeletionOrUpdateAdapter<NoteEntity> __updateAdapterOfNoteEntity;

    public NotesDAO_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfNoteEntity = new EntityInsertionAdapter<NoteEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `NoteEntity` (`id`,`notes`,`title`,`createdOn`,`updatedOn`,`deleted`) VALUES (?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull NoteEntity entity) {
                statement.bindLong(1, (long)entity.getId());
                if (entity.getNotes() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getNotes());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getTitle());
                }
                if (entity.getCreatedOn() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getCreatedOn());
                }
                if (entity.getUpdatedOn() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getUpdatedOn());
                }
                statement.bindLong(6, (long)entity.getDeleted());
            }
        };
        this.__deletionAdapterOfNoteEntity = new EntityDeletionOrUpdateAdapter<NoteEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `NoteEntity` WHERE `id` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull NoteEntity entity) {
                statement.bindLong(1, (long)entity.getId());
            }
        };
        this.__updateAdapterOfNoteEntity = new EntityDeletionOrUpdateAdapter<NoteEntity>(__db){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `NoteEntity` SET `id` = ?,`notes` = ?,`title` = ?,`createdOn` = ?,`updatedOn` = ?,`deleted` = ? WHERE `id` = ?";
            }

            protected void bind(@NonNull SupportSQLiteStatement statement, @NonNull NoteEntity entity) {
                statement.bindLong(1, (long)entity.getId());
                if (entity.getNotes() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindString(2, entity.getNotes());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindString(3, entity.getTitle());
                }
                if (entity.getCreatedOn() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindString(4, entity.getCreatedOn());
                }
                if (entity.getUpdatedOn() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindString(5, entity.getUpdatedOn());
                }
                statement.bindLong(6, (long)entity.getDeleted());
                statement.bindLong(7, (long)entity.getId());
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Long save(NoteEntity key) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            Long _result = this.__insertionAdapterOfNoteEntity.insertAndReturnId((Object)key);
            this.__db.setTransactionSuccessful();
            Long l = _result;
            return l;
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(NoteEntity key) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfNoteEntity.handle((Object)key);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void merge(NoteEntity key) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfNoteEntity.handle((Object)key);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public LiveData<List<NoteEntity>> getAll() {
        String _sql = "SELECT * FROM NoteEntity WHERE deleted=0 ORDER BY id DESC";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM NoteEntity WHERE deleted=0 ORDER BY id DESC", (int)0);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"NoteEntity"}, false, (Callable)new Callable<List<NoteEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<NoteEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)NotesDAO_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"notes");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfCreatedOn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdOn");
                    int _cursorIndexOfUpdatedOn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedOn");
                    int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                    ArrayList<NoteEntity> _result = new ArrayList<NoteEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        String _tmpNotes = _cursor.isNull(_cursorIndexOfNotes) ? null : _cursor.getString(_cursorIndexOfNotes);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        String _tmpCreatedOn = _cursor.isNull(_cursorIndexOfCreatedOn) ? null : _cursor.getString(_cursorIndexOfCreatedOn);
                        String _tmpUpdatedOn = _cursor.isNull(_cursorIndexOfUpdatedOn) ? null : _cursor.getString(_cursorIndexOfUpdatedOn);
                        int _tmpDeleted = _cursor.getInt(_cursorIndexOfDeleted);
                        NoteEntity _item = new NoteEntity(_tmpId, _tmpNotes, _tmpTitle, _tmpCreatedOn, _tmpUpdatedOn, _tmpDeleted);
                        _result.add(_item);
                    }
                    ArrayList<NoteEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @Override
    public LiveData<List<NoteEntity>> getAll(int limit) {
        String _sql = "SELECT * FROM NoteEntity WHERE deleted=0 ORDER BY id DESC LIMIT ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"SELECT * FROM NoteEntity WHERE deleted=0 ORDER BY id DESC LIMIT ?", (int)1);
        int _argIndex = 1;
        _statement.bindLong(_argIndex, (long)limit);
        return this.__db.getInvalidationTracker().createLiveData(new String[]{"NoteEntity"}, false, (Callable)new Callable<List<NoteEntity>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @Nullable
            public List<NoteEntity> call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)NotesDAO_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    int _cursorIndexOfId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"id");
                    int _cursorIndexOfNotes = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"notes");
                    int _cursorIndexOfTitle = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"title");
                    int _cursorIndexOfCreatedOn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdOn");
                    int _cursorIndexOfUpdatedOn = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedOn");
                    int _cursorIndexOfDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"deleted");
                    ArrayList<NoteEntity> _result = new ArrayList<NoteEntity>(_cursor.getCount());
                    while (_cursor.moveToNext()) {
                        int _tmpId = _cursor.getInt(_cursorIndexOfId);
                        String _tmpNotes = _cursor.isNull(_cursorIndexOfNotes) ? null : _cursor.getString(_cursorIndexOfNotes);
                        String _tmpTitle = _cursor.isNull(_cursorIndexOfTitle) ? null : _cursor.getString(_cursorIndexOfTitle);
                        String _tmpCreatedOn = _cursor.isNull(_cursorIndexOfCreatedOn) ? null : _cursor.getString(_cursorIndexOfCreatedOn);
                        String _tmpUpdatedOn = _cursor.isNull(_cursorIndexOfUpdatedOn) ? null : _cursor.getString(_cursorIndexOfUpdatedOn);
                        int _tmpDeleted = _cursor.getInt(_cursorIndexOfDeleted);
                        NoteEntity _item = new NoteEntity(_tmpId, _tmpNotes, _tmpTitle, _tmpCreatedOn, _tmpUpdatedOn, _tmpDeleted);
                        _result.add(_item);
                    }
                    ArrayList<NoteEntity> arrayList = _result;
                    return arrayList;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

