/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.others.sql.sqlitehelper;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.SQLException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.graphics.Bitmap;
import android.util.Log;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;

public class sqldatabase
extends SQLiteOpenHelper {
    public static final int DATABASE_VERSION = 1;
    public static final String DATABASE_NAME = "hcm.db3";

    public sqldatabase(Context context) {
        super(context, DATABASE_NAME, null, 1);
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE IF NOT EXISTS attendancetable (_id INTEGER PRIMARY KEY ,companyname TEXT,emailid TEXT,date TEXT,checkintime TEXT,checkouttime TEXT,checkinlocation TEXT,checkoutlocation TEXT,status TEXT,totaltime TEXT,INSYNC TEXT,OUTSYNC TEXT,attendanceimage BLOB,imagepath TEXT,signature BLOB,signaturepath TEXT,CONSTRAINT attendance_unique UNIQUE (date));");
        db.execSQL("CREATE TABLE IF NOT EXISTS locationtable (_id INTEGER PRIMARY KEY ,COMPANYNAME TEXT,EMAILID TEXT,LOCATION TEXT,CHECKINNAME TEXT,LATITUDE TEXT,LONGITUDE TEXT,DATE TEXT,TIME TEXT,SYNC TEXT);");
        db.execSQL("CREATE TABLE IF NOT EXISTS leavetable (_id INTEGER PRIMARY KEY ,companyname TEXT,employeemailid TEXT,leavetype TEXT,leavefrom TEXT,leaveto TEXT,leavedays TEXT,permissiondate TEXT,permissionfrom TEXT,permissionto TEXT,permissioninminutes TEXT,appliedateandtime TEXT,reasonforleaveorpermission TEXT,status TEXT,acceptedorrejecteddateandtime TEXT,rejectedreason TEXT,priority TEXT,SYNC TEXT,syncwithserver TEXT, CONSTRAINT leave_unique UNIQUE(leavetype,appliedateandtime));");
        db.execSQL("CREATE TABLE IF NOT EXISTS timesheettable (_id INTEGER PRIMARY KEY ,companyname TEXT,employeemailid TEXT,attendancegroup TEXT,attendancesubgroup TEXT,attendanceteam TEXT,activity TEXT,latitude TEXT,longitude TEXT,location TEXT,timesheetdate TEXT,starttime TEXT,endtime TEXT,dateandtime TEXT,sync TEXT,CONSTRAINT timesheet_unique UNIQUE (dateandtime));");
        db.execSQL("CREATE TABLE IF NOT EXISTS dynamicquestionstable (_id INTEGER PRIMARY KEY ,companyname TEXT,customername TEXT,questionnumber TEXT,category TEXT,categorystatus TEXT DEFAULT 'disable',subcategory TEXT,question TEXT,typeofquestion TEXT,count TEXT,optionforanswers TEXT,dateandtime TEXT,correctanswer TEXT,questionmode TEXT,customertype TEXT,combinationname TEXT);");
        db.execSQL("CREATE TABLE IF NOT EXISTS dynamicquestionstablelocal (_id INTEGER PRIMARY KEY ,companyname TEXT,customername TEXT,facility TEXT,questionnumber TEXT,category TEXT,subcategory TEXT,question TEXT,typeofquestion TEXT,count TEXT,optionforanswers TEXT,dateandtime TEXT,downloaddate TEXT,correctanswer TEXT,questionmode TEXT,customertype TEXT,combinationname TEXT,combinationtype TEXT);");
        db.execSQL("CREATE TABLE IF NOT EXISTS answerstable (_id INTEGER PRIMARY KEY ,companyname TEXT,customername TEXT,atmid TEXT,emailid TEXT,category TEXT,subcategory TEXT,questionnumber TEXT,question TEXT,typeofquestion TEXT,answer TEXT,image BLOB,imagepath TEXT,dateandtime TEXT,issue TEXT,questionmode TEXT,customertype TEXT,combinationname TEXT);");
        db.execSQL("CREATE TABLE IF NOT EXISTS answerstablelocal (_id INTEGER PRIMARY KEY ,companyname TEXT,customername TEXT,atmid TEXT,emailid TEXT,category TEXT,subcategory TEXT,questionnumber TEXT,question TEXT,typeofquestion TEXT,answer TEXT,image BLOB,imagepath TEXT,dateandtime TEXT,issue TEXT,questionmode TEXT,customertype TEXT,combinationname TEXT,uniqueid TEXT,sync TEXT);");
        db.execSQL("CREATE TABLE IF NOT EXISTS ticketstable (_id INTEGER PRIMARY KEY ,companyname TEXT,Assignedto TEXT,rejectedby TEXT,ticketstatus TEXT,ticketstage TEXT,ticketnumber TEXT,customername TEXT,atmid TEXT,source TEXT,priority TEXT,createddateandtime TEXT,assigneddateandtime TEXT,questionorcallreason TEXT,acceptedby TEXT,accepteddateandtime TEXT,rejecteddateandtime TEXT,reasonforrejection TEXT,brand TEXT,product TEXT,model TEXT,serialnumber TEXT,questionmode TEXT,questiontype TEXT,combinationname TEXT,combinationtype TEXT);");
        db.execSQL("CREATE TABLE IF NOT EXISTS sparestable (_id INTEGER PRIMARY KEY ,companyname TEXT,combinationname TEXT,combinationtype TEXT,ticketnumber TEXT,sku TEXT,itemname TEXT,amount TEXT,quantity TEXT,totalamount TEXT,dateandtime TEXT);");
        db.execSQL("CREATE TABLE  IF NOT EXISTS travel(_id INTEGER PRIMARY KEY,company VARCHAR(200),tr_id VARCHAR(200),tr_emailid TEXT,tr_place_to_visit TEXT,tr_start TEXT,tr_end TEXT,tr_duration TEXT,tr_purpose_visit TEXT,tr_customer_name TEXT,tr_billable TEXT,tr_travel_type TEXT,tr_status TEXT,t_datetime TEXT,updated_datetime TEXT,createdby TEXT,createdtype TEXT,t_deleted TEXT,CONSTRAINT trip_unique UNIQUE (tr_id));");
        db.execSQL("CREATE TABLE  IF NOT EXISTS travel_expense(_id INTEGER PRIMARY KEY,tr_id VARCHAR(200),exp_id TEXT,company TEXT,exp_from_location TEXT,exp_to_location TEXT,exp_amount TEXT,exp_emailid TEXT,exp_type TEXT,img_path TEXT,exp_datetime TEXT,exp_created_by TEXT,exp_created_type TEXT,exp_deleted TEXT,CONSTRAINT assign_unique UNIQUE (exp_id));");
        db.execSQL("CREATE TABLE IF NOT EXISTS task_notes (_id INTEGER PRIMARY KEY ,datetime TEXT,title TEXT,description TEXT,CONSTRAINT request_unique UNIQUE (datetime));");
        ContentValues cv = new ContentValues();
        cv.put("title", "Field Cloud");
        cv.put("datetime", "0000-00-00 00:00:00");
        cv.put("description", "You can save your notes here");
        db.insertWithOnConflict("task_notes", null, cv, 5);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("DROP TABLE IF EXISTS attendancetable");
        db.execSQL("DROP TABLE IF EXISTS locationtable");
        db.execSQL("DROP TABLE IF EXISTS dynamicquestionstable");
        db.execSQL("DROP TABLE IF EXISTS answerstable");
        db.execSQL("DROP TABLE IF EXISTS dynamicquestionstablelocal");
        db.execSQL("DROP TABLE IF EXISTS answerstablelocal");
        db.execSQL("DROP TABLE IF EXISTS ticketstable");
        db.execSQL("DROP TABLE IF EXISTS leavetable");
        db.execSQL("DROP TABLE IF EXISTS timesheettable");
        db.execSQL("DROP TABLE IF EXISTS sparestable");
        db.execSQL("DROP TABLE IF EXISTS task_request");
        db.execSQL("DROP TABLE IF EXISTS task_progress");
        db.execSQL("DROP TABLE IF EXISTS task_sequence");
        db.execSQL("DROP TABLE IF EXISTS task_task");
        db.execSQL("DROP TABLE IF EXISTS task_notifications");
        this.onCreate(db);
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        this.onUpgrade(db, oldVersion, newVersion);
    }

    public void insert_attendancetable(String Companyname, String emailid, String date, String checkintime, String checkouttime, String checkinlocation, String checkoutlocation, String status, String toaltime, String Insync, String Outsync, Bitmap attendanceimage2, String Imagepath, Bitmap signature, String signaturepath) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("emailid", emailid);
            cv.put("date", date);
            cv.put("checkintime", checkintime);
            cv.put("checkouttime", checkouttime);
            cv.put("checkinlocation", checkinlocation);
            cv.put("checkoutlocation", checkoutlocation);
            cv.put("status", status);
            cv.put("totaltime", toaltime);
            cv.put("INSYNC", Insync);
            cv.put("OUTSYNC", Outsync);
            cv.put("attendanceimage", globalvariables.getBytes(attendanceimage2));
            cv.put("imagepath", Imagepath);
            cv.put("signature", globalvariables.getBytes(signature));
            cv.put("signaturepath", signaturepath);
            sdb.insert("attendancetable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_attendancetable_dump(String Companyname, String emailid, String date, String checkintime, String checkouttime, String checkinlocation, String checkoutlocation, String status, String toaltime, String Insync, String Outsync) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("emailid", emailid);
            cv.put("date", date);
            cv.put("checkintime", checkintime);
            cv.put("checkouttime", checkouttime);
            cv.put("checkinlocation", checkinlocation);
            cv.put("checkoutlocation", checkoutlocation);
            cv.put("status", status);
            cv.put("totaltime", toaltime);
            cv.put("INSYNC", Insync);
            cv.put("OUTSYNC", Outsync);
            sdb.insert("attendancetable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_attendancetable_dump(String date, String Insync, String Outsync) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("INSYNC", Insync);
            cv.put("OUTSYNC", Outsync);
            sdb.update("attendancetable", cv, "date = ? ", new String[]{date});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_spares(String Companyname, String combinationname, String combinationtype, String ticketnumber, String sku, String item, String amount, String quantity, String total, String date) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("combinationname", combinationname);
            cv.put("combinationtype", combinationtype);
            cv.put("ticketnumber", ticketnumber);
            cv.put("sku", sku);
            cv.put("itemname", item);
            cv.put("quantity", quantity);
            cv.put("amount", amount);
            cv.put("totalamount", total);
            cv.put("dateandtime", date);
            sdb.insert("sparestable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_attendancetable_checkout(String Companyname, String emailid, String date, String checkouttime, String checkoutlocation, String status, String toaltime) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("checkouttime", checkouttime);
            cv.put("checkoutlocation", checkoutlocation);
            cv.put("status", status);
            cv.put("totaltime", toaltime);
            sdb.update("attendancetable", cv, "companyname = ?  AND emailid = ? AND date = ? ", new String[]{Companyname, emailid, date});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_attendancetable_sync(String Companyname, String emailid, String date, String Insync, String Outsync) {
        Log.e((String)"inset sync", (String)"called");
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("INSYNC", Insync);
            cv.put("OUTSYNC", Outsync);
            sdb.update("attendancetable", cv, "companyname = ?  AND emailid = ? AND date = ? ", new String[]{Companyname, emailid, date});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_attendancetable_sync(String Companyname, String emailid, String date, String Outsync) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("OUTSYNC", Outsync);
            sdb.update("attendancetable", cv, "companyname = ?  AND emailid = ? AND date = ? ", new String[]{Companyname, emailid, date});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_timesheettable_sync(String emailid, String sync2) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("sync", sync2);
            sdb.update("timesheettable", cv, "employeemailid = ? ", new String[]{emailid});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_categories_updated(String category) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("categorystatus", "enable");
            sdb.update("dynamicquestionstable", cv, "category = ? ", new String[]{category});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_attendancetable(String Companyname, String emailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        String[] col = new String[]{"companyname", "emailid", "date", "checkintime", "checkouttime", "checkinlocation", "checkoutlocation", "status", "totaltime", "INSYNC", "OUTSYNC"};
        Cursor c = sdb.query("attendancetable", col, "companyname = ? AND emailid = ? ", new String[]{Companyname, emailid}, null, null, "_id DESC ");
        return c;
    }

    public Cursor get_attendancetable_checkin(String Companyname, String emailid, String date) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        String[] col = new String[]{"companyname", "emailid", "date", "checkintime", "checkouttime", "checkinlocation", "checkoutlocation", "status", "totaltime", "INSYNC", "OUTSYNC"};
        Cursor c = sdb.query("attendancetable", col, "companyname = ? AND emailid = ? AND date = ? ", new String[]{Companyname, emailid, date}, null, null, null);
        return c;
    }

    public Cursor get_attendancetable_checkout(String Companyname, String emailid, String date) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        String[] col = new String[]{"companyname", "emailid", "date", "checkintime", "checkouttime", "checkinlocation", "checkoutlocation", "status", "totaltime", "INSYNC", "OUTSYNC"};
        Cursor c = sdb.query("attendancetable", col, "companyname = ? AND emailid = ? AND date = ? AND ( checkouttime = ? OR checkouttime = ? )", new String[]{Companyname, emailid, date, "", "00:00:00"}, null, null, null);
        return c;
    }

    public Cursor get_attendancetable_datewise(String Companyname, String emailid, String date) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        String[] col = new String[]{"companyname", "emailid", "date", "checkintime", "checkouttime", "checkinlocation", "checkoutlocation", "status", "totaltime", "INSYNC", "OUTSYNC"};
        Cursor c = sdb.query("attendancetable", col, "companyname = ? AND emailid = ? AND date = ? ", new String[]{Companyname, emailid, date}, null, null, "_id DESC ");
        return c;
    }

    public Cursor get_attendancetable_notsynced(String Companyname, String emailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("attendancetable", null, "companyname = ? AND emailid = ? AND INSYNC = ? AND OUTSYNC = ? ", new String[]{Companyname, emailid, "No", "No"}, null, null, "_id DESC ");
        return c;
    }

    public Cursor get_attendancetable_updatenotsynced(String Companyname, String emailid, String status) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("attendancetable", null, "companyname = ? AND emailid = ? AND status = ? AND INSYNC = ? AND OUTSYNC = ? ", new String[]{Companyname, emailid, "Present", "Yes", "No"}, null, null, "_id DESC ");
        return c;
    }

    public Cursor get_attendancetable_checksynced(String Companyname, String emailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("attendancetable", null, "companyname = ? AND emailid = ? AND OUTSYNC = ? ", new String[]{Companyname, emailid, "No"}, null, null, "_id DESC ");
        return c;
    }

    public void insert_locationtable(String Companyname, String emailid, String location, String checkinname, String latitude, String longitude, String date, String time, String sync2) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("COMPANYNAME", Companyname);
            cv.put("EMAILID", emailid);
            cv.put("LOCATION", location);
            cv.put("CHECKINNAME", checkinname);
            cv.put("LATITUDE", latitude);
            cv.put("LONGITUDE", longitude);
            cv.put("DATE", date);
            cv.put("TIME", time);
            cv.put("SYNC", sync2);
            sdb.insert("locationtable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_location_duplicacy(String Companyname, String emailid, String date, String time) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("locationtable", null, "COMPANYNAME = ? AND EMAILID = ? AND DATE = ? AND TIME = ? ", new String[]{Companyname, emailid, date, time}, null, null, null);
        return c;
    }

    public Cursor get_location(String Companyname, String emailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("locationtable", null, "COMPANYNAME = ? AND EMAILID = ? ", new String[]{Companyname, emailid}, null, null, "_id DESC ");
        return c;
    }

    public Cursor get_locationtable_notsynced(String Companyname, String emailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("locationtable", null, "COMPANYNAME = ? AND EMAILID = ? AND SYNC = ? ", new String[]{Companyname, emailid, "No"}, null, null, "_id DESC ");
        return c;
    }

    public void update_locationtable_sync(String Companyname, String emailid, String date, String time, String sync2) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("SYNC", sync2);
            sdb.update("locationtable", cv, "COMPANYNAME = ?  AND EMAILID = ? AND DATE = ? AND TIME = ? ", new String[]{Companyname, emailid, date, time});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_location_datewise(String Companyname, String emailid, String date) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("locationtable", null, "COMPANYNAME = ? AND EMAILID = ? AND DATE = ? ", new String[]{Companyname, emailid, date}, null, null, "_id DESC ");
        return c;
    }

    public void insert_dynamicquestionstable(String Companyname, String customername, String questionnumber, String category, String subcategory, String question, String typeofquestion, String count, String optionforanswers, String dateandtime, String correctanswer, String questionmode, String customertype, String combinationname) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("customername", customername);
            cv.put("questionnumber", questionnumber);
            cv.put("category", category);
            cv.put("subcategory", subcategory);
            cv.put("question", question);
            cv.put("typeofquestion", typeofquestion);
            cv.put("count", count);
            cv.put("optionforanswers", optionforanswers);
            cv.put("dateandtime", dateandtime);
            cv.put("correctanswer", correctanswer);
            cv.put("questionmode", questionmode);
            cv.put("customertype", customertype);
            cv.put("combinationname", combinationname);
            sdb.insert("dynamicquestionstable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_dynamicquestionstable_local(String Companyname, String customername, String facility, String questionmode, String customertype, String combinationname, String combinationtype, String category, String subcategory, String questionnumber, String question, String typeofquestion, String count, String optionforanswers, String correctanswer, String dateandtime, String date) {
        Log.e((String)"Insert local", (String)"called");
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("customername", customername);
            cv.put("facility", facility);
            cv.put("questionmode", questionmode);
            cv.put("customertype", customertype);
            cv.put("combinationname", combinationname);
            cv.put("combinationtype", combinationtype);
            cv.put("category", category);
            cv.put("subcategory", subcategory);
            cv.put("questionnumber", questionnumber);
            cv.put("question", question);
            cv.put("typeofquestion", typeofquestion);
            cv.put("count", count);
            cv.put("optionforanswers", optionforanswers);
            cv.put("correctanswer", correctanswer);
            cv.put("dateandtime", dateandtime);
            cv.put("downloaddate", date);
            sdb.insert("dynamicquestionstablelocal", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_dynamicquestions_combination(String combinationname, String combinationtype, String customertype, String questionmode, String Customername, String facility) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstablelocal", null, "combinationname = ? AND combinationtype = ? AND customertype = ? AND questionmode = ? AND customername = ? AND facility = ? ", new String[]{combinationname, combinationtype, customertype, questionmode, Customername, facility}, null, null, "CAST(questionnumber AS UNSIGNED) ASC ");
        if (c != null && c.getCount() > 0) {
            return c;
        }
        return null;
    }

    public Cursor get_dynamicquestions_combination_date(String combinationname, String combinationtype, String customertype, String questionmode, String Customername, String facility, String date) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstablelocal", null, "combinationname = ? AND combinationtype = ? AND customertype = ? AND questionmode = ? AND customername = ? AND facility = ? AND downloaddate = ? ", new String[]{combinationname, combinationtype, customertype, questionmode, Customername, facility, date}, null, null, "CAST(questionnumber AS UNSIGNED) ASC ");
        if (c != null && c.getCount() > 0) {
            return c;
        }
        return null;
    }

    public Cursor get_dynamicquestionstable(String Companyname) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstable", null, "companyname = ? ", new String[]{Companyname}, null, null, "_id ASC ");
        return c;
    }

    public Cursor get_dynamicquestions_category(String Companyname) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstable", null, "companyname = ? ", new String[]{Companyname}, "category", null, "CAST(questionnumber AS UNSIGNED) ASC ");
        return c;
    }

    public Cursor get_answers_category(String Companyname, String combinationname, String questionmode, String customertype, String customername, String facility) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("answerstablelocal", null, "companyname = ? AND combinationname = ? AND questionmode = ? AND customertype = ? AND customername = ? AND atmid = ? ", new String[]{Companyname, combinationname, questionmode, customertype, customername, facility}, "category", null, "CAST(questionnumber AS UNSIGNED) ASC ");
        return c;
    }

    public Cursor get_dynamicquestions_subcategoryfull(String Companyname, String category) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstable", null, "companyname = ? AND category = ? ", new String[]{Companyname, category}, null, null, "CAST(questionnumber AS UNSIGNED) ASC ");
        return c;
    }

    public Cursor get_dynamicquestions_subcategory(String Companyname, String category) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstable", null, "companyname = ? AND category = ? ", new String[]{Companyname, category}, "subcategory", null, "typeofquestion ASC ");
        return c;
    }

    public Cursor get_dynamicquestions_category_subcategory(String Companyname, String category, String subcategory) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstable", null, "companyname = ? AND category = ? AND subcategory = ? ", new String[]{Companyname, category, subcategory}, null, null, "CAST(questionnumber  AS UNSIGNED) ASC");
        return c;
    }

    public Cursor get_dynamicquestions_all(String Companyname, String status) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstable", null, "companyname = ? AND categorystatus != ? ", new String[]{Companyname, status}, null, null, "CAST(questionnumber  AS UNSIGNED) ASC");
        return c;
    }

    public Cursor get_dynamicquestions_local_all(String Companyname) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstablelocal", null, "companyname = ? ", new String[]{Companyname}, null, null, "CAST(questionnumber  AS UNSIGNED) ASC");
        return c;
    }

    public Cursor get_dynamicquestions_type(String Companyname, String category, String subcategory, String question) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstable", null, "companyname = ? AND category = ? AND subcategory = ? AND question = ? ", new String[]{Companyname, category, subcategory, question}, null, null, null);
        return c;
    }

    public Cursor get_dynamicquestions_correctanswer(String Companyname, String customername, String questionnumber, String category, String subcategory, String question) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("dynamicquestionstable", null, "companyname = ? AND customername = ? AND questionnumber = ? AND category = ? AND subcategory = ? AND question = ? AND typeofquestion", new String[]{Companyname, customername, questionnumber, category, subcategory, question, "boolean"}, null, null, null);
        return c;
    }

    public Cursor get_spareparts(String ticketnumber) throws SQLException {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM sparestable WHERE \nticketnumber = ? ", new String[]{ticketnumber}, null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public Cursor get_dynamicquestions_local() throws SQLException {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor mCursor = sdb.rawQuery("SELECT * FROM dynamicquestionstablelocal", null, null);
        if (mCursor != null && mCursor.getCount() > 0) {
            return mCursor;
        }
        return null;
    }

    public int getspareamount(String ticketnumber) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor cursor = sdb.rawQuery("SELECT sum(totalamount) as total FROM sparestable WHERE ticketnumber = ? ", new String[]{ticketnumber}, null);
        if (cursor.getCount() < 1) {
            cursor.close();
            return 0;
        }
        cursor.moveToFirst();
        int total = cursor.getInt(cursor.getColumnIndex("total"));
        cursor.close();
        return total;
    }

    public void delete_dynamicquestionstable() {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("dynamicquestionstable", null, null);
    }

    public void delete_dynamicquestions_local_all() {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("dynamicquestionstablelocal", null, null);
    }

    public void delete_answers_local_all() {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("answerstablelocal", null, null);
    }

    public int deletespares(String sku, String name) throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        String where = "sku=? AND itemname=?";
        int numberOFEntriesDeleted = sdb.delete("sparestable", where, new String[]{sku, name});
        return numberOFEntriesDeleted;
    }

    public int deletesparesnew(String id2, String sku, String name) throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        String where = "sku=? AND itemname=? AND _id=?";
        int numberOFEntriesDeleted = sdb.delete("sparestable", where, new String[]{sku, name, id2});
        return numberOFEntriesDeleted;
    }

    public int delete_attendancetable(String start, String end) throws SQLException {
        SQLiteDatabase sdb = this.getWritableDatabase();
        String where = "date<?";
        int numberOFEntriesDeleted = sdb.delete("attendancetable", where, new String[]{start});
        return numberOFEntriesDeleted;
    }

    public void insert_answerstable(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("customername", customername);
            cv.put("atmid", atmid);
            cv.put("emailid", emailid);
            cv.put("category", category);
            cv.put("subcategory", subcategory);
            cv.put("questionnumber", questionnumber);
            cv.put("question", question);
            cv.put("typeofquestion", typeofquestion);
            cv.put("answer", answer);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            cv.put("image", globalvariables.getBytes(image));
            sdb.insert("answerstable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_answerstablelocal(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue, String customertype, String questionmode, String combinationname, String uniqueid) {
        Log.e((String)"insert answer local", (String)"coming");
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("customername", customername);
            cv.put("atmid", atmid);
            cv.put("emailid", emailid);
            cv.put("category", category);
            cv.put("subcategory", subcategory);
            cv.put("questionnumber", questionnumber);
            cv.put("question", question);
            cv.put("typeofquestion", typeofquestion);
            cv.put("answer", answer);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            cv.put("customertype", customertype);
            cv.put("questionmode", questionmode);
            cv.put("combinationname", combinationname);
            cv.put("uniqueid", uniqueid);
            cv.put("sync", "No");
            sdb.insert("answerstablelocal", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_answerstablelocal_image(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue, String customertype, String questionmode, String combinationname, String uniqueid) {
        Log.e((String)"insert answer local", (String)"coming");
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("customername", customername);
            cv.put("atmid", atmid);
            cv.put("emailid", emailid);
            cv.put("category", category);
            cv.put("subcategory", subcategory);
            cv.put("questionnumber", questionnumber);
            cv.put("question", question);
            cv.put("typeofquestion", typeofquestion);
            cv.put("answer", answer);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            cv.put("image", globalvariables.getBytes(image));
            cv.put("customertype", customertype);
            cv.put("questionmode", questionmode);
            cv.put("combinationname", combinationname);
            cv.put("uniqueid", uniqueid);
            cv.put("sync", "No");
            sdb.insert("answerstablelocal", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_answerstable_edit(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, String image, String imagepath, String dateandtime, String issue) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("customername", customername);
            cv.put("atmid", atmid);
            cv.put("emailid", emailid);
            cv.put("category", category);
            cv.put("subcategory", subcategory);
            cv.put("questionnumber", questionnumber);
            cv.put("question", question);
            cv.put("typeofquestion", typeofquestion);
            cv.put("answer", answer);
            cv.put("image", image);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.insert("answerstable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_answerstable_date(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, String image, String imagepath, String dateandtime, String issue) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("customername", customername);
            cv.put("atmid", atmid);
            cv.put("emailid", emailid);
            cv.put("category", category);
            cv.put("subcategory", subcategory);
            cv.put("questionnumber", questionnumber);
            cv.put("question", question);
            cv.put("typeofquestion", typeofquestion);
            cv.put("answer", answer);
            cv.put("image", image);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.insert("answerstable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_answerstable_radio(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, String image, String imagepath, String dateandtime, String issue) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("customername", customername);
            cv.put("atmid", atmid);
            cv.put("emailid", emailid);
            cv.put("category", category);
            cv.put("subcategory", subcategory);
            cv.put("questionnumber", questionnumber);
            cv.put("question", question);
            cv.put("typeofquestion", typeofquestion);
            cv.put("answer", answer);
            cv.put("image", image);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.insert("answerstable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_answerstable(String Companyname, String emailid, String category, String subcategory, String question) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("answerstable", null, "companyname = ? AND emailid = ? AND category = ? AND subcategory = ? AND question = ? ", new String[]{Companyname, emailid, category, subcategory, question}, null, null, null);
        return c;
    }

    public Cursor get_answerstable_summary(String Companyname, String emailid, String category) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("answerstable", null, "companyname = ? AND emailid = ? AND category = ? ", new String[]{Companyname, emailid, category}, null, null, "CAST(questionnumber  AS UNSIGNED) ASC");
        return c;
    }

    public Cursor get_answerstablelocal_summary(String Companyname, String emailid, String sync2) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("answerstablelocal", null, "companyname = ? AND emailid = ? AND sync = ? ", new String[]{Companyname, emailid, sync2}, null, null, "CAST(questionnumber  AS UNSIGNED) ASC");
        return c;
    }

    public Cursor get_answerstablelocal_synced(String Companyname, String emailid, String sync2) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("answerstablelocal", null, "companyname = ? AND emailid = ? AND sync = ? ", new String[]{Companyname, emailid, sync2}, null, null, "CAST(questionnumber  AS UNSIGNED) ASC");
        return c;
    }

    public void update_answerstable(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue) {
        Log.e((String)"question number", (String)questionnumber);
        Log.e((String)"question", (String)question);
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("answer", answer);
            cv.put("image", globalvariables.getBytes(image));
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.update("answerstable", cv, "companyname = ? AND emailid = ? AND category = ? AND subcategory = ? AND questionnumber = ? AND question = ? AND typeofquestion = ? ", new String[]{Companyname, emailid, category, subcategory, questionnumber, question, typeofquestion});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_answerstable_summaryimage(String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue) {
        Log.e((String)"question number", (String)questionnumber);
        Log.e((String)"question", (String)question);
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("answer", answer);
            cv.put("image", globalvariables.getBytes(image));
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.update("answerstable", cv, "category = ? AND subcategory = ? AND questionnumber = ? AND question = ? AND typeofquestion = ? ", new String[]{category, subcategory, questionnumber, question, typeofquestion});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_answerstable_submit(String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, Bitmap image, String imagepath, String dateandtime, String issue) {
        Log.e((String)"question number", (String)questionnumber);
        Log.e((String)"question", (String)question);
        Log.e((String)"answer", (String)answer);
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("answer", answer);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.update("answerstable", cv, "category = ? AND subcategory = ? AND questionnumber = ? AND question = ? AND typeofquestion = ? ", new String[]{category, subcategory, questionnumber, question, typeofquestion});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_spareparts(String id2, String quantity, String total) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("quantity", quantity);
            cv.put("totalamount", total);
            sdb.update("sparestable", cv, "_id = ? ", new String[]{id2});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_answerstable_edit(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, String image, String imagepath, String dateandtime, String issue) {
        Log.e((String)"question number", (String)questionnumber);
        Log.e((String)"question", (String)question);
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("answer", answer);
            cv.put("image", image);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.update("answerstable", cv, "companyname = ? AND customername = ? AND atmid = ? AND emailid = ? AND category = ? AND subcategory = ? AND questionnumber = ? AND question = ? AND typeofquestion = ? ", new String[]{Companyname, customername, atmid, emailid, category, subcategory, questionnumber, question, typeofquestion});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_answerstable_date(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, String image, String imagepath, String dateandtime, String issue) {
        Log.e((String)"question number", (String)questionnumber);
        Log.e((String)"question", (String)question);
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("answer", answer);
            cv.put("image", image);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.update("answerstable", cv, "companyname = ? AND customername = ? AND atmid = ? AND emailid = ? AND category = ? AND subcategory = ? AND questionnumber = ? AND question = ? AND typeofquestion = ? ", new String[]{Companyname, customername, atmid, emailid, category, subcategory, questionnumber, question, typeofquestion});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_answerstable_radio(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion, String answer, String image, String imagepath, String dateandtime, String issue) {
        Log.e((String)"question number", (String)questionnumber);
        Log.e((String)"question", (String)question);
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("answer", answer);
            cv.put("image", image);
            cv.put("imagepath", imagepath);
            cv.put("dateandtime", dateandtime);
            cv.put("issue", issue);
            sdb.update("answerstable", cv, "companyname = ? AND customername = ? AND atmid = ? AND emailid = ? AND category = ? AND subcategory = ? AND questionnumber = ? AND question = ? AND typeofquestion = ? ", new String[]{Companyname, customername, atmid, emailid, category, subcategory, questionnumber, question, typeofquestion});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_answerstable_local(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("sync", "Yes");
        sdb.update("answerstablelocal", cv, "companyname = ? AND customername = ? AND atmid = ? AND emailid = ? AND category = ? AND subcategory = ? AND questionnumber = ? AND question = ? ", new String[]{Companyname, customername, atmid, emailid, category, subcategory, questionnumber, question});
    }

    public void delete_answerstable(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("answerstable", "companyname = ? AND customername = ? AND atmid = ? AND emailid = ? AND category = ? AND subcategory = ? AND questionnumber = ? AND question = ? ", new String[]{Companyname, customername, atmid, emailid, category, subcategory, questionnumber, question});
    }

    public void delete_answerstable_edit(String Companyname, String customername, String atmid, String emailid, String category, String subcategory, String questionnumber, String question, String typeofquestion) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("answerstable", "companyname = ? AND customername = ? AND atmid = ? AND emailid = ? AND category = ? AND subcategory = ? AND questionnumber = ? AND question = ? AND typeofquestion = ? ", new String[]{Companyname, customername, atmid, emailid, category, subcategory, questionnumber, question, typeofquestion});
    }

    public void delete_answerstablefull() {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("answerstable", null, null);
    }

    public void delete_sparestablefull() {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("sparestable", null, null);
    }

    public void insert_ticketstable(String Companyname, String assignedto, String rejectedby, String ticketstatus, String ticketstage, String ticketnumber, String customername, String atmid, String source, String priority, String createddateandtime, String assigneddateandtime, String questionorcallreason, String acceptedby, String accepteddateandtime, String rejecteddateandtime, String reasonforrejection, String Brand, String product, String model, String serialnumber, String questionmode, String questiontype, String combinationname, String combinationtype) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("Assignedto", assignedto);
            cv.put("rejectedby", rejectedby);
            cv.put("ticketstatus", ticketstatus);
            cv.put("ticketstage", ticketstage);
            cv.put("ticketnumber", ticketnumber);
            cv.put("customername", customername);
            cv.put("atmid", atmid);
            cv.put("source", source);
            cv.put("priority", priority);
            cv.put("createddateandtime", createddateandtime);
            cv.put("assigneddateandtime", assigneddateandtime);
            cv.put("questionorcallreason", questionorcallreason);
            cv.put("acceptedby", acceptedby);
            cv.put("accepteddateandtime", accepteddateandtime);
            cv.put("rejecteddateandtime", rejecteddateandtime);
            cv.put("reasonforrejection", reasonforrejection);
            cv.put("brand", Brand);
            cv.put("product", product);
            cv.put("model", model);
            cv.put("serialnumber", serialnumber);
            cv.put("questionmode", questionmode);
            cv.put("questiontype", questiontype);
            cv.put("combinationname", combinationname);
            cv.put("combinationtype", combinationtype);
            sdb.insert("ticketstable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_tickets_open(String Companyname, String assignedto, String rejectedby) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("ticketstable", null, "companyname = ? AND Assignedto = ? AND rejectedby != ? AND ticketstage = ? AND ( ticketstatus = ? OR ticketstatus = ? OR ticketstatus = ? OR ticketstatus = ? )", new String[]{Companyname, assignedto, rejectedby, "open", "assigned", "underprogress", "Complete", "Incomplete"}, null, null, "assigneddateandtime DESC");
        return c;
    }

    public Cursor get_tickets_close(String Companyname, String assignedto) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("ticketstable", null, "companyname = ? AND Assignedto = ? AND ticketstage = ? AND ( ticketstatus = ? OR ticketstatus = ? OR ticketstatus = ? OR ticketstatus = ? )", new String[]{Companyname, assignedto, "close", "assigned", "underprogress", "Complete", "Incomplete"}, null, null, "assigneddateandtime DESC");
        return c;
    }

    public void delete_ticketstable() {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("ticketstable", null, null);
    }

    public void update_accept(String Companyname, String ticketnumber, String acceptedby, String accepteddateandtime) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("acceptedby", acceptedby);
            cv.put("accepteddateandtime", accepteddateandtime);
            cv.put("ticketstatus", "underprogress");
            sdb.update("ticketstable", cv, "companyname = ?  AND ticketnumber = ? ", new String[]{Companyname, ticketnumber});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_reject(String Companyname, String ticketnumber, String rejectedby, String rejecteddateandtime) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("rejectedby", rejectedby);
            cv.put("rejecteddateandtime", rejecteddateandtime);
            cv.put("ticketstatus", "unresolved");
            sdb.update("ticketstable", cv, "companyname = ?  AND ticketnumber = ? ", new String[]{Companyname, ticketnumber});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_ticketreport(String Companyname, String ticketnumber, String ticketstatus, String brand, String product, String model, String serialnumber) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("ticketstatus", ticketstatus);
            cv.put("brand", brand);
            cv.put("product", product);
            cv.put("model", model);
            cv.put("serialnumber", serialnumber);
            sdb.update("ticketstable", cv, "companyname = ?  AND ticketnumber = ? ", new String[]{Companyname, ticketnumber});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_leavetable(String Companyname, String employeemailid, String leavetype, String leavefrom, String leaveto, String leavedays, String permissiondate, String permissionfrom, String permissionto, String permissioninminutes, String appliedateandtime, String reasonforleave, String sync2) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("employeemailid", employeemailid);
            cv.put("leavetype", leavetype);
            cv.put("leavefrom", leavefrom);
            cv.put("leaveto", leaveto);
            cv.put("leavedays", leavedays);
            cv.put("permissiondate", permissiondate);
            cv.put("permissionfrom", permissionfrom);
            cv.put("permissionto", permissionto);
            cv.put("permissioninminutes", permissioninminutes);
            cv.put("appliedateandtime", appliedateandtime);
            cv.put("reasonforleaveorpermission", reasonforleave);
            cv.put("status", "pending");
            cv.put("acceptedorrejecteddateandtime", "0000-00-00 00:00:00");
            cv.put("rejectedreason", "no data available");
            cv.put("priority", "no data available");
            cv.put("SYNC", sync2);
            cv.put("syncwithserver", "No");
            sdb.insert("leavetable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_leavetable_duplicacycheck(String Companyname, String employeemailid, String leavetype, String applieddateandtime) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? AND leavetype = ? AND appliedateandtime = ? ", new String[]{Companyname, employeemailid, leavetype, applieddateandtime}, null, null, "_id DESC");
        return c;
    }

    public Cursor get_leavetable(String Companyname, String employeemailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? ", new String[]{Companyname, employeemailid}, null, null, "_id DESC");
        return c;
    }

    public Cursor get_leavetable_filter(String Companyname, String employeemailid, String leavetype, String status) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = null;
        c = leavetype.equalsIgnoreCase("All") && status.equalsIgnoreCase("All") ? sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? ", new String[]{Companyname, employeemailid}, null, null, "_id DESC") : (leavetype.equalsIgnoreCase("All") && !status.equalsIgnoreCase("All") ? sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? AND status = ? ", new String[]{Companyname, employeemailid, status}, null, null, "_id DESC") : (!leavetype.equalsIgnoreCase("All") && status.equalsIgnoreCase("All") ? sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? AND leavetype = ? ", new String[]{Companyname, employeemailid, leavetype}, null, null, "_id DESC") : sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? AND leavetype = ? AND status = ? ", new String[]{Companyname, employeemailid, leavetype, status}, null, null, "_id DESC")));
        return c;
    }

    public Cursor get_leavetable_notsynced(String Companyname, String employeemailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? AND SYNC = ? ", new String[]{Companyname, employeemailid, "No"}, null, null, "_id ASC ");
        return c;
    }

    public void update_leavetable_tosync(String Companyname, String employeemailid, String leavetype, String apllieddateandtime, String sync2) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("SYNC", sync2);
            sdb.update("leavetable", cv, "companyname = ?  AND employeemailid = ? AND leavetype = ? AND appliedateandtime = ? ", new String[]{Companyname, employeemailid, leavetype, apllieddateandtime});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update_leavetablestatus(String Companyname, String employeemailid, String leavetype, String appliedateandtime, String status, String acceptedorrejecteddateandtime, String rejectedreason, String syncwithserver) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("status", status);
        cv.put("acceptedorrejecteddateandtime", acceptedorrejecteddateandtime);
        cv.put("rejectedreason", rejectedreason);
        cv.put("syncwithserver", syncwithserver);
        sdb.update("leavetable", cv, "companyname = ?  AND employeemailid = ? AND leavetype = ? AND appliedateandtime = ? ", new String[]{Companyname, employeemailid, leavetype, appliedateandtime});
    }

    public Cursor get_leavetablefull(String Companyname, String employeemailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? ", new String[]{Companyname, employeemailid}, null, null, "_id ASC ");
        return c;
    }

    public Cursor get_leavetable_tosyncwithserver(String Companyname, String employeemailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("leavetable", null, "companyname = ? AND employeemailid = ? AND syncwithserver = ? ", new String[]{Companyname, employeemailid, "Yes"}, null, null, "_id ASC ");
        return c;
    }

    public void update_leavetable_tosyncwithserver(String Companyname, String employeemailid, String leavetype, String apllieddateandtime, String syncwithserver) {
        try {
            SQLiteDatabase sdb = this.getReadableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("syncwithserver", syncwithserver);
            sdb.update("leavetable", cv, "companyname = ?  AND employeemailid = ? AND leavetype = ? AND appliedateandtime = ? ", new String[]{Companyname, employeemailid, leavetype, apllieddateandtime});
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insert_leavetablefull(String Companyname, String employeemailid, String leavetype, String leavefrom, String leaveto, String leavedays, String permissiondate, String permissionfrom, String permissionto, String permissioninminutes, String appliedateandtime, String reasonforleave, String status, String acceptedorrejecteddateandtime, String rejectedreason, String priority) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("employeemailid", employeemailid);
            cv.put("leavetype", leavetype);
            cv.put("leavefrom", leavefrom);
            cv.put("leaveto", leaveto);
            cv.put("leavedays", leavedays);
            cv.put("permissiondate", permissiondate);
            cv.put("permissionfrom", permissionfrom);
            cv.put("permissionto", permissionto);
            cv.put("permissioninminutes", permissioninminutes);
            cv.put("appliedateandtime", appliedateandtime);
            cv.put("reasonforleaveorpermission", reasonforleave);
            cv.put("status", status);
            cv.put("acceptedorrejecteddateandtime", acceptedorrejecteddateandtime);
            cv.put("rejectedreason", rejectedreason);
            cv.put("priority", priority);
            cv.put("SYNC", "Yes");
            cv.put("syncwithserver", "No");
            sdb.insert("leavetable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_leavetable_validationfordatesrange1(String Companyname, String employeemailid, String currentstartdate, String currentenddate) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from leavetable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "leavetype" + " !=  'Permission' AND " + "status" + " !=  'rejected' AND  ( ( '" + currentstartdate + "' BETWEEN " + "leavefrom" + " AND " + "leaveto" + " ) OR  ( '" + currentenddate + "' BETWEEN " + "leavefrom" + " AND " + "leaveto" + " ) ) ", null);
        return c;
    }

    public Cursor get_leavetable_validationfordatesrange2(String Companyname, String employeemailid, String currentstartdate, String currentenddate) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from leavetable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "leavetype" + " !=  'Permission' AND " + "status" + " !=  'rejected' AND " + "leaveto" + " != '0000-00-00'  AND  ( '" + currentstartdate + "' <= " + "leavefrom" + " AND '" + currentenddate + "' >= " + "leaveto" + " )   ", null);
        return c;
    }

    public Cursor get_leavetable_validationfordatesrange3(String Companyname, String employeemailid, String currentstartdate, String currentenddate) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from leavetable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "leavetype" + " !=  'Permission' AND " + "status" + " !=  'rejected' AND " + "leaveto" + " = '0000-00-00'  AND  ( '" + currentstartdate + "' <= " + "leavefrom" + " AND '" + currentenddate + "' >= " + "leavefrom" + " )   ", null);
        return c;
    }

    public Cursor get_leavetable_validationforoneday1(String Companyname, String employeemailid, String currentdate) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from leavetable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "leavetype" + " !=  'Permission' AND " + "status" + " !=  'rejected' AND " + "leavefrom" + " = '" + currentdate + "' ", null);
        return c;
    }

    public Cursor get_leavetable_validationforoneday2(String Companyname, String employeemailid, String currentdate) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from leavetable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "leavetype" + " !=  'Permission' AND " + "status" + " !=  'rejected' AND  ( '" + currentdate + "' BETWEEN " + "leavefrom" + " AND " + "leaveto" + " ) ", null);
        return c;
    }

    public Cursor get_leavetable_validationforpermission1(String Companyname, String employeemailid, String todaydate, String currentstarttime, String currentendtime) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from leavetable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "leavetype" + " =  'Permission' AND " + "status" + " !=  'rejected' AND " + "permissiondate" + " =  '" + todaydate + "' AND ( ( '" + currentstarttime + "' BETWEEN " + "permissionfrom" + " AND " + "permissionto" + " ) OR  ( '" + currentendtime + "' BETWEEN " + "permissionfrom" + " AND " + "permissionto" + " ) ) ", null);
        return c;
    }

    public Cursor get_leavetable_validationforpermission2(String Companyname, String employeemailid, String todaydate, String currentstarttime, String currentendtime) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from leavetable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "leavetype" + " =  'Permission' AND " + "status" + " !=  'rejected' AND " + "permissiondate" + " =  '" + todaydate + "' AND ( '" + currentstarttime + "' < " + "permissionfrom" + " AND '" + currentendtime + "' > " + "permissionto" + " )   ", null);
        return c;
    }

    public Cursor get_leavetable_validationforpermission3(String Companyname, String employeemailid, String todaydate) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from leavetable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "status" + " !=  'rejected' AND " + "leavetype" + " !=  'Permission'  AND  ( '" + todaydate + "' >= " + "leavefrom" + " AND '" + todaydate + "' <= " + "leaveto" + " ) ", null);
        return c;
    }

    public void delete_leavetable(String Companyname, String employeemailid, String leavetype, String applieddatenadtime) {
        SQLiteDatabase sdb = this.getWritableDatabase();
        sdb.delete("leavetable", "companyname = ? AND employeemailid = ? AND leavetype = ? AND appliedateandtime = ? ", new String[]{Companyname, employeemailid, leavetype, applieddatenadtime});
    }

    public void insert_timesheet(String Companyname, String employeemailid, String attendancegroup, String attendancesubgroup, String attendaceteam, String activity, String latitude, String longitude, String location, String timesheetdate, String starttime, String endtime, String dateandtime, String sync2) {
        try {
            SQLiteDatabase sdb = this.getWritableDatabase();
            ContentValues cv = new ContentValues();
            cv.put("companyname", Companyname);
            cv.put("employeemailid", employeemailid);
            cv.put("attendancegroup", attendancegroup);
            cv.put("attendancesubgroup", attendancesubgroup);
            cv.put("attendanceteam", attendaceteam);
            cv.put("activity", activity);
            cv.put("latitude", latitude);
            cv.put("longitude", longitude);
            cv.put("location", location);
            cv.put("timesheetdate", timesheetdate);
            cv.put("starttime", starttime);
            cv.put("endtime", endtime);
            cv.put("dateandtime", dateandtime);
            cv.put("sync", sync2);
            sdb.insert("timesheettable", null, cv);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Cursor get_timesheetduplicacycheck(String Companyname, String employeemailid, String dateandtime) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("timesheettable", null, "companyname = ? AND employeemailid = ? AND dateandtime = ? ", new String[]{Companyname, employeemailid, dateandtime}, null, null, "_id DESC ");
        return c;
    }

    public Cursor get_timesheet(String Companyname, String employeemailid) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("timesheettable", null, "companyname = ? AND employeemailid = ? ", new String[]{Companyname, employeemailid}, null, null, "_id DESC ");
        return c;
    }

    public Cursor get_timesheettable_notsynced(String Companyname) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("timesheettable", null, "companyname = ? AND sync = ? ", new String[]{Companyname, "no"}, null, null, "_id ASC ");
        return c;
    }

    public Cursor get_timesheet_validationfortime1(String Companyname, String employeemailid, String todaydate, String currentstarttime, String currentendtime) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from timesheettable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "timesheetdate" + " =  '" + todaydate + "' AND ( ( '" + currentstarttime + "' BETWEEN " + "starttime" + " AND " + "endtime" + " ) OR  ( '" + currentendtime + "' BETWEEN " + "starttime" + " AND " + "endtime" + " ) ) ", null);
        return c;
    }

    public Cursor get_timesheet_validationfortime2(String Companyname, String employeemailid, String todaydate, String currentstarttime, String currentendtime) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.rawQuery("select * from timesheettable where companyname = '" + Companyname + "' AND " + "employeemailid" + " = '" + employeemailid + "' AND " + "timesheetdate" + " =  '" + todaydate + "' AND ( '" + currentstarttime + "' < " + "starttime" + " AND '" + currentendtime + "' > " + "endtime" + " )   ", null);
        return c;
    }

    public Cursor get_timesheet_selecteddate(String Companyname, String employeemailid, String fromdate) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("timesheettable", null, "companyname = ? AND employeemailid = ? AND timesheetdate = ? ", new String[]{Companyname, employeemailid, fromdate}, null, null, "_id DESC ");
        return c;
    }

    public Cursor get_timesheet_selecteddaterange(String Companyname, String employeemailid, String fromdate, String todate) {
        SQLiteDatabase sdb = this.getReadableDatabase();
        Cursor c = sdb.query("timesheettable", null, "companyname = ? AND employeemailid = ? AND timesheetdate >= ? AND timesheetdate <= ? ", new String[]{Companyname, employeemailid, fromdate, todate}, null, null, "_id DESC ");
        return c;
    }
}

