/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.others.utils;

import android.content.Context;
import android.graphics.Bitmap;
import androidx.collection.LruCache;
import com.android.volley.Cache;
import com.android.volley.Network;
import com.android.volley.RequestQueue;
import com.android.volley.toolbox.BaseHttpStack;
import com.android.volley.toolbox.BasicNetwork;
import com.android.volley.toolbox.DiskBasedCache;
import com.android.volley.toolbox.HurlStack;
import com.android.volley.toolbox.ImageLoader;

public class CustomVolleyRequest {
    private static CustomVolleyRequest customVolleyRequest;
    private static Context context;
    private RequestQueue requestQueue;
    private ImageLoader imageLoader;

    private CustomVolleyRequest(Context context) {
        CustomVolleyRequest.context = context;
        this.requestQueue = this.getRequestQueue();
        this.imageLoader = new ImageLoader(this.requestQueue, new ImageLoader.ImageCache(){
            private final LruCache<String, Bitmap> cache = new LruCache(20);

            public Bitmap getBitmap(String url) {
                return (Bitmap)this.cache.get((Object)url);
            }

            public void putBitmap(String url, Bitmap bitmap) {
                this.cache.put((Object)url, (Object)bitmap);
            }
        });
    }

    public static synchronized CustomVolleyRequest getInstance(Context context) {
        if (customVolleyRequest == null) {
            customVolleyRequest = new CustomVolleyRequest(context);
        }
        return customVolleyRequest;
    }

    public RequestQueue getRequestQueue() {
        if (this.requestQueue == null) {
            DiskBasedCache cache = new DiskBasedCache(context.getCacheDir(), 0xA00000);
            BasicNetwork network = new BasicNetwork((BaseHttpStack)new HurlStack());
            this.requestQueue = new RequestQueue((Cache)cache, (Network)network);
            this.requestQueue.start();
        }
        return this.requestQueue;
    }

    public ImageLoader getImageLoader() {
        return this.imageLoader;
    }
}

