/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.others.utils;

import androidx.annotation.NonNull;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

public class DateUtils {
    public static String getCurrentDateTime() {
        Calendar c1 = Calendar.getInstance();
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault());
        return df1.format(c1.getTime());
    }

    private static String getByFormat(String format, Date date) {
        return new SimpleDateFormat(format, Locale.getDefault()).format(date);
    }

    public static String formatDate(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).format(date);
    }

    public static String getCurrentDate() {
        return DateUtils.getByFormat("yyyy-MM-dd", Calendar.getInstance().getTime());
    }

    public static String getCurrentTime() {
        return DateUtils.getByFormat("HH:mm:ss", Calendar.getInstance().getTime());
    }

    public static String getNormalDatetime(String datetime) throws ParseException {
        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).parse(datetime);
        return DateUtils.getByFormat("dd-MM-yyyy hh:mm a", date);
    }

    public static String getNormalDate(String datetime) throws ParseException {
        Date date = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).parse(datetime);
        return DateUtils.getByFormat("dd-MM-yyyy", date);
    }

    public static Date fromDateTime(String string2) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()).parse(string2);
    }

    public static Date fromDate(String string2) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault()).parse(string2);
    }

    public static Date currentDate() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static int daysbetween(Date firstdate) {
        long diif = firstdate.getTime() - DateUtils.currentDate().getTime();
        return (int)(diif / 86400000L);
    }

    public static String monthNameFromDate(String date) throws ParseException {
        Date firstdate = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).parse(date);
        return new SimpleDateFormat("MMM", Locale.ENGLISH).format(firstdate);
    }

    public static String monthNameFromDateTime(String datetime) throws ParseException {
        Date firstdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH).parse(datetime);
        return new SimpleDateFormat("MMM", Locale.ENGLISH).format(firstdate);
    }

    public static String monthYearFromDate(String datetime) throws ParseException {
        Date firstdate = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH).parse(datetime);
        return new SimpleDateFormat("MMM yyyy", Locale.ENGLISH).format(firstdate);
    }

    public static String dateNumberFromDate(String date) {
        return date.substring(8, 10);
    }

    public static int compareToday(String date) throws ParseException {
        Date firstdate = new SimpleDateFormat("yyyy-MM-dd").parse(date);
        long diif = firstdate.getTime() - DateUtils.currentDate().getTime();
        return (int)(diif / 86400000L);
    }

    public static int compareTodayWithTime(String date) throws ParseException {
        Date firstdate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(date);
        SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
        return DateUtils.compareToday(df1.format(firstdate));
    }

    public static int daysbetween(Date firstdate, Date seconddate) {
        long diif = firstdate.getTime() - seconddate.getTime();
        return (int)(diif / 86400000L);
    }

    public static String getDueDateString(String date) throws ParseException {
        int x = DateUtils.compareToday(date);
        if (x == 0) {
            return "Due Today";
        }
        if (x == 1) {
            return "Due Tomorrow";
        }
        if (x < 0) {
            if ((x *= -1) == 1) {
                return "Due Yesterday";
            }
            return x + " Days late";
        }
        return "Due in " + x + " Days";
    }

    public static String getLateDateString(String date) throws ParseException {
        int x = DateUtils.compareToday(date) * -1;
        if (x == 0) {
            return "Due Today";
        }
        if (x == 1) {
            return "1 Day late";
        }
        return x + " Days late";
    }

    @NonNull
    public static String getUpcomingDateString(String date) throws ParseException {
        int x = DateUtils.compareToday(date);
        if (x == 1) {
            return "Starting Tommorrow";
        }
        if (x < 0) {
            if ((x *= 1) == 1) {
                return "Due Yesterday";
            }
            return x + " Days late";
        }
        return "Starting in " + x + " Days";
    }

    public static String getCompletedDateString(String date) throws ParseException {
        int x = DateUtils.compareTodayWithTime(date) * -1;
        if (x == 0) {
            return "Completed Today";
        }
        if (x == 1) {
            return "Completed Yesterday";
        }
        return "Completed " + x + " Days ago";
    }
}

