/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.others.utils;

import android.content.ContentValues;
import android.database.Cursor;
import android.util.Base64;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JSONUtils {
    public static ContentValues jsonToValues(JSONObject json) {
        ContentValues values = new ContentValues();
        Iterator i = json.keys();
        while (i.hasNext()) {
            String name = (String)i.next();
            Object value = json.opt(name);
            if (value != null) {
                values.put(name, value.toString());
                continue;
            }
            values.putNull(name);
        }
        return values;
    }

    public static JSONObject cursorToJSONObject(Cursor cursor, JSONArray range) {
        JSONObject json = new JSONObject();
        if (cursor != null) {
            JSONArray jsonArray = new JSONArray();
            int fromIdx = 0;
            int toIdx = cursor.getCount();
            if (range != null && range.length() == 2) {
                try {
                    int rangeFrom = range.getInt(0);
                    if (rangeFrom < 0) {
                        rangeFrom = 0;
                    } else if (rangeFrom > toIdx) {
                        rangeFrom = toIdx;
                    }
                    int rangeTo = range.getInt(1);
                    if (rangeTo < rangeFrom) {
                        rangeTo = rangeFrom;
                    } else if (rangeTo > toIdx) {
                        rangeTo = toIdx;
                    }
                    fromIdx = rangeFrom;
                    toIdx = rangeTo;
                    JSONArray rangeArray = new JSONArray();
                    rangeArray.put(rangeFrom);
                    rangeArray.put(rangeTo);
                    json.put("range", (Object)rangeArray);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (fromIdx > 0) {
                cursor.moveToPosition(fromIdx - 1);
            }
            while (cursor.moveToNext() && fromIdx < toIdx) {
                JSONObject obj = new JSONObject();
                for (int i = 0; i < cursor.getColumnCount(); ++i) {
                    String name = cursor.getColumnName(i);
                    try {
                        switch (cursor.getType(i)) {
                            case 1: {
                                obj.put(name, cursor.getInt(i));
                                break;
                            }
                            case 2: {
                                obj.put(name, cursor.getDouble(i));
                                break;
                            }
                            case 3: {
                                obj.put(name, (Object)cursor.getString(i));
                                break;
                            }
                            case 0: {
                                obj.put(name, JSONObject.NULL);
                                break;
                            }
                            case 4: {
                                obj.put(name, (Object)Base64.encodeToString((byte[])cursor.getBlob(i), (int)0));
                            }
                        }
                        continue;
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
                jsonArray.put((Object)obj);
                ++fromIdx;
            }
            try {
                json.put("count", cursor.getCount());
                json.put("columns", (Object)JSONUtils.stringArrayToJSONArray(cursor.getColumnNames()));
                json.put("result", (Object)jsonArray);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            cursor.close();
        }
        return json;
    }

    public static JSONArray stringArrayToJSONArray(String[] strings) {
        if (strings == null) {
            return null;
        }
        if (strings.length == 0) {
            return new JSONArray();
        }
        return new JSONArray(Arrays.asList(strings));
    }

    public static JSONArray fromArrayList(ArrayList<JSONObject> arrayList) {
        JSONArray jsonArray = new JSONArray();
        for (JSONObject jsonObject : arrayList) {
            jsonArray.put((Object)jsonObject);
        }
        return jsonArray;
    }

    public static ArrayList<JSONObject> fromJSONArray(JSONArray jsonArray) throws JSONException {
        ArrayList<JSONObject> arrayList = new ArrayList<JSONObject>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            arrayList.add(jsonArray.getJSONObject(i));
        }
        return arrayList;
    }

    public static String[] jsonArrayToStringArray(JSONArray json) {
        if (json == null) {
            return null;
        }
        if (json.length() == 0) {
            return new String[0];
        }
        String[] strings = new String[json.length()];
        for (int i = 0; i < json.length(); ++i) {
            try {
                strings[i] = json.getString(i);
                continue;
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return strings;
    }

    public static ArrayList<String> toArrayListString(JSONArray jsonArray) throws JSONException {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < jsonArray.length(); ++i) {
            arrayList.add(jsonArray.getString(i));
        }
        return arrayList;
    }

    public static JSONObject cursorToJson(Cursor c) throws JSONException {
        JSONObject retVal = new JSONObject();
        block6: for (int i = 0; i < c.getColumnCount(); ++i) {
            String cName = c.getColumnName(i);
            switch (c.getType(i)) {
                case 1: {
                    retVal.put(cName, c.getInt(i));
                    continue block6;
                }
                case 2: {
                    retVal.put(cName, (double)c.getFloat(i));
                    continue block6;
                }
                case 3: {
                    retVal.put(cName, (Object)c.getString(i));
                    continue block6;
                }
                case 4: {
                    retVal.put(cName, (Object)Utility.getString(c.getBlob(i)));
                }
            }
        }
        return retVal;
    }

    public static JSONArray cursorToArray(Cursor c) {
        JSONArray jsonArray = new JSONArray();
        if (c != null) {
            if (c.getCount() > 0) {
                c.moveToFirst();
                do {
                    try {
                        jsonArray.put((Object)JSONUtils.cursorToJson(c));
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } while (c.moveToNext());
            }
            c.close();
        }
        return jsonArray;
    }
}

