/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.others.utils;

import android.app.Activity;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkCapabilities;
import android.net.NetworkInfo;
import android.util.Log;
import android.view.Window;
import android.widget.ProgressBar;
import android.widget.Toast;
import androidx.fragment.app.Fragment;
import com.android.volley.DefaultRetryPolicy;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.RetryPolicy;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.StringRequest;
import com.android.volley.toolbox.Volley;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import java.util.Map;

public class MyRequestQueue {
    private static Activity activity;
    private RequestQueue mRequestQueue;
    private static ProgressBar progressBar;
    private static Window window;
    private static ConnectivityManager cm;

    private MyRequestQueue(Activity activity) {
        MyRequestQueue.activity = activity;
        progressBar = (ProgressBar)activity.findViewById(2131297189);
        this.mRequestQueue = this.getRequestQueue();
        window = activity.getWindow();
        cm = (ConnectivityManager)activity.getSystemService("connectivity");
    }

    public static synchronized MyRequestQueue getInstance(Activity activity) {
        return new MyRequestQueue(activity);
    }

    public static synchronized MyRequestQueue getInstance(Fragment fragment) {
        return new MyRequestQueue((Activity)fragment.getActivity());
    }

    private RequestQueue getRequestQueue() {
        if (this.mRequestQueue == null) {
            this.mRequestQueue = Volley.newRequestQueue((Context)activity.getApplicationContext());
        }
        return this.mRequestQueue;
    }

    public void addToQueue(String URL2, final Map<String, String> params, final MyRequestFinishedListener myRequestFinishedListener) {
        this.showProgressBar();
        StringRequest postRequest2 = new StringRequest(1, URL2, (Response.Listener)new Response.Listener<String>(){

            public void onResponse(String response) {
                Log.d((String)"Response", (String)response);
                MyRequestQueue.this.hideProgressBar();
                myRequestFinishedListener.requestResult(response);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                MyRequestQueue.this.hideProgressBar();
                Log.d((String)"Error.Response", (String)error.toString());
            }
        }){

            protected Map<String, String> getParams() {
                return params;
            }
        };
        postRequest2.setRetryPolicy((RetryPolicy)new DefaultRetryPolicy(240000, 1, 1.0f));
        this.mRequestQueue.add((Request)postRequest2);
    }

    public void showProgressBar() {
        if (progressBar != null) {
            progressBar.setVisibility(0);
        }
        window.setFlags(16, 16);
    }

    public void hideProgressBar() {
        if (progressBar != null) {
            progressBar.setVisibility(8);
        }
        window.clearFlags(16);
    }

    public boolean isNoNetwork() {
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            return false;
        }
        Toast.makeText((Context)activity.getApplicationContext(), (CharSequence)"No Inernet Connection", (int)0).show();
        return true;
    }

    public boolean isNoInternet() {
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo == null || !networkInfo.isConnected();
    }

    public boolean isInternetAvailable() {
        Network network;
        ConnectivityManager cm = (ConnectivityManager)activity.getSystemService("connectivity");
        if (cm != null && (network = cm.getActiveNetwork()) != null) {
            NetworkCapabilities capabilities = cm.getNetworkCapabilities(network);
            Log.d((String)"capabilities", (String)("here" + capabilities));
            if (capabilities != null) {
                Log.d((String)"capabilities", (String)("here" + capabilities.hasTransport(1)));
                Log.d((String)"capabilities", (String)("here" + capabilities.hasTransport(0)));
                Log.d((String)"capabilities", (String)("here" + capabilities.hasTransport(3)));
                return !capabilities.hasTransport(1) && !capabilities.hasTransport(0) && !capabilities.hasTransport(3);
            }
        }
        return true;
    }
}

