/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.others.utils;

import android.content.Context;
import android.content.SharedPreferences;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import java.util.HashMap;
import java.util.Map;

public class Preference {
    private static Preference mInstance;
    private static SharedPreferences sharedPreferences;
    Context context;

    private Preference(Context context) {
        sharedPreferences = context.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.context = context;
    }

    public static synchronized Preference getInstance(Context context) {
        mInstance = new Preference(context);
        return mInstance;
    }

    public String getString(String str) {
        return sharedPreferences.getString(str, "");
    }

    public void putString(String key, String pair) {
        sharedPreferences.edit().putString(key, pair).apply();
    }

    public void putString(HashMap<String, String> hashMap) {
        SharedPreferences.Editor sh = sharedPreferences.edit();
        for (Map.Entry<String, String> e : hashMap.entrySet()) {
            sh.putString(e.getKey(), e.getValue());
        }
        sh.commit();
    }

    public void putProjectId(String id2) {
        sharedPreferences.edit().putString("projectId", id2).apply();
    }

    public String getProjectId() {
        return sharedPreferences.getString("projectId", "");
    }

    public String getCompanyName() {
        return sharedPreferences.getString(globalvariables.logout_companyname, "");
    }

    public String getLattitude() {
        return sharedPreferences.getString(globalvariables.latitude, "0.0");
    }

    public String getLongitude() {
        return sharedPreferences.getString(globalvariables.longitude, "0.0");
    }

    public String getDistance() {
        return sharedPreferences.getString(globalvariables.geo_distance, "0");
    }

    public Boolean isGeoFencingEnabled() {
        return sharedPreferences.getString(globalvariables.geo_enabled, "").equals("enable");
    }

    public String getCompanyType() {
        return sharedPreferences.getString(globalvariables.logout_companytype, "");
    }

    public String getECompanyType() {
        String str = sharedPreferences.getString("empcompanytype", "");
        if (str.equalsIgnoreCase("no data available")) {
            return this.getCompanyType();
        }
        return str;
    }

    public void setLocationUpdateRunning() {
        sharedPreferences.edit().putBoolean("locationUpdate", true).apply();
    }

    public void setLocationUpdateNotRunning() {
        sharedPreferences.edit().putBoolean("locationUpdate", false).apply();
    }

    public boolean isLocationUpdateRunning() {
        return sharedPreferences.getBoolean("locationUpdate", false);
    }

    public String getEmailId() {
        return sharedPreferences.getString(globalvariables.logout_emailid, "");
    }

    public String getpersonname() {
        return sharedPreferences.getString(globalvariables.logout_employeename, "");
    }

    public String getDesignation() {
        return sharedPreferences.getString(globalvariables.logout_designation, "");
    }

    public boolean isAdmin() {
        return sharedPreferences.getString(globalvariables.logout_designation, "").equalsIgnoreCase("admin");
    }

    public boolean isMEP() {
        return sharedPreferences.getString(globalvariables.logout_designation, "").equalsIgnoreCase("mep");
    }

    public String getCompnayType() {
        return sharedPreferences.getString(globalvariables.logout_companytype, "");
    }

    public void clear() {
        sharedPreferences.edit().clear().commit();
    }

    public void setActiveGeoFences(String facilityIdList) {
        sharedPreferences.edit().putString("active_geofence", facilityIdList).apply();
    }

    public String getActiveGeoFences() {
        return sharedPreferences.getString("active_geofence", "");
    }
}

