/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.Address;
import android.location.Geocoder;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.activities.QuestionActivity;
import com.b2lmobitech.fieldcloudplus.service.adapter.CategoryAdapter;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CategoryActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    TextView errorText;
    String id;
    String date;
    String cat;
    String assignid;
    String lat;
    String lon;
    JSONArray jsonArray;
    private static final int REQUEST = 1;
    MenuItem start;
    MenuItem done;
    String status = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492921);
        this.errorText = (TextView)this.findViewById(2131296737);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Category");
        this.id = this.getIntent().getStringExtra("id");
        this.date = this.getIntent().getStringExtra("date");
        this.cat = this.getIntent().getStringExtra("cat");
        this.assignid = this.getIntent().getStringExtra("assignid");
        this.lat = this.getIntent().getStringExtra("lat");
        this.lon = this.getIntent().getStringExtra("lon");
    }

    protected void onResume() {
        super.onResume();
        this.getCategories();
    }

    private void getCategories() {
        this.jsonArray = ServiceDatabase.getInstance((Context)this).getQuestionsCategory(this.assignid);
        CategoryAdapter categoryAdapter = new CategoryAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)categoryAdapter);
        try {
            this.status = this.jsonArray.getJSONObject(0).getString("status");
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.checkforMenuCreated();
    }

    @Override
    public void itemClicked(int position) {
        if ("assigned".equals(this.status)) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Please start the Inspection", (int)0).show();
            return;
        }
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            if (!jsonObject.getBoolean("isCompleted") && !jsonObject.getBoolean("inOffline")) {
                Intent intent = new Intent(this.getApplicationContext(), QuestionActivity.class);
                intent.putExtra("id", this.id);
                intent.putExtra("date", this.date);
                intent.putExtra("cat", jsonObject.getString("category"));
                intent.putExtra("assignid", this.assignid);
                this.startActivity(intent);
            } else {
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Already Answered", (int)0).show();
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (ServiceDatabase.getInstance((Context)this).checkAllCategoriesCompleted(this.assignid)) {
                    if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) break;
                    this.checkforUnCompleted();
                    break;
                }
                Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Complete All Categories", (int)0).show();
                break;
            }
            case 2131297406: {
                this.startInspection();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void updateCompleted() {
        final ServiceDatabase database = ServiceDatabase.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", this.assignid);
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/complete_assign.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        Toast.makeText((Context)CategoryActivity.this.getApplicationContext(), (CharSequence)"Completed Sucessfully", (int)0).show();
                        database.updateCompleted(CategoryActivity.this.assignid);
                        CategoryActivity.this.finish();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void checkforUnCompleted() {
        ServiceDatabase database = ServiceDatabase.getInstance((Context)this);
        String unsyncedCat = null;
        try {
            unsyncedCat = database.getUnSyncedCategory(this.assignid);
            Log.e((String)"unsynced cat", (String)String.valueOf(unsyncedCat));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (unsyncedCat == null) {
            this.updateCompleted();
            return;
        }
        try {
            this.insertAnswers(unsyncedCat);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void insertAnswers(final String catId) throws JSONException {
        String location_data;
        Preference preference = Preference.getInstance((Context)this);
        final ServiceDatabase database = ServiceDatabase.getInstance((Context)this);
        Geocoder geocoder = new Geocoder((Context)this, Locale.getDefault());
        List addresses = null;
        try {
            double latitude = Double.parseDouble(this.lat);
            double longitude = Double.parseDouble(this.lon);
            addresses = geocoder.getFromLocation(latitude, longitude, 1);
            location_data = addresses != null && !addresses.isEmpty() ? ((Address)addresses.get(0)).getAddressLine(0) : "Unknown location";
        }
        catch (IOException | NumberFormatException e) {
            e.printStackTrace();
            location_data = "Location not available";
        }
        List<JSONObject> answersList = database.getAnswersList(this.assignid, catId);
        if (answersList == null || answersList.isEmpty()) {
            Log.e((String)"InsertAnswers", (String)("No answers found for category " + catId));
            this.updateCompleted();
            return;
        }
        for (int i = 0; i < answersList.size(); ++i) {
            JSONObject jsonObject = answersList.get(i);
            jsonObject.put("email", (Object)preference.getEmailId());
            jsonObject.put("facility", (Object)this.id);
            jsonObject.put("cat", (Object)catId);
            jsonObject.put("lat", (Object)this.lat);
            jsonObject.put("lon", (Object)this.lon);
            jsonObject.put("location", (Object)location_data);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("JSON", jsonObject.toString());
            MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/aravind_insert_answers_check.php", params, new MyRequestFinishedListener(){

                @Override
                public void requestResult(String response) {
                    try {
                        JSONObject res = new JSONObject(response);
                        if (res.getInt("s") == 1) {
                            database.updateSynced(CategoryActivity.this.assignid, catId);
                            CategoryActivity.this.checkforUnCompleted();
                        } else {
                            Toast.makeText((Context)CategoryActivity.this.getApplicationContext(), (CharSequence)"Unable to submit the answers", (int)0).show();
                        }
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            });
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558437, menu2);
        this.start = menu2.findItem(2131297406);
        this.done = menu2.findItem(2131296684);
        return true;
    }

    private void checkforMenuCreated() {
        final Handler handler = new Handler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (CategoryActivity.this.start != null) {
                    handler.removeCallbacks((Runnable)this);
                    try {
                        CategoryActivity.this.updateMenu();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    handler.postDelayed((Runnable)this, 100L);
                }
            }
        };
        handler.removeCallbacks(runnable2);
        handler.postDelayed(runnable2, 100L);
    }

    private void updateMenu() {
        this.start.setVisible("assigned".equals(this.status));
        this.done.setVisible(!"assigned".equals(this.status));
    }

    private void startInspection() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", this.assignid);
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/start_inspection.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        ServiceDatabase.getInstance(CategoryActivity.this.getApplicationContext()).updateStarted(CategoryActivity.this.assignid);
                        Toast.makeText((Context)CategoryActivity.this.getApplicationContext(), (CharSequence)"Started Sucessfully", (int)0).show();
                        CategoryActivity.this.getCategories();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void onBackPressed() {
        AlertDialog.Builder alertdialog = new AlertDialog.Builder((Context)this);
        alertdialog.setIcon(2131230930);
        alertdialog.setMessage((CharSequence)"Answers will be deleted");
        alertdialog.setPositiveButton((CharSequence)"CLose", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        alertdialog.setPositiveButton((CharSequence)"Go Back", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                CategoryActivity.this.finish();
            }
        });
        alertdialog.show();
    }
}

