/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.activities.CategoryActivity;
import com.b2lmobitech.fieldcloudplus.service.adapter.ProductCombinationAdapter;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import org.json.JSONArray;
import org.json.JSONException;

public class ProductCombinationActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    TextView errorText;
    ProductCombinationAdapter adapter;
    String id;
    String date;
    String assignid;
    JSONArray jsonArray;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492980);
        this.errorText = (TextView)this.findViewById(2131296737);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Products");
        this.id = this.getIntent().getStringExtra("id");
        this.date = this.getIntent().getStringExtra("date");
        this.assignid = this.getIntent().getStringExtra("assignid");
    }

    protected void onResume() {
        super.onResume();
        this.getProducts();
    }

    private void getProducts() {
        this.jsonArray = ServiceDatabase.getInstance((Context)this).getCombinations(this.id, this.date);
        if (this.jsonArray.length() == 0) {
            this.finish();
        }
        this.adapter = new ProductCombinationAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        if (this.jsonArray.length() == 0) {
            this.errorText.setText((CharSequence)"No Inspections");
            this.errorText.setVisibility(0);
        } else if (this.errorText.getVisibility() == 0) {
            this.errorText.setVisibility(8);
        }
    }

    @Override
    public void itemClicked(int position) {
        Intent intent = new Intent(this.getApplicationContext(), CategoryActivity.class);
        intent.putExtra("id", this.id);
        intent.putExtra("date", this.date);
        try {
            intent.putExtra("assignid", this.jsonArray.getJSONObject(position).getString("assignschedule_id"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.startActivity(intent);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

