/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.gesture.GestureOverlayView;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Address;
import android.location.Geocoder;
import android.location.Location;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.widget.AdapterView;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.SwitchCompat;
import androidx.core.app.ActivityCompat;
import androidx.core.content.FileProvider;
import androidx.core.widget.NestedScrollView;
import com.b2lmobitech.fieldcloudplus.others.MaterialSpinner;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.activities.ReceivedSpareActivity;
import com.b2lmobitech.fieldcloudplus.service.activities.SelectSpareActivity;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportActivity
extends AppCompatActivity {
    MaterialSpinner statusSpinner;
    MaterialSpinner hourSpinner;
    SwitchCompat workingBillable;
    SwitchCompat spareBillable;
    RelativeLayout serviceChargeLayout;
    RelativeLayout spareLayout;
    RelativeLayout spareAmountLayout;
    RelativeLayout spareBillableLayout;
    RelativeLayout retrivedLayout;
    ImageView statusCamera;
    ImageView statusImage;
    ImageView billCamera;
    ImageView billImage;
    TextView spareAmount;
    TextView serviceCharge;
    TextView totalCharge;
    EditText thingsDone;
    GestureOverlayView gestureOverlayView;
    Button clearGesture;
    NestedScrollView nestedScrollView;
    EditText signatureName;
    String ticket;
    String facility;
    private final int REQUEST_CODE = 3;
    private final int REQUEST_STATUS_IMAGE = 1;
    private final int REQUEST_BILL_IMAGE = 2;
    private final int REQUEST_CHECK_SETTINGS = 4;
    JSONObject jsonObject = new JSONObject();
    JSONArray jsonArray = new JSONArray();
    int spareCharge = 0;
    Uri imageUri;
    File mediaFile = null;
    ArrayList<String> sparesList = new ArrayList();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492988);
        this.ticket = this.getIntent().getStringExtra("ticket");
        this.facility = this.getIntent().getStringExtra("facility");
        this.getSupportActionBar().setTitle((CharSequence)"Work Report");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        try {
            this.jsonObject.put("bill", (Object)"");
            this.jsonObject.put("status", (Object)"");
            this.jsonObject.put("sparescharge", 0);
            this.jsonObject.put("servicecharge", 0);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.getWidgets();
        this.getSpares();
    }

    private void getWidgets() {
        this.statusSpinner = (MaterialSpinner)this.findViewById(2131297418);
        this.hourSpinner = (MaterialSpinner)this.findViewById(2131296834);
        this.workingBillable = (SwitchCompat)this.findViewById(2131297724);
        this.serviceChargeLayout = (RelativeLayout)this.findViewById(2131297335);
        this.statusCamera = (ImageView)this.findViewById(2131297415);
        this.statusImage = (ImageView)this.findViewById(2131297416);
        this.billCamera = (ImageView)this.findViewById(2131296434);
        this.billImage = (ImageView)this.findViewById(2131296435);
        this.spareLayout = (RelativeLayout)this.findViewById(2131297381);
        this.spareBillable = (SwitchCompat)this.findViewById(2131297379);
        this.spareAmountLayout = (RelativeLayout)this.findViewById(2131297378);
        this.retrivedLayout = (RelativeLayout)this.findViewById(2131297276);
        this.spareBillableLayout = (RelativeLayout)this.findViewById(2131297380);
        this.spareAmount = (TextView)this.findViewById(2131297377);
        this.thingsDone = (EditText)this.findViewById(2131297546);
        this.gestureOverlayView = (GestureOverlayView)this.findViewById(2131296799);
        this.clearGesture = (Button)this.findViewById(2131296531);
        this.nestedScrollView = (NestedScrollView)this.findViewById(2131297077);
        this.signatureName = (EditText)this.findViewById(2131297347);
        this.serviceCharge = (TextView)this.findViewById(2131297334);
        this.totalCharge = (TextView)this.findViewById(2131297586);
        this.workingBillable.setChecked(true);
        this.spareBillable.setChecked(true);
        this.setListeners();
    }

    private void setListeners() {
        this.workingBillable.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                try {
                    ReportActivity.this.setServiceCharge();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        this.hourSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener(){

            public void onItemSelected(AdapterView<?> adapterView, View view, int i, long l) {
                try {
                    ReportActivity.this.setServiceCharge();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }

            public void onNothingSelected(AdapterView<?> adapterView) {
            }
        });
        this.spareLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent(ReportActivity.this.getApplicationContext(), SelectSpareActivity.class);
                intent.putExtra("json", ReportActivity.this.jsonArray.toString());
                intent.putStringArrayListExtra("spares", ReportActivity.this.sparesList);
                ReportActivity.this.startActivityForResult(intent, 3);
            }
        });
        this.retrivedLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent(ReportActivity.this.getApplicationContext(), ReceivedSpareActivity.class);
                intent.putExtra("json", ReportActivity.this.jsonArray.toString());
                ReportActivity.this.startActivity(intent);
            }
        });
        this.spareBillable.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton compoundButton, boolean b) {
                try {
                    ReportActivity.this.setSpares();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
        this.statusCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ReportActivity.this.openCamera(1);
            }
        });
        this.billCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ReportActivity.this.openCamera(2);
            }
        });
        this.clearGesture.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ReportActivity.this.gestureOverlayView.clear(false);
            }
        });
        this.gestureOverlayView.setDrawingCacheEnabled(true);
        this.gestureOverlayView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                ReportActivity.this.nestedScrollView.requestDisallowInterceptTouchEvent(true);
                return false;
            }
        });
    }

    private void setSpares() throws JSONException {
        if (this.jsonArray.length() != 0) {
            this.spareAmountLayout.setVisibility(this.spareBillable.isChecked() ? 0 : 8);
            if (this.spareBillable.isChecked()) {
                this.spareAmountLayout.setVisibility(0);
                this.spareAmount.setText((CharSequence)String.valueOf(this.spareCharge));
                this.jsonObject.put("sparescharge", this.spareCharge);
            } else {
                this.spareAmountLayout.setVisibility(8);
                this.jsonObject.put("sparescharge", 0);
            }
            this.spareBillableLayout.setVisibility(0);
        } else {
            this.jsonObject.put("sparescharge", 0);
            this.spareAmountLayout.setVisibility(8);
            this.spareBillableLayout.setVisibility(8);
        }
        this.setTotalCharge();
    }

    private void setServiceCharge() throws JSONException {
        if (this.workingBillable.isChecked() && this.hourSpinner.getSelectedItemPosition() != 0) {
            int total = this.hourSpinner.getSelectedItemPosition() * 100;
            this.jsonObject.put("servicecharge", total);
            this.serviceChargeLayout.setVisibility(0);
            this.serviceCharge.setText((CharSequence)String.valueOf(total));
        } else {
            this.jsonObject.put("servicecharge", 0);
            this.serviceChargeLayout.setVisibility(8);
        }
        this.setTotalCharge();
    }

    private void setTotalCharge() throws JSONException {
        this.totalCharge.setText((CharSequence)String.format(Locale.getDefault(), "%d", this.jsonObject.getInt("sparescharge") + this.jsonObject.getInt("servicecharge")));
    }

    protected void openCamera(int code) {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.imageUri = this.getOutputMediaFileUri();
        intent.putExtra("output", (Parcelable)this.imageUri);
        this.startActivityForResult(intent, code);
    }

    public Uri getOutputMediaFileUri() {
        this.mediaFile = Utility.getCapturedImageFile();
        Uri uri = null;
        uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)this, (String)"com.b2lmobitech.fieldcloudplus.provider", (File)this.mediaFile) : Uri.fromFile((File)this.mediaFile);
        return uri;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block14: {
            super.onActivityResult(requestCode, resultCode, data);
            if (requestCode == 3 && resultCode == -1) {
                try {
                    JSONObject jsonObject = new JSONObject(data.getStringExtra("json"));
                    this.jsonObject.put("spares", (Object)jsonObject.getJSONArray("list"));
                    this.jsonObject.put("sparescharge", jsonObject.getInt("total"));
                    this.jsonArray = jsonObject.getJSONArray("list");
                    this.spareCharge = jsonObject.getInt("total");
                    this.setSpares();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } else if ((requestCode == 2 || requestCode == 1) && resultCode == -1) {
                try {
                    if (this.imageUri == null) break block14;
                    Bitmap cambmp = BitmapFactory.decodeStream((InputStream)this.getContentResolver().openInputStream(this.imageUri), null, null);
                    cambmp = Utility.processImage(cambmp);
                    if (requestCode == 2) {
                        this.billImage.setImageBitmap(cambmp);
                        this.jsonObject.put("bill", (Object)Utility.bitmap2string(cambmp));
                        break block14;
                    }
                    this.statusImage.setImageBitmap(cambmp);
                    this.jsonObject.put("status", (Object)Utility.bitmap2string(cambmp));
                }
                catch (Exception e) {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"please try again", (int)0).show();
                }
            } else if (requestCode == 4) {
                switch (resultCode) {
                    case -1: {
                        this.getLcoation();
                        break;
                    }
                    case 0: {
                        RequestProgress.getInstance((Activity)this).hideProgressBar();
                        break;
                    }
                }
            }
        }
    }

    private boolean isValid() {
        if (this.statusSpinner.getSelectedItemPosition() == 0) {
            this.alert("Select Ticket Status");
            return false;
        }
        if (this.hourSpinner.getSelectedItemPosition() == 0) {
            this.alert("Select Working Hours");
            return false;
        }
        if (this.thingsDone.getText().toString().isEmpty()) {
            this.alert("Fill Things Done");
            return false;
        }
        if (this.gestureOverlayView.getGesture() == null) {
            this.alert("Get Signature");
            return false;
        }
        if (this.signatureName.getText().toString().isEmpty()) {
            this.alert("Enter Singaturer Name");
            return false;
        }
        return true;
    }

    private void collectData() throws JSONException {
        Preference preference = Preference.getInstance((Context)this);
        this.jsonObject.put("email", (Object)preference.getEmailId());
        this.jsonObject.put("company", (Object)preference.getCompanyName());
        this.jsonObject.put("sign", (Object)Utility.bitmap2string(this.gestureOverlayView.getDrawingCache()));
        this.jsonObject.put("signaturer", (Object)this.signatureName.getText().toString());
        this.jsonObject.put("workstatus", (Object)this.statusSpinner.getSelectedItem().toString());
        this.jsonObject.put("hours", this.hourSpinner.getSelectedItemPosition());
        this.jsonObject.put("things", (Object)this.thingsDone.getText().toString());
        this.jsonObject.put("ticket", (Object)this.ticket);
        this.jsonObject.put("facility", (Object)this.facility);
        this.insertReport();
    }

    private void alert(String str) {
        Toast.makeText((Context)this.getApplicationContext(), (CharSequence)str, (int)0).show();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (!this.isValid()) break;
                this.connectLocation();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void getLcoation() {
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return;
        }
        RequestProgress requestProgress = RequestProgress.getInstance((Activity)this);
        requestProgress.showProgressBar();
        LocationServices.getFusedLocationProviderClient((Activity)this).getCurrentLocation(100, null).addOnCompleteListener(new OnCompleteListener(){

            public void onComplete(@NonNull Task task) {
                Location location = (Location)task.getResult();
                if (location != null) {
                    try {
                        ReportActivity.this.getAddress(location);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else {
                    Toast.makeText((Context)ReportActivity.this.getApplicationContext(), (CharSequence)"Unable to find lcoation", (int)0).show();
                }
            }
        });
    }

    private void connectLocation() {
        LocationRequest locationRequest2 = LocationRequest.create();
        locationRequest2.setPriority(102);
        locationRequest2.setInterval(100L);
        locationRequest2.setFastestInterval(50L);
        LocationSettingsRequest.Builder builder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest2);
        builder.setAlwaysShow(true);
        Task task = LocationServices.getSettingsClient((Activity)this).checkLocationSettings(builder.build());
        task.addOnCompleteListener((OnCompleteListener)new OnCompleteListener<LocationSettingsResponse>(){

            public void onComplete(Task<LocationSettingsResponse> task) {
                try {
                    LocationSettingsResponse response = (LocationSettingsResponse)task.getResult(ApiException.class);
                    ReportActivity.this.getLcoation();
                }
                catch (ApiException exception) {
                    switch (exception.getStatusCode()) {
                        case 6: {
                            try {
                                ResolvableApiException resolvable = (ResolvableApiException)exception;
                                resolvable.startResolutionForResult((Activity)ReportActivity.this, 4);
                                break;
                            }
                            catch (IntentSender.SendIntentException sendIntentException) {
                                break;
                            }
                            catch (ClassCastException classCastException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        });
    }

    private void getAddress(Location location) throws JSONException {
        Geocoder mGeocoder = new Geocoder((Context)this, Locale.getDefault());
        this.jsonObject.put("lat", location.getLatitude());
        this.jsonObject.put("lon", location.getLongitude());
        List addresses = null;
        try {
            addresses = mGeocoder.getFromLocation(location.getLatitude(), location.getLongitude(), 1);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (addresses != null && addresses.size() > 0) {
            this.jsonObject.put("location", (Object)((Address)addresses.get(0)).getAddressLine(0));
        }
        this.collectData();
    }

    private void insertReport() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("JSON", this.jsonObject.toString());
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/insert_workreport.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    ReportActivity.this.insertReport(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getSpares() {
        HashMap<String, String> params = new HashMap<String, String>();
        Preference preference = Preference.getInstance((Context)this);
        params.put("cname", preference.getCompanyName());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/get_spares.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    ReportActivity.this.getSpares(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getSpares(JSONObject jsonObject) throws JSONException {
        this.sparesList = new ArrayList();
        JSONArray jsonArray = jsonObject.getJSONArray("spares");
        this.sparesList = JSONUtils.toArrayListString(jsonArray);
    }

    private void insertReport(JSONObject jsonObject) throws JSONException {
        if (jsonObject.getInt("s") == 1) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Report Submited", (int)0).show();
            this.setResult(-1);
            this.finish();
        } else {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Unable to submit the report", (int)0).show();
        }
    }
}

