/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.widget.DatePicker;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.activities.ReportInfoActivity;
import com.b2lmobitech.fieldcloudplus.service.adapter.TicketHistoryAdapter;
import com.b2lmobitech.fieldcloudplus.service.listener.OnBottomReachedListener;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportHistoryActivity
extends AppCompatActivity
implements OnItemClickListener,
OnBottomReachedListener {
    RecyclerView recyclerView;
    TextView errorText;
    TicketHistoryAdapter adapter;
    int count;
    String date = "";

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492990);
        this.errorText = (TextView)this.findViewById(2131296737);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Report History");
        this.getTicketsCount();
    }

    private void getTicketsCount() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("date", this.date);
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/get_reporthistory.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    ReportHistoryActivity.this.count = new JSONObject(response).getInt("count");
                    ReportHistoryActivity.this.errorText.setText((CharSequence)"No Reports Found");
                    ReportHistoryActivity.this.errorText.setVisibility(ReportHistoryActivity.this.count == 0 ? 0 : 8);
                    ReportHistoryActivity.this.setEmptyAdapter();
                    ReportHistoryActivity.this.getTickets();
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setEmptyAdapter() {
        this.adapter = new TicketHistoryAdapter((Context)this, new JSONArray());
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
    }

    private void getTickets() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("date", this.date);
        if (this.adapter.getItemCount() >= this.count) {
            return;
        }
        params.put("start", this.adapter.getItemCount() + "");
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/get_reporthistory.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    ReportHistoryActivity.this.setAdapter(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setAdapter(JSONObject jsonObject) throws JSONException {
        Parcelable parcelable = this.recyclerView.getLayoutManager().onSaveInstanceState();
        JSONArray jsonArray = this.adapter.getJsonArray();
        JSONArray listArray = jsonObject.getJSONArray("tickets");
        try {
            for (int i = 0; i < listArray.length(); ++i) {
                jsonArray.put((Object)listArray.getJSONObject(i));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (listArray.length() != 0) {
            this.adapter = new TicketHistoryAdapter((Context)this, jsonArray);
            this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
            this.recyclerView.getLayoutManager().onRestoreInstanceState(parcelable);
        }
    }

    @Override
    public void itemClicked(int position) {
        try {
            JSONObject jsonObject = this.adapter.getJsonArray().getJSONObject(position);
            Intent intent = new Intent(this.getApplicationContext(), ReportInfoActivity.class);
            intent.putExtra("ticket", jsonObject.getString("ticketnumber"));
            intent.putExtra("company", jsonObject.getString("cname"));
            this.startActivity(intent);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onBottomReached(int position) {
        if (position + 1 < this.count) {
            this.getTickets();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558440, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296630: {
                this.selectDate();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void selectDate() {
        final Calendar myCalendar = Calendar.getInstance();
        DatePickerDialog.OnDateSetListener listenr = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                myCalendar.set(1, year);
                myCalendar.set(2, monthOfYear);
                myCalendar.set(5, dayOfMonth);
                SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
                sdf = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault());
                ReportHistoryActivity.this.date = sdf.format(myCalendar.getTime());
                ReportHistoryActivity.this.getTicketsCount();
            }
        };
        DatePickerDialog datePicker = new DatePickerDialog((Context)this, listenr, myCalendar.get(1), myCalendar.get(2), myCalendar.get(5));
        datePicker.show();
    }
}

