/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.fragment.app.FragmentActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.activities.SelectSpareActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.bumptech.glide.Glide;
import java.text.ParseException;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportInfoActivity
extends AppCompatActivity {
    String ticket;
    String company;
    LinearLayout detailsLayout;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492991);
        this.detailsLayout = (LinearLayout)this.findViewById(2131296671);
        this.ticket = this.getIntent().getStringExtra("ticket");
        this.company = this.getIntent().getStringExtra("company");
        this.getSupportActionBar().setTitle((CharSequence)"Report Details");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getReportInfo();
    }

    private void getReportInfo() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", this.company);
        params.put("ticket", this.ticket);
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/get_reportinfo.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    ReportInfoActivity.this.getInfo(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getInfo(JSONObject json) throws JSONException, ParseException {
        JSONObject jsonObject = json.getJSONArray("ticket").getJSONObject(0);
        this.addView("Customer Name", jsonObject.getString("customername"));
        this.addView("Facility Name", jsonObject.getString("companyname"));
        this.addView("Address", jsonObject.getString("location"));
        this.addView("Mobile", jsonObject.getString("atmphonenumber"));
        this.addView("Customer Type", jsonObject.getString("customertype"));
        this.addView("Reason", jsonObject.getString("questionorcallreason"));
        this.addView("Created On", DateUtils.getNormalDatetime(jsonObject.getString("createddateandtime")));
        this.addView("Assigned On", DateUtils.getNormalDatetime(jsonObject.getString("assigneddateandtime")));
        this.addView("Completed On", DateUtils.getNormalDatetime(jsonObject.getString("dateandtime")));
        this.addView("Completed Location", jsonObject.getString("workdonelocation"));
        this.addView("Status", jsonObject.getString("workstatus"));
        if (!jsonObject.getString("workreportdetails").isEmpty()) {
            this.addView("Details", jsonObject.getString("workreportdetails"));
        }
        this.addView("Worked Hours", jsonObject.getString("working_hours"));
        if (json.getJSONArray("spares").length() != 0) {
            this.addLinkView(json.getJSONArray("spares"));
        }
        this.addView("Spares Charge", jsonObject.getString("sparesamount"));
        this.addView("Service Charge", jsonObject.getString("servicecharge"));
        this.addView("Total Charge", jsonObject.getString("amountreceived"));
        this.addImageView("Bill Image", jsonObject.getString("billimagepath"));
        this.addImageView("Status Image", jsonObject.getString("imagepath"));
        this.addView("Signaturer", jsonObject.getString("nameofsignature"));
        this.addImageView("Signature", jsonObject.getString("signaturepath"));
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493310, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.detailsLayout.addView(view);
    }

    private void addImageView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493311, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        ImageView imageView = (ImageView)view.findViewById(2131296843);
        Glide.with((FragmentActivity)this).load("http://fieldcloud.in/Eversendai/App/workreportimages/" + pair).into(imageView);
        keyText.setText((CharSequence)key);
        this.detailsLayout.addView(view);
    }

    private void addLinkView(final JSONArray jsonArray) {
        View view = this.getLayoutInflater().inflate(2131493309, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        keyText.setText((CharSequence)"Spares List");
        view.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent(ReportInfoActivity.this.getApplicationContext(), SelectSpareActivity.class);
                intent.putExtra("add", false);
                intent.putExtra("json", jsonArray.toString());
                ReportInfoActivity.this.startActivity(intent);
            }
        });
        this.detailsLayout.addView(view);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

