/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;
import com.b2lmobitech.fieldcloudplus.service.activities.AddSpareActivity;
import com.b2lmobitech.fieldcloudplus.service.adapter.SpareAdapter;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SelectSpareActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    TextView errorText;
    private final int REQUEST_CODE = 2;
    JSONArray jsonArray = new JSONArray();
    ArrayList<JSONObject> arrayList = new ArrayList();
    ArrayList<String> sparesList = new ArrayList();
    boolean add;
    SpareAdapter spareAdapter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493005);
        this.getSupportActionBar().setTitle((CharSequence)"Spares");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.errorText = (TextView)this.findViewById(2131296737);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.add = this.getIntent().getBooleanExtra("add", true);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        try {
            this.jsonArray = new JSONArray(this.getIntent().getStringExtra("json"));
            this.sparesList = this.getIntent().getStringArrayListExtra("spares");
            this.arrayList = JSONUtils.fromJSONArray(this.jsonArray);
            this.setAdapter();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        if (this.add) {
            this.addSwipeDelete();
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 2 && resultCode == -1) {
            try {
                JSONObject jsonObject = new JSONObject(data.getStringExtra("json"));
                this.arrayList.add(jsonObject);
                this.setAdapter();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    private void setAdapter() {
        Parcelable parcelable = this.recyclerView.getLayoutManager().onSaveInstanceState();
        this.spareAdapter = new SpareAdapter((Context)this, this.arrayList);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.spareAdapter);
        this.recyclerView.getLayoutManager().onRestoreInstanceState(parcelable);
        if (this.arrayList.size() == 0) {
            this.errorText.setText((CharSequence)"No Spares Added");
            this.errorText.setVisibility(0);
        } else {
            this.errorText.setVisibility(8);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558438, menu2);
        MenuItem addSapre = menu2.findItem(2131296356);
        addSapre.setVisible(this.add);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296356: {
                Intent intent = new Intent(this.getApplicationContext(), AddSpareActivity.class);
                intent.putExtra("json", JSONUtils.fromArrayList(this.arrayList).toString());
                intent.putStringArrayListExtra("spares", this.sparesList);
                this.startActivityForResult(intent, 2);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void itemClicked(int position) {
    }

    public void onBackPressed() {
        if (this.add) {
            try {
                this.setResult();
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            this.finish();
        }
    }

    private void setResult() throws JSONException {
        int total = 0;
        JSONArray jsonArray = this.spareAdapter.getJsonArray();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            total += jsonObject.getInt("total");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("total", total);
        jsonObject.put("list", (Object)jsonArray);
        this.setResult(-1, new Intent().putExtra("json", jsonObject.toString()));
        this.finish();
    }

    private void addSwipeDelete() {
        ItemTouchHelper.SimpleCallback simpleCallback = new ItemTouchHelper.SimpleCallback(0, 12){
            public static final float ALPHA_FULL = 1.0f;

            public boolean onMove(RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder2, RecyclerView.ViewHolder target) {
                return false;
            }

            public void onChildDraw(Canvas c, RecyclerView recyclerView, RecyclerView.ViewHolder viewHolder2, float dX, float dY, int actionState, boolean isCurrentlyActive) {
                if (actionState == 1) {
                    View itemView = viewHolder2.itemView;
                    Paint p = new Paint();
                    if (dX > 0.0f) {
                        p.setARGB(255, 255, 0, 0);
                        c.drawRect((float)itemView.getLeft(), (float)itemView.getTop(), dX, (float)itemView.getBottom(), p);
                        Bitmap icon = BitmapFactory.decodeResource((Resources)SelectSpareActivity.this.getApplicationContext().getResources(), (int)2131230966);
                        c.drawBitmap(icon, (float)itemView.getLeft() + (float)this.convertDpToPx(16), (float)itemView.getTop() + ((float)itemView.getBottom() - (float)itemView.getTop() - (float)icon.getHeight()) / 2.0f, p);
                    }
                    float alpha = 1.0f - Math.abs(dX) / (float)viewHolder2.itemView.getWidth();
                    viewHolder2.itemView.setAlpha(alpha);
                    viewHolder2.itemView.setTranslationX(dX);
                } else {
                    super.onChildDraw(c, recyclerView, viewHolder2, dX, dY, actionState, isCurrentlyActive);
                }
            }

            private int convertDpToPx(int dp) {
                return Math.round((float)dp * (SelectSpareActivity.this.getResources().getDisplayMetrics().xdpi / 160.0f));
            }

            public void onSwiped(RecyclerView.ViewHolder viewHolder2, int direction) {
                int position = viewHolder2.getAdapterPosition();
                if (direction == 8) {
                    SelectSpareActivity.this.spareAdapter.removeItem(position);
                    SelectSpareActivity.this.setAdapter();
                }
            }
        };
        ItemTouchHelper itemTouchHelper = new ItemTouchHelper((ItemTouchHelper.Callback)simpleCallback);
        itemTouchHelper.attachToRecyclerView(this.recyclerView);
    }
}

