/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.activities.CategoryActivity;
import com.b2lmobitech.fieldcloudplus.service.adapter.ServiceCombinationAdapter;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import org.json.JSONArray;
import org.json.JSONException;

public class ServiceCombinationActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    TextView errorText;
    String id;
    String date;
    String assignid;
    String lat;
    String lon;
    JSONArray jsonArray;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493013);
        this.errorText = (TextView)this.findViewById(2131296737);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Service");
        this.id = this.getIntent().getStringExtra("id");
        this.date = this.getIntent().getStringExtra("date");
        this.assignid = this.getIntent().getStringExtra("assignid");
        this.lat = this.getIntent().getStringExtra("lat");
        this.lon = this.getIntent().getStringExtra("lon");
        Log.e((String)"location", (String)("[" + this.lat + "," + this.lon + "]"));
    }

    protected void onResume() {
        super.onResume();
        this.getCategories();
    }

    private void getCategories() {
        this.jsonArray = ServiceDatabase.getInstance((Context)this).getCombinations(this.id, this.date);
        if (this.jsonArray.length() == 0) {
            this.finish();
        } else if (this.jsonArray.length() == 1) {
            this.itemClicked(0);
            this.finish();
        }
        ServiceCombinationAdapter serviceCombinationAdapter = new ServiceCombinationAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)serviceCombinationAdapter);
    }

    @Override
    public void itemClicked(int position) {
        Intent intent = new Intent(this.getApplicationContext(), CategoryActivity.class);
        intent.putExtra("id", this.id);
        intent.putExtra("date", this.date);
        intent.putExtra("lat", this.lat);
        intent.putExtra("lon", this.lon);
        try {
            intent.putExtra("assignid", this.jsonArray.getJSONObject(position).getString("assignschedule_id"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.startActivity(intent);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

