/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.activities.TicketInfoActivity;
import com.b2lmobitech.fieldcloudplus.service.adapter.TicketAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketActivity
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    TextView errorText;
    TicketAdapter adapter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493039);
        this.errorText = (TextView)this.findViewById(2131296737);
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Tickets");
        this.getTickets();
    }

    protected void onResume() {
        super.onResume();
        this.getTickets();
    }

    private void getTickets() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/get_corrective.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    TicketActivity.this.setAdapter(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setAdapter(JSONObject jsonObject) throws JSONException {
        Parcelable parcelable = this.recyclerView.getLayoutManager().onSaveInstanceState();
        JSONArray jsonArray = jsonObject.getJSONArray("tickets");
        this.adapter = new TicketAdapter((Context)this, jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.adapter);
        this.errorText.setText((CharSequence)"No Tickets Found");
        this.errorText.setVisibility(jsonArray.length() == 0 ? 0 : 8);
        this.recyclerView.getLayoutManager().onRestoreInstanceState(parcelable);
    }

    @Override
    public void itemClicked(int position) {
        try {
            JSONObject jsonObject = this.adapter.getJsonArray().getJSONObject(position);
            Intent intent = new Intent(this.getApplicationContext(), TicketInfoActivity.class);
            intent.putExtra("ticket", jsonObject.getString("ticketnumber"));
            intent.putExtra("facility", jsonObject.getString("atmid"));
            this.startActivity(intent);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

