/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.service.activities.ReportActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.google.android.material.tabs.TabLayout;
import java.text.ParseException;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketInfoActivity
extends AppCompatActivity {
    TabLayout tabLayout;
    LinearLayout detailsLayout;
    String ticket;
    String facility;
    private static final int CAPTURE_NUMBER = 2;
    private static final int REQUEST = 1;
    MenuItem report;
    MenuItem accept;
    MenuItem reject;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493040);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Ticket Details");
        this.ticket = this.getIntent().getStringExtra("ticket");
        this.facility = this.getIntent().getStringExtra("facility");
        this.getWidgets();
        this.getTicketInfo();
    }

    protected void onResume() {
        super.onResume();
    }

    private void getTicketInfo() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("ticket", this.ticket);
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/get_ticketdetails.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    TicketInfoActivity.this.getInfo(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getWidgets() {
        this.tabLayout = (TabLayout)this.findViewById(2131297446);
        this.detailsLayout = (LinearLayout)this.findViewById(2131296671);
    }

    private void getInfo(final JSONObject jsonObject) throws JSONException, ParseException {
        final boolean isProduct = jsonObject.getString("service_category").isEmpty();
        this.checkforMenuCreated(jsonObject.getString("ticketstatus"));
        this.tabLayout.removeAllTabs();
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Info"), true);
        if (isProduct) {
            this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Product"));
        } else {
            this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Service"));
        }
        this.tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                try {
                    if (tab.getPosition() == 0) {
                        TicketInfoActivity.this.addInfo(jsonObject);
                    } else if (isProduct) {
                        TicketInfoActivity.this.addProductInfo(jsonObject);
                    } else {
                        TicketInfoActivity.this.addServiceInfo(jsonObject);
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }

            public void onTabUnselected(TabLayout.Tab tab) {
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
        this.addInfo(jsonObject);
    }

    private void addInfo(JSONObject json) throws JSONException, ParseException {
        this.detailsLayout.removeAllViews();
        JSONObject jsonObject = json.getJSONArray("ticket").getJSONObject(0);
        this.addView("Ticket Number", jsonObject.getString("ticketnumber"));
        this.addView("Customer Name", jsonObject.getString("customername"));
        this.addView("Address", json.getString("atmaddress"));
        this.addView("Mobile", json.getString("atmphonenumber"));
        this.addView("Customer Type", jsonObject.getString("customertype"));
        this.addView("Reason", jsonObject.getString("questionorcallreason"));
        if (!jsonObject.getString("extranotes").isEmpty()) {
            this.addView("Notes", jsonObject.getString("extranotes"));
        }
        this.addView("Priority", jsonObject.getString("priority"));
        this.addView("Created On", DateUtils.getNormalDatetime(jsonObject.getString("createddateandtime")));
        this.addView("Assigned On", DateUtils.getNormalDatetime(jsonObject.getString("assigneddateandtime")));
    }

    private void addProductInfo(JSONObject jsonObject) throws JSONException {
        this.detailsLayout.removeAllViews();
        this.addView("Product", jsonObject.getString("product"));
        if (!jsonObject.getString("brand").isEmpty()) {
            this.addView("Brand", jsonObject.getString("brand"));
        }
        if (!jsonObject.getString("model").isEmpty()) {
            this.addView("Model", jsonObject.getString("model"));
        }
        if (!jsonObject.getString("serial").isEmpty()) {
            this.addView("Serial Number", jsonObject.getString("serial"));
        }
    }

    private void addServiceInfo(JSONObject jsonObject) throws JSONException {
        this.detailsLayout.removeAllViews();
        this.addView("Service Group", jsonObject.getString("cat"));
        if (!jsonObject.getString("subcat").isEmpty()) {
            this.addView("Service Sub Group", jsonObject.getString("subcat"));
        }
        if (!jsonObject.getString("type").isEmpty()) {
            this.addView("Service Type", jsonObject.getString("type"));
        }
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493310, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.detailsLayout.addView(view);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558439, menu2);
        this.reject = menu2.findItem(2131297249);
        this.accept = menu2.findItem(2131296282);
        this.report = menu2.findItem(2131297256);
        this.reject.setVisible(false);
        this.accept.setVisible(false);
        this.report.setVisible(false);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131297256: {
                this.openReport();
                break;
            }
            case 2131296282: {
                this.updateTicket("accept");
                break;
            }
            case 2131297249: {
                this.updateTicket("reject");
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1) {
            switch (resultCode) {
                case -1: {
                    this.finish();
                    break;
                }
                case 0: {
                    break;
                }
            }
        }
    }

    private void openReport() {
        Intent intent = new Intent(this.getApplicationContext(), ReportActivity.class);
        intent.putExtra("ticket", this.ticket);
        intent.putExtra("facility", this.facility);
        this.startActivityForResult(intent, 1);
    }

    private void updateTicket(final String status) {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("status", status);
        params.put("ticket", this.ticket);
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/update_ticket.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                if (status.equals("reject")) {
                    TicketInfoActivity.this.finish();
                } else {
                    TicketInfoActivity.this.getTicketInfo();
                }
            }
        });
    }

    private void checkforMenuCreated(final String status) {
        final Handler handler = new Handler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (TicketInfoActivity.this.report != null) {
                    handler.removeCallbacks((Runnable)this);
                    try {
                        TicketInfoActivity.this.updateMenu(status);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    handler.postDelayed((Runnable)this, 100L);
                }
            }
        };
        handler.removeCallbacks(runnable2);
        handler.postDelayed(runnable2, 100L);
    }

    private void updateMenu(String status) {
        if (status.equals("assigned")) {
            this.accept.setVisible(true);
            this.reject.setVisible(true);
            this.report.setVisible(false);
        } else if (status.equals("underprogress")) {
            this.report.setVisible(true);
            this.accept.setVisible(false);
            this.reject.setVisible(false);
        }
    }
}

