/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.activities;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.DatePicker;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.service.activities.addexpense;
import com.b2lmobitech.fieldcloudplus.service.adapter.expenseadapter;
import com.google.android.material.floatingactionbutton.FloatingActionButton;
import com.google.android.material.snackbar.Snackbar;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class expense
extends AppCompatActivity {
    private Context mycontext;
    private FloatingActionButton fab;
    private FloatingActionButton fab1;
    private FloatingActionButton fab2;
    private Animation fab_open;
    private Animation fab_close;
    private Animation rotate_forward;
    private Animation rotate_backward;
    private Boolean isFabOpen = false;
    private TextView addexpensetext;
    private TextView addcalendartext;
    private TextView history;
    private ArrayList<String> date;
    private ArrayList<String> description;
    private ArrayList<String> type;
    private ArrayList<String> amount;
    private ListView expenselistview;
    private String url_get_expenses = "";
    private String registeredcompany;
    private String registeredemailid;
    private String selecteddate = "0000-00-00";
    private String month;
    private String day;
    private int getsuccess = 0;
    private int status = 0;
    private ProgressBar progressbar;
    private SwipeRefreshLayout swipeContainer;
    private Snackbar snackBar;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492943);
        Toolbar toolbar = (Toolbar)this.findViewById(2131297581);
        this.setSupportActionBar(toolbar);
        this.mycontext = this;
        this.fab = (FloatingActionButton)this.findViewById(2131296752);
        this.fab1 = (FloatingActionButton)this.findViewById(2131296753);
        this.fab2 = (FloatingActionButton)this.findViewById(2131296754);
        this.expenselistview = (ListView)this.findViewById(2131296746);
        globalvariables.Logoutsharedpreference = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        this.registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        this.swipeContainer = (SwipeRefreshLayout)this.findViewById(2131297440);
        this.fab.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                expense.this.animateFAB();
            }
        });
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.fab_open = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130771997);
        this.fab_close = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130771996);
        this.rotate_forward = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130772007);
        this.rotate_backward = AnimationUtils.loadAnimation((Context)this.getApplicationContext(), (int)2130772006);
        this.addexpensetext = (TextView)this.findViewById(2131296360);
        this.addcalendartext = (TextView)this.findViewById(2131296359);
        this.history = (TextView)this.findViewById(2131296827);
        this.progressbar = (ProgressBar)this.findViewById(2131296747);
        this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
        this.fab1.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Intent intent = new Intent(expense.this.mycontext, addexpense.class);
                intent.addFlags(0x10000000);
                expense.this.mycontext.startActivity(intent);
            }
        });
        this.fab2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                Calendar c = Calendar.getInstance();
                int mYear = c.get(1);
                int mMonth = c.get(2);
                int mDay = c.get(5);
                DatePickerDialog datePickerDialog = new DatePickerDialog(expense.this.mycontext, new DatePickerDialog.OnDateSetListener(){

                    public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                        if (++monthOfYear < 10) {
                            expense.this.month = "0" + monthOfYear;
                        } else {
                            expense.this.month = "" + monthOfYear;
                        }
                        if (dayOfMonth < 10) {
                            expense.this.day = "0" + dayOfMonth;
                        } else {
                            expense.this.day = "" + dayOfMonth;
                        }
                        expense.this.selecteddate = year + "-" + expense.this.month + "-" + expense.this.day;
                        if (expense.this.isNetworkAvailable()) {
                            expense.this.getExpense();
                        } else {
                            expense.this.snackBar.dismiss();
                            expense.this.snackBar = Snackbar.make((View)expense.this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
                            expense.this.toast();
                        }
                    }
                }, mYear, mMonth, mDay);
                datePickerDialog.show();
            }
        });
        this.date = new ArrayList();
        this.description = new ArrayList();
        this.type = new ArrayList();
        this.amount = new ArrayList();
        if (this.isNetworkAvailable()) {
            this.history.setVisibility(8);
            this.getExpense();
        } else {
            this.history.setVisibility(0);
            this.snackBar.dismiss();
            this.snackBar = Snackbar.make((View)this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
            this.toast();
        }
        this.swipeContainer.setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener(){

            public void onRefresh() {
                if (expense.this.isNetworkAvailable()) {
                    expense.this.selecteddate = "0000-00-00";
                    expense.this.getExpense();
                } else {
                    expense.this.snackBar.dismiss();
                    expense.this.snackBar = Snackbar.make((View)expense.this.findViewById(0x1020002), (CharSequence)"Please check internet connection", (int)-2);
                    expense.this.toast();
                }
                expense.this.swipeContainer.setRefreshing(false);
            }
        });
    }

    public void animateFAB() {
        if (this.isFabOpen.booleanValue()) {
            this.fab.startAnimation(this.rotate_backward);
            this.fab1.startAnimation(this.fab_close);
            this.fab2.startAnimation(this.fab_close);
            this.addexpensetext.setVisibility(8);
            this.addcalendartext.setVisibility(8);
            this.fab1.setClickable(false);
            this.fab2.setClickable(false);
            this.isFabOpen = false;
        } else {
            this.fab.startAnimation(this.rotate_forward);
            this.fab1.startAnimation(this.fab_open);
            this.fab2.startAnimation(this.fab_open);
            this.addexpensetext.setVisibility(0);
            this.addcalendartext.setVisibility(0);
            this.fab1.setClickable(true);
            this.fab2.setClickable(true);
            this.isFabOpen = true;
        }
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mycontext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (cm.getNetworkInfo(1).isConnectedOrConnecting()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    private void getExpense() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("companyname", this.registeredcompany);
        params.put("submittedby", this.registeredemailid);
        params.put("dateandtime", this.selecteddate);
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        myRequestQueue.isNoNetwork();
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/service/get_expenselist.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getInt("s") == 1) {
                        expense.this.setAdapter(jsonObject.getJSONArray("expense"));
                    } else {
                        expense.this.snackBar.dismiss();
                        expense.this.snackBar = Snackbar.make((View)expense.this.findViewById(0x1020002), (CharSequence)"No list found", (int)-2);
                        expense.this.toast();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void setAdapter(JSONArray jsonArray) throws JSONException {
        this.date.clear();
        this.description.clear();
        this.type.clear();
        this.amount.clear();
        int countval = jsonArray.length();
        for (int i = 0; i < countval; ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            this.date.add(jsonObject.getString("dateandtime"));
            this.description.add(jsonObject.getString("description"));
            this.type.add(jsonObject.getString("expensetype"));
            this.amount.add(jsonObject.getString("claimamount"));
        }
        Parcelable parcelable = this.expenselistview.onSaveInstanceState();
        expenseadapter adapter2 = new expenseadapter(this.mycontext, this.date, this.description, this.type, this.amount, jsonArray);
        this.expenselistview.setAdapter((ListAdapter)adapter2);
        if (parcelable != null) {
            this.expenselistview.onRestoreInstanceState(parcelable);
        }
    }

    private void toast() {
        this.snackBar.setAction((CharSequence)"CLOSE", new View.OnClickListener(){

            public void onClick(View v) {
                expense.this.snackBar.dismiss();
            }
        }).setActionTextColor(this.getResources().getColor(17170451)).show();
    }
}

