/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CategoryAdapter
extends RecyclerView.Adapter<viewHolder> {
    private Context context;
    private JSONArray jsonArray;
    private ServiceDatabase database;
    private OnItemClickListener itemClickListener;

    public CategoryAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.itemClickListener = (OnItemClickListener)context;
        this.database = ServiceDatabase.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return this.jsonArray;
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            Log.d((String)"category adapter", (String)jsonObject.toString());
            holder2.textView.setText((CharSequence)this.database.getQCatName(jsonObject.getString("category")));
            if (jsonObject.getBoolean("isCompleted")) {
                holder2.completedText.setText((CharSequence)"Completed");
                holder2.completedText.setVisibility(0);
                holder2.completedText.setTextColor(this.context.getResources().getColor(2131099779));
            } else if (jsonObject.getString("sync").equals("0")) {
                holder2.completedText.setText((CharSequence)"Offline");
                holder2.completedText.setTextColor(-65536);
            } else {
                holder2.completedText.setVisibility(8);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            holder2.completedText.setVisibility(8);
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493188, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;
        TextView completedText;

        public viewHolder(View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(2131297504);
            this.completedText = (TextView)itemView.findViewById(2131296552);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    CategoryAdapter.this.itemClickListener.itemClicked(viewHolder.this.getAdapterPosition());
                }
            });
        }
    }
}

