/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.PopupMenu;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.listener.PreventiveListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PreventiveAdapter
extends RecyclerView.Adapter<viewHolder> {
    private Context context;
    private JSONArray jsonArray;
    private Database database;
    private OnItemClickListener itemClickListener;
    private PreventiveListener preventiveListener;

    public PreventiveAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.itemClickListener = (OnItemClickListener)context;
        this.preventiveListener = (PreventiveListener)context;
        this.database = Database.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return this.jsonArray;
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            holder2.text1.setText((CharSequence)String.format("%s (%s)", jsonObject.getString("customername"), jsonObject.getString("atmid")));
            holder2.text2.setText((CharSequence)jsonObject.getString("atmaddress"));
            holder2.text3.setText((CharSequence)String.format("%s \u2022 %s", jsonObject.getString("assigndate"), jsonObject.getString("customertype")));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493199, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView text1;
        TextView text2;
        TextView text3;
        ImageView moreImage;

        public viewHolder(View itemView) {
            super(itemView);
            this.text1 = (TextView)itemView.findViewById(2131297494);
            this.text2 = (TextView)itemView.findViewById(2131297495);
            this.text3 = (TextView)itemView.findViewById(2131297496);
            this.moreImage = (ImageView)itemView.findViewById(2131297034);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    PreventiveAdapter.this.itemClickListener.itemClicked(viewHolder.this.getAdapterPosition());
                }
            });
            this.moreImage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PopupMenu popup = new PopupMenu(PreventiveAdapter.this.context, (View)viewHolder.this.moreImage);
                    MenuInflater inflater = popup.getMenuInflater();
                    inflater.inflate(2131558436, popup.getMenu());
                    popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

                        public boolean onMenuItemClick(MenuItem item) {
                            switch (item.getItemId()) {
                                case 2131296470: {
                                    PreventiveAdapter.this.preventiveListener.callCustomer(viewHolder.this.getAdapterPosition());
                                    break;
                                }
                                case 2131297121: {
                                    PreventiveAdapter.this.preventiveListener.openMap(viewHolder.this.getAdapterPosition());
                                    break;
                                }
                                default: {
                                    return false;
                                }
                            }
                            return false;
                        }
                    });
                    popup.show();
                }
            });
        }
    }
}

