/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProductCombinationAdapter
extends RecyclerView.Adapter<viewHolder> {
    private Context context;
    private JSONArray jsonArray;
    private ServiceDatabase database;
    private OnItemClickListener itemClickListener;

    public ProductCombinationAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.itemClickListener = (OnItemClickListener)context;
        this.database = ServiceDatabase.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return this.jsonArray;
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            if (!this.database.getProduct(jsonObject.getString("productid")).isEmpty()) {
                holder2.text1.setText((CharSequence)this.database.getProduct(jsonObject.getString("productid")));
            } else {
                holder2.layout1.setVisibility(8);
            }
            if (!this.database.getBrand(jsonObject.getString("brandid")).isEmpty()) {
                holder2.text2.setText((CharSequence)this.database.getBrand(jsonObject.getString("brandid")));
            } else {
                holder2.layout2.setVisibility(8);
            }
            if (!this.database.getModel(jsonObject.getString("modelid")).isEmpty()) {
                holder2.text3.setText((CharSequence)this.database.getModel(jsonObject.getString("modelid")));
            } else {
                holder2.layout3.setVisibility(8);
            }
            if (!this.database.getSerialNumber(jsonObject.getString("serialid")).isEmpty()) {
                holder2.text4.setText((CharSequence)this.database.getSerialNumber(jsonObject.getString("serialid")));
            } else {
                holder2.layout4.setVisibility(8);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493200, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView text1;
        TextView text2;
        TextView text3;
        TextView text4;
        LinearLayout layout4;
        LinearLayout layout3;
        LinearLayout layout2;
        LinearLayout layout1;

        public viewHolder(View itemView) {
            super(itemView);
            this.text1 = (TextView)itemView.findViewById(2131297494);
            this.text2 = (TextView)itemView.findViewById(2131297495);
            this.text3 = (TextView)itemView.findViewById(2131297496);
            this.text4 = (TextView)itemView.findViewById(2131297497);
            this.layout4 = (LinearLayout)itemView.findViewById(2131296925);
            this.layout3 = (LinearLayout)itemView.findViewById(2131296924);
            this.layout2 = (LinearLayout)itemView.findViewById(2131296923);
            this.layout1 = (LinearLayout)itemView.findViewById(2131296922);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ProductCombinationAdapter.this.itemClickListener.itemClicked(viewHolder.this.getAdapterPosition());
                }
            });
        }
    }
}

