/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.ItemTouchHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RankingAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final List<String> optionIds;
    private final List<String> optionTexts;
    private final OnRankingChangedListener listener;
    public final ItemTouchHelper.Callback itemTouchHelperCallback = new ItemTouchHelper.SimpleCallback(3, 0){

        public boolean onMove(@NonNull RecyclerView recyclerView, @NonNull RecyclerView.ViewHolder viewHolder2, @NonNull RecyclerView.ViewHolder target) {
            int fromPos = viewHolder2.getAdapterPosition();
            int toPos = target.getAdapterPosition();
            Collections.swap(RankingAdapter.this.optionIds, fromPos, toPos);
            Collections.swap(RankingAdapter.this.optionTexts, fromPos, toPos);
            RankingAdapter.this.notifyItemMoved(fromPos, toPos);
            if (RankingAdapter.this.listener != null) {
                RankingAdapter.this.listener.onRankingChanged(RankingAdapter.this.optionIds);
            }
            return true;
        }

        public void onSwiped(@NonNull RecyclerView.ViewHolder viewHolder2, int direction) {
        }

        public boolean isLongPressDragEnabled() {
            return true;
        }
    };

    public RankingAdapter(List<String> optionIds, List<String> optionTexts, OnRankingChangedListener listener2) {
        this.optionIds = new ArrayList<String>(optionIds);
        this.optionTexts = new ArrayList<String>(optionTexts);
        this.listener = listener2;
    }

    @NonNull
    public ViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        View view = LayoutInflater.from((Context)parent.getContext()).inflate(2131493181, parent, false);
        return new ViewHolder(view);
    }

    public void onBindViewHolder(@NonNull ViewHolder holder2, int position) {
        holder2.textView.setText((CharSequence)this.optionTexts.get(position));
    }

    public int getItemCount() {
        return this.optionTexts.size();
    }

    public static interface OnRankingChangedListener {
        public void onRankingChanged(List<String> var1);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        TextView textView;
        ImageView dragHandle;

        public ViewHolder(View itemView) {
            super(itemView);
            this.textView = (TextView)itemView.findViewById(2131297540);
            this.dragHandle = (ImageView)itemView.findViewById(2131296693);
        }
    }
}

