/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.service.sql.ServiceDatabase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServiceCombinationAdapter
extends RecyclerView.Adapter<viewHolder> {
    private Context context;
    private JSONArray jsonArray;
    private ServiceDatabase database;
    private OnItemClickListener itemClickListener;

    public ServiceCombinationAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.itemClickListener = (OnItemClickListener)context;
        this.database = ServiceDatabase.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return this.jsonArray;
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            if (!this.database.getServiceTypeName(jsonObject.getString("service_servicetype")).isEmpty()) {
                holder2.text3.setText((CharSequence)this.database.getServiceTypeName(jsonObject.getString("service_servicetype")));
            } else {
                holder2.layout3.setVisibility(8);
            }
            holder2.text1.setText((CharSequence)this.database.getCategoryName(jsonObject.getString("service_category")));
            if (!this.database.getSubCategoryName(jsonObject.getString("service_subcategory")).isEmpty()) {
                holder2.text2.setText((CharSequence)this.database.getSubCategoryName(jsonObject.getString("service_subcategory")));
            } else {
                holder2.layout2.setVisibility(8);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493204, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView text1;
        TextView text2;
        TextView text3;
        LinearLayout layout3;
        LinearLayout layout2;

        public viewHolder(View itemView) {
            super(itemView);
            this.text1 = (TextView)itemView.findViewById(2131297494);
            this.text2 = (TextView)itemView.findViewById(2131297495);
            this.text3 = (TextView)itemView.findViewById(2131297496);
            this.layout3 = (LinearLayout)itemView.findViewById(2131296924);
            this.layout2 = (LinearLayout)itemView.findViewById(2131296923);
            this.setIsRecyclable(false);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    ServiceCombinationAdapter.this.itemClickListener.itemClicked(viewHolder.this.getAdapterPosition());
                }
            });
        }
    }
}

