/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.LayoutInflater;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.widget.PopupMenu;
import androidx.core.app.ActivityCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketAdapter
extends RecyclerView.Adapter<viewHolder> {
    private Context context;
    private JSONArray jsonArray;
    private Database database;
    private OnItemClickListener itemClickListener;

    public TicketAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.itemClickListener = (OnItemClickListener)context;
        this.database = Database.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return this.jsonArray;
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            holder2.text1.setText((CharSequence)String.format("%s (%s)", jsonObject.getString("customername"), jsonObject.getString("companyname")));
            holder2.text2.setText((CharSequence)jsonObject.getString("location"));
            holder2.text3.setText((CharSequence)jsonObject.getString("assigneddateandtime"));
            holder2.text4.setText((CharSequence)jsonObject.getString("priority"));
            if (jsonObject.getString("ticketstatus").equals("assigned")) {
                holder2.newIcon.setVisibility(0);
            } else {
                holder2.newIcon.setVisibility(4);
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493219, parent, false);
        return new viewHolder(itemView);
    }

    private void callCustomer(int position) {
        try {
            JSONObject jsonObject = this.getJsonArray().getJSONObject(position);
            if (ActivityCompat.checkSelfPermission((Context)this.context, (String)"android.permission.CALL_PHONE") != 0) {
                return;
            }
            this.context.startActivity(new Intent("android.intent.action.CALL", Uri.parse((String)("tel:" + jsonObject.getString("atmphonenumber")))));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    private void openMap(int position) {
        try {
            JSONObject jsonObject = this.getJsonArray().getJSONObject(position);
            Uri gmmIntentUri = Uri.parse((String)("geo:" + jsonObject.getString("latitude") + "," + jsonObject.getString("longitude") + "?q=" + jsonObject.getString("latitude") + "," + jsonObject.getString("longitude")));
            Intent mapIntent = new Intent("android.intent.action.VIEW", gmmIntentUri);
            mapIntent.setPackage("com.google.android.apps.maps");
            this.context.startActivity(mapIntent);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView text1;
        TextView text2;
        TextView text3;
        TextView text4;
        ImageView moreImage;
        ImageView newIcon;

        public viewHolder(View itemView) {
            super(itemView);
            this.text1 = (TextView)itemView.findViewById(2131297494);
            this.text2 = (TextView)itemView.findViewById(2131297495);
            this.text3 = (TextView)itemView.findViewById(2131297496);
            this.text4 = (TextView)itemView.findViewById(2131297497);
            this.newIcon = (ImageView)itemView.findViewById(2131297081);
            this.moreImage = (ImageView)itemView.findViewById(2131297034);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TicketAdapter.this.itemClickListener.itemClicked(viewHolder.this.getAdapterPosition());
                }
            });
            this.moreImage.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    PopupMenu popup = new PopupMenu(TicketAdapter.this.context, (View)viewHolder.this.moreImage);
                    MenuInflater inflater = popup.getMenuInflater();
                    inflater.inflate(2131558436, popup.getMenu());
                    popup.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

                        public boolean onMenuItemClick(MenuItem item) {
                            switch (item.getItemId()) {
                                case 2131296470: {
                                    TicketAdapter.this.callCustomer(viewHolder.this.getAdapterPosition());
                                    break;
                                }
                                case 2131297121: {
                                    TicketAdapter.this.openMap(viewHolder.this.getAdapterPosition());
                                    break;
                                }
                                default: {
                                    return false;
                                }
                            }
                            return false;
                        }
                    });
                    popup.show();
                }
            });
        }
    }
}

