/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.service.listener.OnBottomReachedListener;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import java.text.ParseException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketHistoryAdapter
extends RecyclerView.Adapter<viewHolder> {
    private Context context;
    private JSONArray jsonArray;
    private Database database;
    private OnItemClickListener itemClickListener;
    private OnBottomReachedListener onBottomReachedListener;

    public TicketHistoryAdapter(Context context, JSONArray jsonArray) {
        this.context = context;
        this.jsonArray = jsonArray;
        this.itemClickListener = (OnItemClickListener)context;
        this.onBottomReachedListener = (OnBottomReachedListener)context;
        this.database = Database.getInstance(context);
    }

    public JSONArray getJsonArray() {
        return this.jsonArray;
    }

    public void onBindViewHolder(viewHolder holder2, int position) {
        try {
            JSONObject jsonObject = this.jsonArray.getJSONObject(position);
            holder2.text1.setText((CharSequence)String.format("%s (%s)", jsonObject.getString("customername"), jsonObject.getString("companyname")));
            holder2.text2.setText((CharSequence)jsonObject.getString("location"));
            holder2.text3.setText((CharSequence)jsonObject.getString("ticketstatus"));
            holder2.text4.setText((CharSequence)DateUtils.getNormalDate(jsonObject.getString("assigneddateandtime")));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (holder2.getAdapterPosition() == this.jsonArray.length() - 1) {
            this.onBottomReachedListener.onBottomReached(holder2.getAdapterPosition());
        }
    }

    public void addToArray(int startposition, JSONArray jsonArray) {
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.jsonArray.put((Object)jsonArray.getJSONObject(i));
            }
            this.notifyItemRangeInserted(startposition, jsonArray.length());
            this.notifyDataSetChanged();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    public int getItemCount() {
        return this.jsonArray.length();
    }

    public viewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        View itemView = LayoutInflater.from((Context)parent.getContext()).inflate(2131493220, parent, false);
        return new viewHolder(itemView);
    }

    public class viewHolder
    extends RecyclerView.ViewHolder {
        TextView text1;
        TextView text2;
        TextView text3;
        TextView text4;
        ImageView moreImage;
        ImageView newIcon;

        public viewHolder(View itemView) {
            super(itemView);
            this.text1 = (TextView)itemView.findViewById(2131297494);
            this.text2 = (TextView)itemView.findViewById(2131297495);
            this.text3 = (TextView)itemView.findViewById(2131297497);
            this.text4 = (TextView)itemView.findViewById(2131297496);
            this.newIcon = (ImageView)itemView.findViewById(2131297081);
            this.newIcon.setVisibility(8);
            this.moreImage = (ImageView)itemView.findViewById(2131297034);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    TicketHistoryAdapter.this.itemClickListener.itemClicked(viewHolder.this.getAdapterPosition());
                }
            });
            this.moreImage.setVisibility(8);
        }
    }
}

