/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.service.sql;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import com.android.volley.RequestQueue;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONUtils;
import com.b2lmobitech.fieldcloudplus.service.sql.DbSection;
import com.b2lmobitech.fieldcloudplus.service.sql.SqliteHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ServiceDatabase {
    private static ServiceDatabase mInstance;
    private RequestQueue mRequestQueue;
    private static Context mContext;
    private static SqliteHelper sqliteHelper;

    private ServiceDatabase(Context context) {
        mContext = context;
        sqliteHelper = new SqliteHelper(context);
    }

    public static synchronized ServiceDatabase getInstance(Context context) {
        if (mInstance == null) {
            mInstance = new ServiceDatabase(context);
        }
        ServiceDatabase.createTables();
        return mInstance;
    }

    public static void createTables() {
        SQLiteDatabase db = sqliteHelper.getWritableDatabase();
        try {
            db.execSQL("CREATE TABLE  IF NOT EXISTS questions(_id INTEGER PRIMARY KEY,subcategory TEXT,Id TEXT,questionnumber TEXT,typeofquestion TEXT,category TEXT,question TEXT,count TEXT,optionforanswers TEXT,correctanswer TEXT,dateandtime TEXT,deleted TEXT,questionmode TEXT,question_required TEXT,customertype TEXT,combinationname TEXT,update_datetime TEXT,form_id TEXT,CONSTRAINT question_unique UNIQUE (Id));");
            db.execSQL("CREATE TABLE  IF NOT EXISTS qsubcat(_id INTEGER PRIMARY KEY,subcategory TEXT,id TEXT,category TEXT,details TEXT,CONSTRAINT product_unique UNIQUE (id));");
            db.execSQL("CREATE TABLE  IF NOT EXISTS qcat(_id INTEGER PRIMARY KEY,category TEXT,id TEXT,details TEXT,CONSTRAINT cat_unique UNIQUE (id));");
            db.execSQL("CREATE TABLE  IF NOT EXISTS flexible_form_questions(_id INTEGER PRIMARY KEY,id TEXT,form_id TEXT,section_id TEXT,question_id TEXT,question_order TEXT,question_image TEXT,question_requirement TEXT,question_text TEXT,answer_type TEXT,correct_answer TEXT,delete_status TEXT,CONSTRAINT question_unique UNIQUE (id));");
            db.execSQL("CREATE TABLE  IF NOT EXISTS flexible_form_sections(_id INTEGER PRIMARY KEY,id TEXT,form_id TEXT,section_id TEXT,section_name TEXT,section_description TEXT,delete_status TEXT,CONSTRAINT question_unique UNIQUE (id));");
            db.execSQL("CREATE TABLE  IF NOT EXISTS flexible_form_options(_id INTEGER PRIMARY KEY,id TEXT,form_id TEXT,question_id TEXT,option_id TEXT,option_text TEXT,option_type TEXT,delete_status TEXT,CONSTRAINT question_unique UNIQUE (id));");
            db.execSQL("CREATE TABLE  IF NOT EXISTS flexible_form_responses(_id INTEGER PRIMARY KEY,id TEXT,form_id TEXT,question_id TEXT,option_text TEXT,row_index TEXT,assignment_id TEXT,category TEXT,issue TEXT,lat TEXT,lon TEXT,location TEXT,preview TEXT,sync TEXT,delete_status TEXT,CONSTRAINT question_unique UNIQUE (id));");
            db.execSQL("CREATE TABLE  IF NOT EXISTS flexible_form_responses_data(_id INTEGER PRIMARY KEY,id TEXT,form_id TEXT,question_id TEXT,option_text TEXT,row_index TEXT,assignment_id TEXT,issue TEXT,delete_status TEXT,CONSTRAINT question_unique UNIQUE (id));");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void insertIntoTable(JSONArray jsonArray, String Table) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject jsonObject = jsonArray.getJSONObject(i);
            ContentValues cv = JSONUtils.jsonToValues(jsonObject);
            sdb.insertWithOnConflict(Table, null, cv, 5);
        }
        sdb.close();
    }

    public void insertIntoTable(JSONObject jsonObject, String Table) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        ContentValues cv = JSONUtils.jsonToValues(jsonObject);
        sdb.insertWithOnConflict(Table, null, cv, 5);
        sdb.close();
    }

    public JSONArray getPreventive() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM scheduleassign INNER JOIN facility ON Id=facilityid WHERE status!='completed' GROUP BY atmid,assigndate ORDER BY assigndate DESC";
        Cursor cursor = sdb.rawQuery(query, null);
        return JSONUtils.cursorToArray(cursor);
    }

    public JSONArray getTickets() {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM tickets ORDER BY assigneddateandtime DESC";
        Cursor cursor = sdb.rawQuery(query, null);
        return JSONUtils.cursorToArray(cursor);
    }

    public JSONObject getTicketInfo(String ticket) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM tickets WHERE ticketnumber='" + ticket + "'", null);
        if (cursor != null && cursor.moveToFirst()) {
            return JSONUtils.cursorToJson(cursor);
        }
        return null;
    }

    public String getCategoryName(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM cat WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("category_name"));
            }
            cursor.close();
        }
        return "";
    }

    public String getQCatName(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM qcat WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("category"));
            }
            cursor.close();
        }
        return "";
    }

    public String getQSubCatName(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM qsubcat WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("subcategory"));
            }
            cursor.close();
        }
        return "General";
    }

    public String getServiceTypeName(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM type WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("service_type"));
            }
            cursor.close();
        }
        return "";
    }

    public String getSerialNumber(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM serialnumber WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("serialnumber"));
            }
            cursor.close();
        }
        return "";
    }

    public String getModel(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM model WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("model"));
            }
            cursor.close();
        }
        return "";
    }

    public String getCustomerMobile(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM facility WHERE Id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("atmphonenumber"));
            }
            cursor.close();
        }
        return "";
    }

    public String getProduct(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM product WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("product"));
            }
            cursor.close();
        }
        return "";
    }

    public String getBrand(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM brand WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("brand"));
            }
            cursor.close();
        }
        return "";
    }

    public String getSubCategoryName(String id2) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM qsubcat WHERE id='" + id2 + "'", null);
        if (cursor != null) {
            if (cursor.getCount() > 0) {
                cursor.moveToFirst();
                return cursor.getString(cursor.getColumnIndex("subcategory"));
            }
            cursor.close();
        }
        return "General";
    }

    public JSONArray getCombinations(String facility, String date) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM scheduleassign INNER JOIN combination ON combinationid=ID WHERE assigndate='" + date + "' AND " + "facilityid" + "='" + facility + "' AND " + "status" + "!='completed'  GROUP BY " + "combinationid";
        Cursor cursor = sdb.rawQuery(query, null);
        return JSONUtils.cursorToArray(cursor);
    }

    public JSONArray getQuestionsCategory(String assignId) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT *,(CASE WHEN (flexible_form_responses.question_id IS NULL OR flexible_form_responses.sync='0') THEN 'false' ELSE 'true' END) AS isCompleted,(CASE WHEN flexible_form_responses.sync='0' THEN 'true' ELSE 'false' END) AS inOffline FROM combination INNER JOIN questions ON questions.combinationname=combination.ID LEFT JOIN scheduleassign ON combinationid=combination.ID LEFT JOIN flexible_form_responses ON flexible_form_responses.assignment_id=scheduleassign.assignschedule_id AND preview='0' AND flexible_form_responses.category=questions.category WHERE scheduleassign.assignschedule_id='" + assignId + "' GROUP BY questions." + "category";
        Cursor cursor = sdb.rawQuery(query, null);
        return JSONUtils.cursorToArray(cursor);
    }

    public JSONArray getSubCategories(String facility, String date, String cat, String assignid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM combination INNER JOIN questions ON questions.combinationname=combination.ID INNER JOIN scheduleassign ON combinationid=combination.ID WHERE assigndate='" + date + "' AND " + "facilityid" + "='" + facility + "' AND " + "category" + "='" + cat + "' AND " + "assignschedule_id" + "='" + assignid + "'  GROUP BY " + "subcategory";
        Cursor cursor = sdb.rawQuery(query, null);
        return JSONUtils.cursorToArray(cursor);
    }

    public List<DbSection> getSections(String formId) {
        ArrayList<DbSection> sections = new ArrayList<DbSection>();
        SQLiteDatabase db = sqliteHelper.getReadableDatabase();
        String query = "SELECT section_id, section_name FROM flexible_form_sections WHERE form_id = ?";
        Cursor cursor = db.rawQuery(query, new String[]{formId});
        if (cursor != null) {
            while (cursor.moveToNext()) {
                String id2 = cursor.getString(cursor.getColumnIndexOrThrow("section_id"));
                String name = cursor.getString(cursor.getColumnIndexOrThrow("section_name"));
                sections.add(new DbSection(id2, name));
            }
            cursor.close();
        }
        return sections;
    }

    public JSONArray getQuestions(String facility, String date, String cat, String assignid, @Nullable String sectionId) {
        String[] args;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String baseQuery = "SELECT fq.* FROM combination c  INNER JOIN questions q ON q.combinationname = c.ID INNER JOIN scheduleassign a ON a.combinationid = c.ID INNER JOIN flexible_form_questions fq ON fq.form_id = q.form_id WHERE a.assigndate = ? AND a.facilityid = ? AND q.category = ? AND a.assignschedule_id = ?";
        if (sectionId != null) {
            baseQuery = baseQuery + " AND fq.section_id = ?";
            args = new String[]{date, facility, cat, assignid, sectionId};
        } else {
            args = new String[]{date, facility, cat, assignid};
        }
        Cursor cursor = sdb.rawQuery(baseQuery, args);
        JSONArray result = JSONUtils.cursorToArray(cursor);
        cursor.close();
        return result;
    }

    public JSONObject getAnswers(String assignid, String cat, String subcat) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM answers WHERE assignschedule_id='" + assignid + "' AND " + "category" + "='" + cat + "' AND " + "subcategory" + "='" + subcat + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        JSONObject jsonObject = new JSONObject();
        if (cursor.moveToFirst()) {
            do {
                try {
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject1.put("answer", (Object)cursor.getString(cursor.getColumnIndex("answer")));
                    jsonObject1.put("issue", (Object)cursor.getString(cursor.getColumnIndex("issue")));
                    jsonObject1.put("remarks", (Object)cursor.getString(cursor.getColumnIndex("remarks")));
                    jsonObject.put(cursor.getString(cursor.getColumnIndex("questionnumber")), (Object)jsonObject1);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } while (cursor.moveToNext());
        }
        return jsonObject;
    }

    public JSONArray getOptions(String facility, String date, String cat, String assignid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String baseQuery = "SELECT fo.* FROM combination c  INNER JOIN questions q ON q.combinationname = c.ID INNER JOIN scheduleassign a ON a.combinationid = c.ID INNER JOIN flexible_form_options fo ON fo.form_id = q.form_id WHERE a.assigndate = ? AND a.facilityid = ? AND q.category = ? AND a.assignschedule_id = ?";
        String[] args = new String[]{date, facility, cat, assignid};
        Cursor cursor = sdb.rawQuery(baseQuery, args);
        JSONArray result = JSONUtils.cursorToArray(cursor);
        cursor.close();
        return result;
    }

    public JSONObject getAnswers(String assignId, String catId) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM flexible_form_responses WHERE assignment_id='" + assignId + "' AND " + "category" + "='" + catId + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (cursor.moveToFirst()) {
            jsonObject.put("assign", (Object)cursor.getString(cursor.getColumnIndex("assignment_id")));
            jsonObject.put("lat", (Object)cursor.getString(cursor.getColumnIndex("lat")));
            jsonObject.put("lon", (Object)cursor.getString(cursor.getColumnIndex("lon")));
            jsonObject.put("location", (Object)cursor.getString(cursor.getColumnIndex("location")));
            jsonObject.put("cat", (Object)cursor.getString(cursor.getColumnIndex("category")));
            jsonObject.put("facility", (Object)cursor.getString(cursor.getColumnIndex("facilityid")));
            jsonObject.put("datetime", (Object)cursor.getString(cursor.getColumnIndex("datetime")));
        }
        if (cursor.moveToFirst()) {
            do {
                try {
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject1.put("question_id", (Object)cursor.getString(cursor.getColumnIndex("question_id")));
                    jsonObject1.put("answer", (Object)cursor.getString(cursor.getColumnIndex("option_text")));
                    jsonObject1.put("issue", (Object)cursor.getString(cursor.getColumnIndex("issue")));
                    jsonObject1.put("form_id", (Object)cursor.getString(cursor.getColumnIndex("form_id")));
                    jsonObject1.put("row_index", (Object)cursor.getString(cursor.getColumnIndex("row_index")));
                    jsonObject1.put("delete_status", (Object)cursor.getString(cursor.getColumnIndex("delete_status")));
                    jsonObject1.put("remarks", (Object)cursor.getString(cursor.getColumnIndex("remarks")));
                    jsonArray.put((Object)jsonObject1);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } while (cursor.moveToNext());
        }
        jsonObject.put("list", (Object)jsonArray);
        return jsonObject;
    }

    public List<JSONObject> getAnswersList(String assignId, String catId) throws JSONException {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "SELECT * FROM flexible_form_responses fr INNER JOIN flexible_form_questions fq ON fr.form_id = fq.form_id AND fr.question_id = fq.question_id WHERE assignment_id='" + assignId + "' AND " + "category" + "='" + catId + "'";
        Cursor cursor = sdb.rawQuery(query, null);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        if (cursor.moveToFirst()) {
            jsonObject.put("assign", (Object)cursor.getString(cursor.getColumnIndex("assignment_id")));
        }
        if (cursor.moveToFirst()) {
            do {
                try {
                    JSONObject jsonObject1 = new JSONObject();
                    jsonObject1.put("form_id", (Object)cursor.getString(cursor.getColumnIndex("form_id")));
                    jsonObject1.put("answer", (Object)cursor.getString(cursor.getColumnIndex("option_text")));
                    jsonObject1.put("issue", (Object)cursor.getString(cursor.getColumnIndex("issue")));
                    jsonObject1.put("question_id", (Object)cursor.getString(cursor.getColumnIndex("question_id")));
                    jsonObject1.put("delete_status", (Object)cursor.getString(cursor.getColumnIndex("delete_status")));
                    String rowIndexValue = cursor.getString(cursor.getColumnIndex("row_index"));
                    if (rowIndexValue == null || rowIndexValue.isEmpty()) {
                        rowIndexValue = String.valueOf(0);
                    }
                    jsonObject1.put("row_index", (Object)rowIndexValue);
                    if (cursor.getString(cursor.getColumnIndex("answer_type")).equals("image")) {
                        JSONObject jsonObject2 = new JSONObject(jsonObject.toString());
                        JSONArray jsonArray1 = new JSONArray();
                        jsonArray1.put((Object)jsonObject1);
                        jsonObject2.put("list", (Object)jsonArray1);
                        list.add(jsonObject2);
                        continue;
                    }
                    jsonArray.put((Object)jsonObject1);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            } while (cursor.moveToNext());
        }
        if (jsonArray.length() != 0) {
            jsonObject.put("list", (Object)jsonArray);
            list.add(jsonObject);
        }
        return list;
    }

    public int getLastNumberPart(String questionId, String prefix, String suffix) {
        SQLiteDatabase db = sqliteHelper.getReadableDatabase();
        int lastNumber = 0;
        Cursor cursor = db.rawQuery("SELECT option_text FROM flexible_form_responses_data WHERE question_id = ? ORDER BY id DESC LIMIT 1", new String[]{questionId});
        if (cursor.moveToFirst()) {
            String optionText = cursor.getString(0);
            try {
                String numberPart = optionText;
                if (numberPart.startsWith(prefix)) {
                    numberPart = numberPart.substring(prefix.length());
                }
                if (numberPart.endsWith(suffix)) {
                    numberPart = numberPart.substring(0, numberPart.length() - suffix.length());
                }
                if (!numberPart.isEmpty()) {
                    lastNumber = Integer.parseInt(numberPart);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cursor.close();
        return lastNumber;
    }

    public void deleteAddress(String questionId) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        String query = "DELETE FROM flexible_form_responses WHERE question_id ='" + questionId + "'";
        sdb.execSQL(query);
    }

    public boolean checkAllCategoriesCompleted(String assignId) {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM combination INNER JOIN questions ON questions.combinationname=combination.ID LEFT JOIN scheduleassign ON combinationid=combination.ID LEFT JOIN flexible_form_responses ON flexible_form_responses.assignment_id=scheduleassign.assignschedule_id AND preview='0' AND flexible_form_responses.category=questions.category WHERE scheduleassign.assignschedule_id='" + assignId + "' AND flexible_form_responses.question_id IS NULL GROUP BY questions." + "category", null);
        return cursor == null || cursor.getCount() == 0;
    }

    public String getUnSyncedCategory(String assignId) throws JSONException {
        String query;
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        Cursor cursor = sdb.rawQuery(query = "SELECT * FROM flexible_form_responses WHERE assignment_id='" + assignId + "' AND " + "sync" + "='0'  GROUP BY " + "category" + " LIMIT 1", null);
        if (cursor != null && cursor.getCount() != 0) {
            cursor.moveToFirst();
            return cursor.getString(cursor.getColumnIndex("category"));
        }
        return null;
    }

    public void updateSynced(String assignId, String catid) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("sync", "1");
        sdb.update("flexible_form_responses", cv, "assignment_id = ? AND category= ?", new String[]{assignId, catid});
    }

    public void deleteAll() {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        sdb.delete("answers", "", new String[0]);
        sdb.delete("questions", "", new String[0]);
        sdb.delete("qcat", "", new String[0]);
        sdb.delete("qsubcat", "", new String[0]);
        sdb.delete("scheduleassign", "", new String[0]);
    }

    public void deleteResponses(String assignId, String formId) {
        SQLiteDatabase sdb = sqliteHelper.getWritableDatabase();
        String query = "DELETE FROM flexible_form_responses WHERE assignment_id = '" + assignId + "' AND " + "form_id" + " = '" + formId + "'";
        sdb.execSQL(query);
    }

    public void updateCompleted(String assignId) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("status", "completed");
        sdb.update("scheduleassign", cv, "assignschedule_id=?", new String[]{assignId});
    }

    public void updateStarted(String assignId) {
        SQLiteDatabase sdb = sqliteHelper.getReadableDatabase();
        ContentValues cv = new ContentValues();
        cv.put("status", "underprogress");
        sdb.update("scheduleassign", cv, "assignschedule_id=?", new String[]{assignId});
    }
}

