/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.serviceold;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.os.Bundle;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.appcompat.widget.Toolbar;
import com.b2lmobitech.fieldcloudplus.others.utils.JSONParser;
import com.b2lmobitech.fieldcloudplus.others.utils.classes.globalvariables;
import com.b2lmobitech.fieldcloudplus.serviceold.adapterclass.issueslistadapter;
import com.b2lmobitech.fieldcloudplus.serviceold.ticketworkreport;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TicketList
extends AppCompatActivity {
    private Context mycontext;
    String registeredcompany;
    String registeredemailid;
    String[] ticketnumber;
    String[] customername;
    String[] facility;
    String[] emailid;
    String[] question;
    String[] answer;
    String[] latitude;
    String[] longitude;
    String[] location;
    String[] questionmode;
    String[] questiontype;
    String[] combinationname;
    String[] typename;
    ListView issueslistview;
    String ticketstatus = "";
    private ProgressDialog pDialog;
    JSONArray tickets = null;
    JSONParser jsonParser = new JSONParser();
    private static final String ALL_TICKET_URL = "http://fieldcloud.in/App/get_ticketsdetails.php";
    private static final String TICKET_SUCCESS = "success";
    private static final String TICKET_MESSAGE = "message";
    JSONArray products = null;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492952);
        this.mycontext = this;
        globalvariables.Logoutsharedpreference = this.getSharedPreferences(globalvariables.LOGOUT_CHECKING, 0);
        this.registeredcompany = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_companyname, "");
        this.registeredemailid = globalvariables.Logoutsharedpreference.getString(globalvariables.logout_emailid, "");
        Intent intent = this.getIntent();
        this.ticketstatus = intent.getStringExtra("ticketstatus");
        this.issueslistview = (ListView)this.findViewById(2131296906);
        if (this.isNetworkAvailable()) {
            new GetTicketsDetail().execute(new String[0]);
        } else {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder(this.mycontext);
            alertdialog.setTitle((CharSequence)"No Internet Connection");
            alertdialog.setIcon(2131230915);
            alertdialog.setMessage((CharSequence)"Try Again!!");
            alertdialog.setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    TicketList.this.finish();
                }
            }).create();
            alertdialog.show();
        }
        Toolbar toolbar = (Toolbar)this.findViewById(2131297581);
        this.setSupportActionBar(toolbar);
        this.getSupportActionBar().setTitle((CharSequence)(this.ticketstatus + " Ticket"));
    }

    public boolean isNetworkAvailable() {
        ConnectivityManager cm = (ConnectivityManager)this.mycontext.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        if (networkInfo != null && networkInfo.isConnected()) {
            if (cm.getNetworkInfo(1).isConnectedOrConnecting()) {
                // empty if block
            }
            return true;
        }
        return false;
    }

    class GetTicketsDetail
    extends AsyncTask<String, String, String> {
        GetTicketsDetail() {
        }

        protected void onPreExecute() {
            super.onPreExecute();
            TicketList.this.pDialog = new ProgressDialog((Context)TicketList.this);
            TicketList.this.pDialog.setMessage((CharSequence)"Loading...");
            TicketList.this.pDialog.setIndeterminate(false);
            TicketList.this.pDialog.setCancelable(false);
            TicketList.this.pDialog.show();
        }

        protected String doInBackground(String ... args) {
            Date date = new Date();
            Calendar c = Calendar.getInstance();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
            String todaydate = df1.format(c.getTime());
            try {
                ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
                params.add((NameValuePair)new BasicNameValuePair("companyname", TicketList.this.registeredcompany));
                params.add((NameValuePair)new BasicNameValuePair("date", todaydate));
                params.add((NameValuePair)new BasicNameValuePair("ticketstatus", TicketList.this.ticketstatus));
                JSONObject json = TicketList.this.jsonParser.makeHttpRequest(TicketList.ALL_TICKET_URL, "GET", params);
                int success = json.getInt(TicketList.TICKET_SUCCESS);
                if (success == 1) {
                    TicketList.this.tickets = json.getJSONArray("tickets");
                    int count = TicketList.this.tickets.length();
                    if (count >= 1) {
                        TicketList.this.ticketnumber = new String[count];
                        TicketList.this.customername = new String[count];
                        TicketList.this.facility = new String[count];
                        TicketList.this.emailid = new String[count];
                        TicketList.this.question = new String[count];
                        TicketList.this.answer = new String[count];
                        TicketList.this.latitude = new String[count];
                        TicketList.this.longitude = new String[count];
                        TicketList.this.location = new String[count];
                        TicketList.this.questionmode = new String[count];
                        TicketList.this.questiontype = new String[count];
                        TicketList.this.combinationname = new String[count];
                        TicketList.this.typename = new String[count];
                        for (int i = 0; i < count; ++i) {
                            JSONObject photoobj = TicketList.this.tickets.getJSONObject(i);
                            TicketList.this.ticketnumber[i] = photoobj.getString("ticketnumber");
                            TicketList.this.customername[i] = photoobj.getString("customername");
                            TicketList.this.facility[i] = photoobj.getString("atmid");
                            TicketList.this.emailid[i] = photoobj.getString("emailid");
                            TicketList.this.question[i] = photoobj.getString("question");
                            TicketList.this.answer[i] = photoobj.getString("answer");
                            TicketList.this.latitude[i] = photoobj.getString("latitude");
                            TicketList.this.longitude[i] = photoobj.getString("longitude");
                            TicketList.this.location[i] = photoobj.getString("location");
                            TicketList.this.questionmode[i] = photoobj.getString("questionmode");
                            TicketList.this.questiontype[i] = photoobj.getString("questiontype");
                            TicketList.this.combinationname[i] = photoobj.getString("combinationname");
                            TicketList.this.typename[i] = photoobj.getString("typename");
                        }
                    }
                    return json.getString(TicketList.TICKET_MESSAGE);
                }
                if (success == 0) {
                    return json.getString(TicketList.TICKET_MESSAGE);
                }
                if (success == 2) {
                    return json.getString(TicketList.TICKET_MESSAGE);
                }
                String error = "no success";
                return error;
            }
            catch (JSONException e) {
                e.printStackTrace();
                String error = "php error";
                return error;
            }
        }

        protected void onPostExecute(String file_url) {
            TicketList.this.pDialog.dismiss();
            if (TicketList.this.ticketnumber == null) {
                Toast.makeText((Context)TicketList.this.getApplicationContext(), (CharSequence)"Empty List", (int)0).show();
            } else {
                issueslistadapter adapter2 = new issueslistadapter((Activity)TicketList.this, TicketList.this.ticketnumber, TicketList.this.customername, TicketList.this.facility, TicketList.this.emailid, TicketList.this.question, TicketList.this.answer, TicketList.this.location, TicketList.this.questionmode, TicketList.this.questiontype, TicketList.this.combinationname, TicketList.this.typename, "Ticket");
                TicketList.this.issueslistview.setAdapter((ListAdapter)adapter2);
                TicketList.this.issueslistview.setOnItemClickListener(new AdapterView.OnItemClickListener(){

                    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
                        if (TicketList.this.ticketstatus.equalsIgnoreCase("complete") || TicketList.this.ticketstatus.equalsIgnoreCase("incomplete")) {
                            Date date = new Date();
                            Calendar c = Calendar.getInstance();
                            SimpleDateFormat df1 = new SimpleDateFormat("yyyy-MM-dd");
                            String todaydate = df1.format(c.getTime());
                            Intent intent = new Intent(TicketList.this.mycontext, ticketworkreport.class);
                            Bundle extras = new Bundle();
                            extras.putString("date", todaydate);
                            extras.putString("ticket", TicketList.this.ticketnumber[position]);
                            extras.putString("emailid", TicketList.this.emailid[position]);
                            intent.putExtras(extras);
                            TicketList.this.mycontext.startActivity(intent);
                        } else {
                            Toast.makeText((Context)TicketList.this.getApplicationContext(), (CharSequence)"not completed", (int)0).show();
                        }
                    }
                });
            }
        }
    }
}

