/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationManager;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Environment;
import android.util.Base64;
import android.util.Log;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.ActivityCompat;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.service.GPSTracker;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.tasks.OnSuccessListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Utility {
    public static final int MEDIA_TYPE_IMAGE = 1;
    public static GoogleApiClient mGoogleApiClient;
    public static Location mLastLocation;
    public static LocationRequest mLocationRequest;

    public static File getCapturedImageFile() {
        File mediaFile = null;
        File mediaStorageDir = new File(Environment.getExternalStorageDirectory() + "/Rover");
        if (!mediaStorageDir.exists() && !mediaStorageDir.mkdirs()) {
            return null;
        }
        mediaFile = new File(mediaStorageDir.getPath() + File.separator + "IMG_" + System.currentTimeMillis() + ".jpg");
        try {
            mediaFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return mediaFile;
    }

    public static Bitmap bitmap(String str) {
        byte[] decodedBytes = Base64.decode((String)str, (int)0);
        return BitmapFactory.decodeByteArray((byte[])decodedBytes, (int)0, (int)decodedBytes.length);
    }

    public static Bitmap processImage(Bitmap bitmap) {
        float s43;
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        float x = (float)bitmap.getHeight() / (float)bitmap.getWidth();
        bitmap = x == (s43 = 1.3333334f) ? Bitmap.createScaledBitmap((Bitmap)bitmap, (int)360, (int)480, (boolean)true) : Bitmap.createScaledBitmap((Bitmap)bitmap, (int)360, (int)640, (boolean)true);
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        if (byteArray.length > 160000) {
            bitmap.compress(Bitmap.CompressFormat.JPEG, 90, (OutputStream)stream);
        }
        Log.e((String)"IamgeSize", (String)(byteArray.length + " b"));
        return bitmap;
    }

    public static byte[] getBytes(Bitmap bitmap) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
        return stream.toByteArray();
    }

    public static String getString(byte[] image) {
        String imgstring = Base64.encodeToString((byte[])image, (int)0);
        return imgstring;
    }

    public static String bitmap2string(Bitmap bm) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)stream);
        byte[] byteArray = stream.toByteArray();
        return Base64.encodeToString((byte[])byteArray, (int)0);
    }

    public static String getCurrentTime() {
        return new SimpleDateFormat("HH:mm:ss").format(new Date().getTime());
    }

    public static String getCurrentDate() {
        return new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime());
    }

    public static String getCurrentDateTime() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date().getTime());
    }

    public static String getDateTime(Date date) {
        return new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
    }

    public static Date getDateTime(String str) throws ParseException {
        return new SimpleDateFormat("yyyy-MM-dd").parse(str);
    }

    public static Date getDateOnly(Date date) throws ParseException {
        String dd = new SimpleDateFormat("yyyy-MM-dd").format(date.getTime());
        return new SimpleDateFormat("yyyy-MM-dd").parse(dd);
    }

    public static Date currentDate() {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").parse(new SimpleDateFormat("yyyy-MM-dd").format(new Date().getTime()));
        }
        catch (ParseException e) {
            e.printStackTrace();
            return new Date();
        }
    }

    public static long days(Date firstdate) {
        long diif = firstdate.getTime() - Utility.currentDate().getTime();
        return diif / 86400000L;
    }

    public static int daysbetween(Date firstdate) {
        long diif = firstdate.getTime() - Utility.currentDate().getTime();
        return (int)(diif / 86400000L);
    }

    public static int daysbetween(Date firstdate, Date seconddate) {
        long diif = firstdate.getTime() - seconddate.getTime();
        return (int)(diif / 86400000L);
    }

    public static boolean isNetworkAvailable(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        NetworkInfo networkInfo = cm.getActiveNetworkInfo();
        return networkInfo != null && networkInfo.isConnected();
    }

    public static LatLang getBestLcoation(Context context) {
        LatLang latLang = new LatLang();
        Location gpsLocation = null;
        Location networkLocation = null;
        Location passivelocation = null;
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
            String context2 = "location";
            LocationManager locationManager = (LocationManager)context.getSystemService(context2);
            String gpsProvider = "gps";
            String networkProvider = "network";
            String passiveProvider = "passive";
            if (locationManager.isProviderEnabled(gpsProvider)) {
                gpsLocation = locationManager.getLastKnownLocation(gpsProvider);
            }
            if (locationManager.isProviderEnabled(networkProvider)) {
                networkLocation = locationManager.getLastKnownLocation(networkProvider);
            }
            if (locationManager.isProviderEnabled(passiveProvider)) {
                passivelocation = locationManager.getLastKnownLocation(passiveProvider);
            }
        } else {
            Toast.makeText((Context)context, (CharSequence)"No Location Permisiion", (int)0).show();
        }
        if (gpsLocation != null) {
            double latdouble = gpsLocation.getLatitude();
            double londouble = gpsLocation.getLongitude();
            latLang.setLatitude(String.valueOf(latdouble));
            latLang.setLongitude(String.valueOf(londouble));
            Log.e((String)"gps", (String)(String.valueOf(latdouble) + "," + String.valueOf(londouble)));
        }
        if (networkLocation != null) {
            double latdouble = networkLocation.getLatitude();
            double londouble = networkLocation.getLongitude();
            latLang.setLatitude(String.valueOf(latdouble));
            latLang.setLongitude(String.valueOf(londouble));
            Log.e((String)"metwork", (String)(String.valueOf(latdouble) + "," + String.valueOf(londouble)));
        }
        if (passivelocation != null) {
            double latdouble = passivelocation.getLatitude();
            double londouble = passivelocation.getLongitude();
            latLang.setLatitude(String.valueOf(latdouble));
            latLang.setLongitude(String.valueOf(londouble));
            Log.e((String)"passive", (String)(String.valueOf(latdouble) + "," + String.valueOf(londouble)));
        }
        return latLang;
    }

    public static LatLang getLocation(Context context) {
        LatLang latLang = new LatLang();
        GPSTracker gpsTracker = new GPSTracker(context);
        latLang.setLatitude(String.valueOf(gpsTracker.getLatitude()));
        latLang.setLongitude(String.valueOf(gpsTracker.getLongitude()));
        Log.e((String)"location", (String)(latLang.getLatitude() + "," + latLang.getLongitude()));
        gpsTracker.stopUsingGPS();
        return latLang;
    }

    public static LatLang getLcoation(Context context) {
        LatLang latLang = new LatLang();
        mGoogleApiClient = new GoogleApiClient.Builder(context).addConnectionCallbacks(new GoogleApiClient.ConnectionCallbacks(){

            public void onConnected(@Nullable Bundle bundle) {
            }

            public void onConnectionSuspended(int i) {
            }
        }).addOnConnectionFailedListener(new GoogleApiClient.OnConnectionFailedListener(){

            public void onConnectionFailed(@NonNull ConnectionResult connectionResult) {
            }
        }).addApi(LocationServices.API).build();
        mGoogleApiClient.connect();
        if (ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") != 0 && ActivityCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_COARSE_LOCATION") != 0) {
            return latLang;
        }
        LocationServices.getFusedLocationProviderClient((Context)context).getLastLocation().addOnSuccessListener((Activity)context, (OnSuccessListener)new OnSuccessListener<Location>(){

            public void onSuccess(Location location) {
                if (location != null) {
                    location = mLastLocation;
                }
            }
        });
        if (mLastLocation != null) {
            latLang.setLatitude(mLastLocation.getLatitude() + "");
            latLang.setLatitude(mLastLocation.getLatitude() + "");
        }
        return latLang;
    }
}

