/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Toast;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddTaskListActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.AllTasksAdapter;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.listener.AcceptTaskListener;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.google.android.material.snackbar.Snackbar;
import com.google.android.material.tabs.TabLayout;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AllTasksActivity
extends AppCompatActivity
implements AcceptTaskListener {
    String tasklistd;
    RecyclerView recyclerView;
    TabLayout tabLayout;
    Database database;
    JSONArray jsonArray = new JSONArray();
    Snackbar snackbar;
    CoordinatorLayout coordinatorLayout;
    String projectId;
    MenuItem editTasklist;
    MenuItem deleteTasklist;
    final String TODAY = "Today";
    final String ACTIVE = "Active";
    final String LATE = "Late";
    final String NEW = "NEW";
    final String UPCOMING = "Upcoming";
    final String COMPLETED = "Completed";
    final String UNASSIGNED = "Unassigned";
    AllTasksAdapter allTasksAdapter;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492910);
        this.tasklistd = this.getIntent().getStringExtra("id");
        this.projectId = this.getIntent().getStringExtra("projectId");
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.tabLayout = (TabLayout)this.findViewById(2131297446);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296593);
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Today"), true);
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Active"));
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Late"));
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"NEW"));
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Upcoming"));
        this.tabLayout.addTab(this.tabLayout.newTab().setText((CharSequence)"Completed"));
        this.setListeners();
        this.getSupportActionBar().setTitle((CharSequence)"Tasks");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
    }

    protected void onResume() {
        super.onResume();
        this.database = Database.getInstance((Context)this);
        if (this.tasklistd == null || this.projectId == null) {
            Preference preference = Preference.getInstance((Context)this);
            this.tasklistd = preference.getTaskListId();
            this.projectId = preference.getProjectId();
        }
        if (MyRequestQueue.getInstance((Activity)this).isNoInternet()) {
            this.setAdapter(this.tabLayout.getTabAt(this.tabLayout.getSelectedTabPosition()).getText().toString());
        } else {
            this.getTasks();
        }
    }

    private void setListeners() {
        this.tabLayout.addOnTabSelectedListener(new TabLayout.OnTabSelectedListener(){

            public void onTabSelected(TabLayout.Tab tab) {
                AllTasksActivity.this.setAdapter(tab.getText().toString());
            }

            public void onTabUnselected(TabLayout.Tab tab) {
            }

            public void onTabReselected(TabLayout.Tab tab) {
            }
        });
        this.tabLayout.getTabAt(0).select();
    }

    private void setAdapter(JSONArray Array, String string2) {
        if (this.snackbar != null) {
            this.snackbar.dismiss();
        }
        if (Array.length() == 0) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"No Tasks Found", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    AllTasksActivity.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
        }
        Parcelable recyclerViewState = this.recyclerView.getLayoutManager().onSaveInstanceState();
        this.allTasksAdapter = new AllTasksAdapter((Context)this, Array, string2, Preference.getInstance((Context)this).isResponsible(this.projectId));
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.allTasksAdapter);
        try {
            this.recyclerView.getLayoutManager().onRestoreInstanceState(recyclerViewState);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void setAdapter(String string2) {
        Preference preference = Preference.getInstance((Context)this);
        String email = "";
        if (!preference.isResponsible(this.projectId)) {
            email = preference.getEmailId();
        }
        switch (string2) {
            case "Active": {
                this.setAdapter(this.database.getPendingTasks(this.tasklistd, email), "Active");
                break;
            }
            case "Today": {
                this.setAdapter(this.database.getTodayTasks(this.tasklistd, email), "Today");
                break;
            }
            case "Completed": {
                this.setAdapter(this.database.getCompletedTasks(this.tasklistd, email), "Completed");
                break;
            }
            case "Late": {
                this.setAdapter(this.database.getLateTasks(this.tasklistd, email), "Late");
                break;
            }
            case "NEW": {
                this.setAdapter(this.database.getNewTasks(this.tasklistd, email), "NEW");
                break;
            }
            case "Upcoming": {
                this.setAdapter(this.database.getUpcomingTasks(this.tasklistd, email), "Upcoming");
            }
        }
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
            case 2131296708: {
                if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) break;
                Intent intent = new Intent((Context)this, AddTaskListActivity.class);
                intent.putExtra("id", this.projectId);
                intent.putExtra("tasklistId", this.tasklistd);
                this.startActivity(intent);
                break;
            }
            case 2131296649: {
                this.showAlert();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558414, menu2);
        this.editTasklist = menu2.findItem(2131296708);
        this.deleteTasklist = menu2.findItem(2131296649);
        if (Preference.getInstance((Context)this).isResponsible(this.projectId)) {
            this.editTasklist.setVisible(true);
            this.deleteTasklist.setVisible(true);
        } else {
            this.editTasklist.setVisible(false);
            this.deleteTasklist.setVisible(false);
        }
        return true;
    }

    @Override
    public void acceptTask(String assignId) {
        if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) {
            return;
        }
        LocationManager locationManager = (LocationManager)this.getSystemService("location");
        boolean isGPSEnabled = locationManager.isProviderEnabled("gps");
        boolean isNetworkEnabled = locationManager.isProviderEnabled("network");
        if (!isGPSEnabled && !isNetworkEnabled) {
            AlertDialog.Builder alertdialog = new AlertDialog.Builder((Context)this);
            alertdialog.setTitle((CharSequence)"Access Location");
            alertdialog.setIcon(2131230915);
            alertdialog.setMessage((CharSequence)"No network provider is enabled for location access!!");
            alertdialog.setPositiveButton((CharSequence)"Turn On", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int whichButton) {
                    AllTasksActivity.this.startActivity(new Intent("android.settings.LOCATION_SOURCE_SETTINGS"));
                }
            });
            alertdialog.setNegativeButton((CharSequence)"Cancel", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                }
            }).create();
            alertdialog.show();
            return;
        }
        LatLang latLang = Utility.getLocation(this.getApplicationContext());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assign_id", assignId);
        params.put("datetime", DateUtils.getCurrentDateTime());
        params.put("latitude", latLang.getLatitude());
        params.put("longtitude", latLang.getLongitude());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_accept.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("s");
                    if (success == 1) {
                        AllTasksActivity.this.getTasks();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasks() {
        Preference preference = Preference.getInstance((Context)this);
        Database database = Database.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("id", this.tasklistd);
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        if (preference.getEmailId().equalsIgnoreCase(database.getProjectResponsible(this.projectId))) {
            params.put("responsible", "yes");
        } else {
            params.put("responsible", "no");
        }
        params.put("list", database.getTasksList(this.tasklistd, false).toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_tasks.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    AllTasksActivity.this.getTasks(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getTasks(JSONObject jsonObject) throws JSONException {
        JSONArray employeeArray = jsonObject.getJSONArray("employees");
        JSONArray taskArray = jsonObject.getJSONArray("tasks");
        JSONArray assignArray = jsonObject.getJSONArray("assigns");
        Database database = Database.getInstance((Context)this);
        try {
            database.insertEmplyoees(employeeArray);
            database.insertTasks(taskArray);
            database.insertAssigns(assignArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setAdapter(this.tabLayout.getTabAt(this.tabLayout.getSelectedTabPosition()).getText().toString());
    }

    private void deleteTasklist() {
        JSONObject jsonObject = new JSONObject();
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                jsonObject.put("role", (Object)"project");
            } else {
                jsonObject.put("role", (Object)"employee");
            }
            jsonObject.put("tasklist", (Object)this.tasklistd);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        params.put("data", jsonObject.toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/delete_tasklist.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Database.getInstance(AllTasksActivity.this.getApplicationContext()).deleteTasklist(AllTasksActivity.this.tasklistd);
                        Toast.makeText((Context)AllTasksActivity.this.getApplicationContext(), (CharSequence)"Tasklist Deleted", (int)0).show();
                        AllTasksActivity.this.finish();
                    } else {
                        Toast.makeText((Context)AllTasksActivity.this.getApplicationContext(), (CharSequence)"Unable to Deleted Tasklist ", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void showAlert() {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Tasklist Will be deleted").setPositiveButton((CharSequence)"CONTINUE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                AllTasksActivity.this.deleteTasklist();
            }
        }).setNegativeButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        }).show();
    }
}

