/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.os.Handler;
import android.os.Parcelable;
import android.preference.PreferenceManager;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.ProjectActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddProjectActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectCategoryActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectCompanyActivity;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.SelectTagActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.ProjectAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.service.ReminderReceiver;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.ProjectTable;
import com.google.android.material.snackbar.Snackbar;
import java.util.Calendar;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Dashboard
extends AppCompatActivity
implements OnItemClickListener {
    RecyclerView recyclerView;
    Snackbar snackbar;
    CoordinatorLayout coordinatorLayout;
    JSONArray jsonArray = new JSONArray();
    JSONObject jsonObject;
    boolean menuCreated = false;
    MenuItem newProject;
    MenuItem tags;
    MenuItem clients;
    MenuItem cats;
    JSONArray projectArray;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131493027);
        this.getSupportActionBar().setTitle((CharSequence)"Projects");
        this.recyclerView = (RecyclerView)this.findViewById(2131297203);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
        this.setDailyReminder();
    }

    protected void onResume() {
        super.onResume();
        if (MyRequestQueue.getInstance((Activity)this).isNoInternet()) {
            this.getProjectsOffline();
        } else if (Database.getInstance((Context)this).getProjects().length() == 0) {
            this.fetchAll();
        } else {
            this.getProjects();
        }
    }

    private void getProjects() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_projects.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    Dashboard.this.getProjects(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fetchAll() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/fetch_all.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    Dashboard.this.fetchAll(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fetchAll(JSONObject jsonObject) throws JSONException {
        JSONArray projectArray = jsonObject.getJSONArray("projects");
        JSONArray milestoneArray = jsonObject.getJSONArray("milestones");
        JSONArray tasklistArray = jsonObject.getJSONArray("tasklists");
        JSONArray clientArray = jsonObject.getJSONArray("clients");
        JSONArray categoriesArray = jsonObject.getJSONArray("categories");
        JSONArray tagsArray = jsonObject.getJSONArray("tags");
        JSONArray employeeArray = jsonObject.getJSONArray("employees");
        JSONArray taskArray = jsonObject.getJSONArray("tasks");
        JSONArray assignArray = jsonObject.getJSONArray("assigns");
        Database database = Database.getInstance((Context)this);
        try {
            database.insertProjects(projectArray);
            database.insertMilestones(milestoneArray);
            database.insertTaskLists(tasklistArray);
            database.insertAssigns(assignArray);
            database.insertTasks(taskArray);
            database.insertClients(clientArray);
            database.insertCategories(categoriesArray);
            database.insertTags(tagsArray);
            database.insertEmplyoees(employeeArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getProjectsOffline();
    }

    private void getProjects(JSONObject jsonObject) throws JSONException {
        JSONArray jsonArray = jsonObject.getJSONArray("projects");
        Database database = Database.getInstance((Context)this);
        database.deleteAllProjects();
        try {
            database.insertProjects(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getProjectsOffline();
    }

    private void getProjectsOffline() {
        Preference preference = Preference.getInstance((Context)this);
        Parcelable recyclerViewState = this.recyclerView.getLayoutManager().onSaveInstanceState();
        this.projectArray = Database.getInstance((Context)this).getProjects();
        ProjectAdapter projectAdapter = new ProjectAdapter((Context)this, this.projectArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)projectAdapter);
        this.recyclerView.getLayoutManager().onRestoreInstanceState(recyclerViewState);
        if (this.projectArray.length() == 0) {
            this.findViewById(2131296960).setVisibility(0);
            if (preference.isAdmin() || Database.getInstance((Context)this).isResponsibleForAnyProject(preference.getEmailId())) {
                this.findViewById(2131296355).setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        Intent intent = new Intent(Dashboard.this.getApplicationContext(), AddProjectActivity.class);
                        Dashboard.this.startActivity(intent);
                    }
                });
                this.findViewById(2131296355).setVisibility(0);
            } else {
                this.findViewById(2131296355).setVisibility(8);
            }
        } else {
            this.findViewById(2131296355).setVisibility(8);
            this.findViewById(2131296960).setVisibility(8);
        }
        this.checkforMenuCreated();
    }

    private void setDailyReminder() {
        try {
            SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this);
            if (!prefs.getBoolean("firstTime", false)) {
                Intent alarmIntent = new Intent((Context)this, ReminderReceiver.class);
                alarmIntent.putExtra("user", Preference.getInstance((Context)this).getEmailId());
                PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)this, (int)0, (Intent)alarmIntent, (int)0);
                AlarmManager manager = (AlarmManager)this.getSystemService("alarm");
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(System.currentTimeMillis());
                calendar.set(11, 6);
                calendar.set(12, 0);
                calendar.set(13, 1);
                manager.setRepeating(0, calendar.getTimeInMillis(), 86400000L, pendingIntent);
                SharedPreferences.Editor editor = prefs.edit();
                editor.putBoolean("firstTime", true);
                editor.apply();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558428, menu2);
        this.newProject = menu2.findItem(2131297083);
        this.tags = menu2.findItem(2131297464);
        this.cats = menu2.findItem(2131296499);
        this.clients = menu2.findItem(2131296534);
        this.newProject.setVisible(false);
        this.tags.setVisible(false);
        this.clients.setVisible(false);
        this.cats.setVisible(false);
        this.menuCreated = true;
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        switch (item.getItemId()) {
            case 2131297083: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, AddProjectActivity.class);
                this.startActivity(intent);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
            case 2131297464: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, SelectTagActivity.class);
                intent.putExtra("info", true);
                this.startActivity(intent);
                break;
            }
            case 2131296499: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, SelectCategoryActivity.class);
                intent.putExtra("info", true);
                this.startActivity(intent);
                break;
            }
            case 2131296534: {
                if (myRequestQueue.isNoNetwork()) break;
                Intent intent = new Intent((Context)this, SelectCompanyActivity.class);
                intent.putExtra("info", true);
                this.startActivity(intent);
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkforMenuCreated() {
        final Handler handler = new Handler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (Dashboard.this.menuCreated) {
                    handler.removeCallbacks((Runnable)this);
                    try {
                        Dashboard.this.manageActionBarIcons();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    handler.postDelayed((Runnable)this, 100L);
                }
            }
        };
        handler.removeCallbacks(runnable2);
        handler.postDelayed(runnable2, 100L);
    }

    private void manageActionBarIcons() {
        Preference preference = Preference.getInstance((Context)this);
        if (preference.isAdmin() || Database.getInstance((Context)this).isResponsibleForAnyProject(preference.getEmailId())) {
            this.newProject.setVisible(true);
            this.tags.setVisible(true);
            this.clients.setVisible(true);
            this.cats.setVisible(true);
        }
    }

    @Override
    public void itemClicked(int position) {
        try {
            Intent intent = new Intent(this.getApplicationContext(), ProjectActivity.class);
            JSONObject jsonObject = this.projectArray.getJSONObject(position);
            intent.putExtra("id", jsonObject.getString(ProjectTable.PROJECTID));
            intent.putExtra("name", jsonObject.getString(ProjectTable.PROJECTNAME));
            this.startActivity(intent);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }
}

