/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.listener.LocationUpdateListener;
import com.b2lmobitech.fieldcloudplus.task.others.LocationUpdate;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress;
import com.google.android.material.snackbar.Snackbar;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;

public class ExtendForm
extends AppCompatActivity {
    TextView projectName;
    TextView taskName;
    TextView milestoneName;
    TextView requestType;
    EditText requesetReason;
    EditText newDate;
    LinearLayout newDatelayout;
    int daysbetween;
    Calendar cal;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    String assignId;
    String taskId;
    String end;

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492993);
        this.getSupportActionBar().setTitle((CharSequence)"Extension Form");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.assignId = this.getIntent().getStringExtra("assignId");
        this.taskId = this.getIntent().getStringExtra("taskId");
        this.end = this.getIntent().getStringExtra("end");
        this.getWidgets();
        this.setListeners();
    }

    private void getWidgets() {
        this.projectName = (TextView)this.findViewById(2131297202);
        this.taskName = (TextView)this.findViewById(2131297476);
        this.milestoneName = (TextView)this.findViewById(2131297015);
        this.requestType = (TextView)this.findViewById(2131297268);
        this.requesetReason = (EditText)this.findViewById(2131297267);
        this.newDate = (EditText)this.findViewById(2131297089);
        this.newDatelayout = (LinearLayout)this.findViewById(2131297090);
        this.newDatelayout.setVisibility(0);
        this.newDate.setInputType(0);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
        this.newDate.performClick();
    }

    private void setValues() {
        this.requestType.setText((CharSequence)"Date");
    }

    private void setListeners() {
        DatePickerDialog.OnDateSetListener dpd = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                ExtendForm.this.cal = new GregorianCalendar(year, monthOfYear, dayOfMonth);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                ExtendForm.this.newDate.setText((CharSequence)df.format(ExtendForm.this.cal.getTime()));
                try {
                    ExtendForm.this.daysbetween = Utility.daysbetween(new Date(ExtendForm.this.cal.getTimeInMillis()), DateUtils.fromDate(ExtendForm.this.end));
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        };
        Calendar myCalendar = Calendar.getInstance();
        final DatePickerDialog dialog = new DatePickerDialog((Context)this, dpd, myCalendar.get(1), myCalendar.get(2), myCalendar.get(5));
        try {
            myCalendar.setTime(DateUtils.fromDate(this.end));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        myCalendar.add(5, 1);
        dialog.getDatePicker().setMinDate(myCalendar.getTimeInMillis());
        myCalendar.add(5, 98);
        dialog.getDatePicker().setMaxDate(myCalendar.getTimeInMillis());
        this.newDate.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.show();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (MyRequestQueue.getInstance((Activity)this).isNoNetwork() || !this.isValid()) break;
                this.requestLocationUpdate();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void requestLocationUpdate() {
        LocationUpdate locationUpdate = LocationUpdate.getInstance((Context)this);
        locationUpdate.connectLocation(new LocationUpdateListener(){

            @Override
            public void onLocationReceived(String latitude, String longtitude) {
                try {
                    ExtendForm.this.request(latitude, longtitude);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block0 : switch (requestCode) {
            case 1: {
                switch (resultCode) {
                    case -1: {
                        this.requestLocationUpdate();
                        break block0;
                    }
                    case 0: {
                        RequestProgress.getInstance((Activity)this).hideProgressBar();
                        break block0;
                    }
                }
            }
        }
    }

    private void request(String latitude, String longtitude) throws JSONException {
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("assignId", this.assignId);
        params.put("taskId", this.taskId);
        params.put("employeeId", preference.getEmailId());
        params.put("increasedays", this.daysbetween + "");
        params.put("latitude", latitude);
        params.put("longitude", longtitude);
        params.put("reason", this.requesetReason.getText().toString());
        params.put("datetime", Utility.getCurrentDateTime());
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/task_request.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("s");
                    if (success == 1) {
                        ExtendForm.this.finish();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private boolean isValid() {
        if (this.newDate.getText().toString().isEmpty()) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"Select date", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    ExtendForm.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return false;
        }
        if (this.requesetReason.getText().toString().isEmpty()) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"Provide reason", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    ExtendForm.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return false;
        }
        return true;
    }
}

