/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddMilestoneActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.MilestoneAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MilestoneActivity
extends AppCompatActivity {
    String projectid;
    RecyclerView recyclerView;
    MenuItem newMilestone;
    boolean menuCreated = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492964);
        this.projectid = this.getIntent().getStringExtra("id");
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Milestones");
        this.findViewById(2131296355).setVisibility(8);
        this.getMilestones();
    }

    protected void onResume() {
        super.onResume();
        if (MyRequestQueue.getInstance((Activity)this).isNoInternet()) {
            this.getMilestonesOffline();
        } else {
            this.getMilestones();
        }
        this.findViewById(2131296355).setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(MilestoneActivity.this.getApplicationContext(), AddMilestoneActivity.class);
                intent.putExtra("id", MilestoneActivity.this.projectid);
                MilestoneActivity.this.startActivity(intent);
            }
        });
    }

    private void getMilestones() {
        Preference preference = Preference.getInstance((Context)this);
        Database database = Database.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("id", this.projectid);
        if (preference.getEmailId().equalsIgnoreCase(database.getProjectResponsible(this.projectid))) {
            params.put("responsible", "yes");
        } else {
            params.put("responsible", "no");
        }
        params.put("cname", preference.getCompanyName());
        params.put("role", preference.getDesignation());
        params.put("list", new JSONArray().toString());
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_milestones.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    MilestoneActivity.this.getMilestones(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMilestones(JSONObject jsonObject) throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONArray jsonArray = jsonObject.getJSONArray("list");
        database.deleteMilestones(this.projectid);
        try {
            database.insertMilestones(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getMilestonesOffline();
    }

    private void getMilestonesOffline() {
        this.checkforMenuCreated();
        JSONArray jsonArray = Database.getInstance((Context)this).getMilestones(this.projectid);
        if (jsonArray.length() == 0) {
            this.findViewById(2131296960).setVisibility(0);
        } else {
            this.findViewById(2131296960).setVisibility(8);
        }
        MilestoneAdapter milestoneAdapter = new MilestoneAdapter((Context)this, jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)milestoneAdapter);
        Preference preference = Preference.getInstance((Context)this);
        if (jsonArray.length() == 0) {
            if (preference.isAdmin() || Database.getInstance((Context)this).getProjectResponsible(this.projectid).equalsIgnoreCase(preference.getEmailId())) {
                this.newMilestone.setVisible(true);
                this.findViewById(2131296355).setVisibility(0);
            } else {
                this.newMilestone.setVisible(false);
                this.findViewById(2131296355).setVisibility(8);
            }
        } else {
            this.findViewById(2131296960).setVisibility(8);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558419, menu2);
        this.newMilestone = menu2.findItem(2131297082);
        this.newMilestone.setVisible(false);
        this.menuCreated = true;
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131297082: {
                Intent intent = new Intent((Context)this, AddMilestoneActivity.class);
                intent.putExtra("id", this.projectid);
                this.startActivity(intent);
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void checkforMenuCreated() {
        final Handler handler = new Handler();
        Runnable runnable2 = new Runnable(){

            @Override
            public void run() {
                if (MilestoneActivity.this.menuCreated) {
                    handler.removeCallbacks((Runnable)this);
                    try {
                        MilestoneActivity.this.manageActionBarIcons();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    handler.postDelayed((Runnable)this, 100L);
                }
            }
        };
        handler.removeCallbacks(runnable2);
        handler.postDelayed(runnable2, 100L);
    }

    private void manageActionBarIcons() {
        Preference preference = Preference.getInstance((Context)this);
        if (preference.isAdmin() || Database.getInstance((Context)this).getProjectResponsible(this.projectid).equalsIgnoreCase(preference.getEmailId())) {
            this.newMilestone.setVisible(true);
        }
    }
}

