/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.forms.AddMilestoneActivity;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.tables.MilestoneTable;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MilestoneInfoActivity
extends AppCompatActivity {
    TextView milestoneName;
    TextView milestoneDescription;
    LinearLayout milestoneDetails;
    String id;
    String projectId;
    MenuItem edit;
    MenuItem delete;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492965);
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"Milestone Details");
        this.milestoneDescription = (TextView)this.findViewById(2131297009);
        this.milestoneDetails = (LinearLayout)this.findViewById(2131297010);
        this.milestoneName = (TextView)this.findViewById(2131297012);
        this.id = this.getIntent().getStringExtra("id");
        this.projectId = this.getIntent().getStringExtra("projectId");
        try {
            this.getMilestoneDetais();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    protected void onResume() {
        super.onResume();
        this.getMilestones();
    }

    private void getMilestoneDetais() throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONObject jsonObject = database.getMilestoneDetails(this.id);
        this.milestoneDetails.removeAllViews();
        this.milestoneName.setText((CharSequence)jsonObject.getString(MilestoneTable.NAME));
        if (jsonObject.getString(MilestoneTable.DESCRIPTION).isEmpty()) {
            this.milestoneDescription.setText(2131820685);
        } else {
            this.milestoneDescription.setText((CharSequence)jsonObject.getString(MilestoneTable.DESCRIPTION));
        }
        this.addView("Project", database.getProjectName(jsonObject.getString(MilestoneTable.PROJECTID)));
        this.addView("Date", jsonObject.getString(MilestoneTable.ENDDATE));
        if (jsonObject.getString(MilestoneTable.RESPONSIBLEPERSON).equalsIgnoreCase(Preference.getInstance(this.getApplicationContext()).getEmailId())) {
            this.addView("Responsible", this.getResources().getString(2131820713));
        } else {
            this.addView("Responsible", database.getEmployeeName(jsonObject.getString(MilestoneTable.RESPONSIBLEPERSON)));
        }
        this.addView("Created On", jsonObject.getString(MilestoneTable.CREATEDDATETIME));
        this.addView("Created By", database.getEmployeeName(jsonObject.getString(MilestoneTable.CREATEDBY)));
        if (this.edit != null) {
            if (Preference.getInstance((Context)this).isResponsible(this.projectId)) {
                this.edit.setVisible(true);
                this.delete.setVisible(true);
            } else {
                this.edit.setVisible(false);
                this.delete.setVisible(false);
            }
        }
    }

    private void addView(String key, String pair) {
        View view = this.getLayoutInflater().inflate(2131493227, null);
        TextView keyText = (TextView)view.findViewById(2131296912);
        TextView pairText = (TextView)view.findViewById(2131297136);
        keyText.setText((CharSequence)key);
        pairText.setText((CharSequence)pair);
        this.milestoneDetails.addView(view);
    }

    private void getMilestones() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("mail", preference.getEmailId());
        params.put("id", this.projectId);
        params.put("mid", this.id);
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_milestones.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    MilestoneInfoActivity.this.getMilestones(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getMilestones(JSONObject jsonObject) throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONArray jsonArray = jsonObject.getJSONArray("list");
        try {
            database.insertMilestones(jsonArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.getMilestoneDetais();
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558445, menu2);
        this.edit = menu2.findItem(2131296707);
        this.delete = menu2.findItem(2131296649);
        if (Preference.getInstance((Context)this).isResponsible(this.projectId)) {
            this.edit.setVisible(true);
            this.delete.setVisible(true);
        } else {
            this.edit.setVisible(false);
            this.delete.setVisible(false);
        }
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
            case 2131296707: {
                if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) break;
                try {
                    Intent intent = new Intent((Context)this, AddMilestoneActivity.class);
                    intent.putExtra("id", this.projectId);
                    intent.putExtra("milestone", this.id);
                    this.startActivity(intent);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case 2131296649: {
                this.showAlert();
            }
        }
        return super.onOptionsItemSelected(item);
    }

    private void deleteMilestone() {
        Preference preference = Preference.getInstance((Context)this);
        HashMap<String, String> params = new HashMap<String, String>();
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("cname", (Object)preference.getCompanyName());
            jsonObject.put("mail", (Object)preference.getEmailId());
            jsonObject.put("type", (Object)preference.getCompnayType());
            if (preference.isAdmin()) {
                jsonObject.put("role", (Object)preference.getDesignation());
            } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
                jsonObject.put("role", (Object)"project");
            } else {
                jsonObject.put("role", (Object)"employee");
            }
            jsonObject.put("milestoneid", (Object)this.id);
            params.put("data", jsonObject.toString());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/delete_milestone.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject jsonObject = new JSONObject(response);
                    if (jsonObject.getBoolean("s")) {
                        Toast.makeText((Context)MilestoneInfoActivity.this.getApplicationContext(), (CharSequence)"Milstone Deleted Successfully", (int)0).show();
                        Database.getInstance(MilestoneInfoActivity.this.getApplicationContext()).deleteMilestone(MilestoneInfoActivity.this.id);
                        MilestoneInfoActivity.this.finish();
                    } else {
                        Toast.makeText((Context)MilestoneInfoActivity.this.getApplicationContext(), (CharSequence)"Unable to delete milestone", (int)0).show();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void showAlert() {
        new AlertDialog.Builder((Context)this).setMessage((CharSequence)"Milestone Will be deleted").setPositiveButton((CharSequence)"CONTINUE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int id2) {
                MilestoneInfoActivity.this.deleteMilestone();
            }
        }).setNegativeButton((CharSequence)"CLOSE", new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialogInterface, int i) {
            }
        }).show();
    }
}

