/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.Toast;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.DividerItemDecoration;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.listener.OnItemClickListener;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.activities.TaskManagementActivity;
import com.b2lmobitech.fieldcloudplus.task.adapters.PeopleAdapter;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PeopleActivity
extends AppCompatActivity
implements OnItemClickListener {
    String projectId;
    RecyclerView recyclerView;
    JSONArray jsonArray;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492975);
        this.projectId = this.getIntent().getStringExtra("id");
        this.recyclerView = (RecyclerView)this.findViewById(2131297239);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new DividerItemDecoration((Context)this, 1));
        this.recyclerView.setHasFixedSize(true);
        this.getPeoples();
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getSupportActionBar().setTitle((CharSequence)"People");
    }

    private void getPeoples() {
        HashMap<String, String> params = new HashMap<String, String>();
        Preference preference = Preference.getInstance((Context)this);
        params.put("id", this.projectId);
        params.put("mail", preference.getEmailId());
        if (preference.isAdmin()) {
            params.put("role", preference.getDesignation());
        } else if (Database.getInstance((Context)this).isResponsibleForThisProject(this.projectId, preference.getEmailId())) {
            params.put("role", "project");
        } else {
            params.put("role", "employee");
        }
        MyRequestQueue.getInstance((Activity)this).addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/get_peoples.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    PeopleActivity.this.getPeoples(new JSONObject(response));
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void getPeoples(JSONObject jsonObject) throws JSONException {
        Database database = Database.getInstance((Context)this);
        JSONArray employeeArray = jsonObject.getJSONArray("employees");
        try {
            database.insertEmplyoees(employeeArray);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (employeeArray.length() == 0) {
            Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Task not assigned to anyone", (int)0).show();
            this.finish();
        }
        this.jsonArray = jsonObject.getJSONArray("peoples");
        PeopleAdapter peopleAdapter = new PeopleAdapter((Context)this, this.jsonArray);
        this.recyclerView.setAdapter((RecyclerView.Adapter)peopleAdapter);
    }

    @Override
    public void itemClicked(int position) {
        Intent intent = new Intent(this.getApplicationContext(), TaskManagementActivity.class);
        intent.putExtra("id", this.projectId);
        try {
            intent.putExtra("employee", this.jsonArray.getJSONObject(position).getString("employee"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.startActivity(intent);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }
}

