/*
 * Decompiled with CFR 0.152.
 */
package com.b2lmobitech.fieldcloudplus.task.activities;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.location.Location;
import android.location.LocationManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.SeekBar;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.appcompat.app.AppCompatActivity;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.core.content.FileProvider;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import com.android.volley.RequestQueue;
import com.b2lmobitech.fieldcloudplus.others.listener.MyRequestFinishedListener;
import com.b2lmobitech.fieldcloudplus.others.utils.DateUtils;
import com.b2lmobitech.fieldcloudplus.others.utils.MyRequestQueue;
import com.b2lmobitech.fieldcloudplus.task.Utility;
import com.b2lmobitech.fieldcloudplus.task.adapters.AddedListAdapter;
import com.b2lmobitech.fieldcloudplus.task.encap.LatLang;
import com.b2lmobitech.fieldcloudplus.task.encap.TaskEncap;
import com.b2lmobitech.fieldcloudplus.task.listener.ActivityDeletedListener;
import com.b2lmobitech.fieldcloudplus.task.listener.LocationUpdateListener;
import com.b2lmobitech.fieldcloudplus.task.others.LocationUpdate;
import com.b2lmobitech.fieldcloudplus.task.others.Preference;
import com.b2lmobitech.fieldcloudplus.task.others.RequestProgress;
import com.b2lmobitech.fieldcloudplus.task.service.UpdateTaskService;
import com.b2lmobitech.fieldcloudplus.task.sql.Database;
import com.b2lmobitech.fieldcloudplus.task.sql.Sqlite;
import com.google.android.gms.location.FusedLocationProviderClient;
import com.google.android.gms.location.LocationCallback;
import com.google.android.gms.location.LocationRequest;
import com.google.android.material.snackbar.Snackbar;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ProgressForm
extends AppCompatActivity {
    Button add;
    RecyclerView recyclerView;
    ArrayList<String> arrayList = new ArrayList();
    EditText editText;
    AddedListAdapter addedListAdapter;
    SeekBar seekBar;
    int progress;
    TextView completed_precentage;
    ArrayList<TaskEncap> tasklsit = new ArrayList();
    MenuItem submit;
    ProgressDialog pDialog;
    RequestQueue requestQueue;
    String registeredcompany;
    String registeredemailid;
    String taskid;
    TaskEncap taskEncap;
    Sqlite sqldatabase;
    JSONArray jsonArray;
    JSONObject jsonObject;
    EditText date;
    Calendar cal;
    CoordinatorLayout coordinatorLayout;
    Snackbar snackbar;
    Uri imageUri;
    File mediaFile = null;
    Bitmap cambmp;
    String camstring = "null";
    FusedLocationProviderClient mFusedLocationClient;
    LocationRequest mLocationRequest;
    private long FASTEST_INTERVAL = 1000L;
    private ImageView cameraButton;
    private ImageView snapshot;
    protected static final int CAPTURE_IMAGE_ACTIVITY_REQUEST_CODE = 0;
    Location location;
    LatLang latLang = new LatLang();
    LocationCallback locationCallback;
    LocationManager locationManager;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(2131492982);
        this.getSupportActionBar().setTitle((CharSequence)"Progress Update");
        this.getSupportActionBar().setDisplayHomeAsUpEnabled(true);
        this.getWidgets();
        this.progress = this.getIntent().getIntExtra("progress", 0);
        this.taskid = this.getIntent().getStringExtra("taskid");
        Database database = Database.getInstance((Context)this);
        try {
            this.jsonObject = database.getTaskDetails(this.taskid);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        this.addedListAdapter = new AddedListAdapter((Context)this, this.arrayList, new ActivityDeletedListener(){

            @Override
            public void activityDeleted(int position) {
                ProgressForm.this.arrayList.remove(position);
                ProgressForm.this.addedListAdapter.notifyDataSetChanged();
            }
        });
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.addedListAdapter);
        this.completed_precentage.setText((CharSequence)String.format(Locale.getDefault(), "%d%%", this.progress));
        this.setDatePicker();
        this.showDialog();
    }

    private void getWidgets() {
        this.date = (EditText)this.findViewById(2131297192);
        this.date.setInputType(0);
        this.cameraButton = (ImageView)this.findViewById(2131296473);
        this.snapshot = (ImageView)this.findViewById(2131297375);
        this.coordinatorLayout = (CoordinatorLayout)this.findViewById(2131296592);
        this.completed_precentage = (TextView)this.findViewById(2131296556);
        this.recyclerView = (RecyclerView)this.findViewById(2131297240);
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this));
        this.recyclerView.setHasFixedSize(true);
        this.editText = (EditText)this.findViewById(2131296348);
        this.findViewById(2131296357).setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ProgressForm.this.addToList();
            }
        });
        this.cameraButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ProgressForm.this.OpenCamera();
            }
        });
    }

    private void addToList() {
        String str = this.editText.getText().toString().trim();
        if (str.isEmpty()) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"Can't be empty", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    ProgressForm.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        if (this.arrayList.contains(str)) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"Already Exists", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    ProgressForm.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        this.arrayList.add(str);
        this.addedListAdapter.notifyDataSetChanged();
        this.editText.setText((CharSequence)"");
    }

    private void setDatePicker() {
        DatePickerDialog.OnDateSetListener dpd = new DatePickerDialog.OnDateSetListener(){

            public void onDateSet(DatePicker view, int year, int monthOfYear, int dayOfMonth) {
                ProgressForm.this.cal = new GregorianCalendar(year, monthOfYear, dayOfMonth);
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
                ProgressForm.this.date.setText((CharSequence)df.format(ProgressForm.this.cal.getTime()));
            }
        };
        Calendar myCalendar = Calendar.getInstance();
        final DatePickerDialog dialog = new DatePickerDialog((Context)this, dpd, myCalendar.get(1), myCalendar.get(2), myCalendar.get(5));
        try {
            Date udate = DateUtils.fromDateTime(this.jsonObject.getString("t_start_date"));
            Date edate = DateUtils.fromDate(this.jsonObject.getString("t_start_date"));
            if (udate.before(edate)) {
                dialog.getDatePicker().setMinDate(udate.getTime());
            } else {
                dialog.getDatePicker().setMinDate(edate.getTime());
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        dialog.getDatePicker().setMaxDate(myCalendar.getTimeInMillis());
        this.date.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                dialog.show();
            }
        });
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        MenuInflater inflater = this.getMenuInflater();
        inflater.inflate(2131558418, menu2);
        this.submit = (MenuItem)this.findViewById(2131296684);
        return true;
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        switch (item.getItemId()) {
            case 2131296684: {
                if (MyRequestQueue.getInstance((Activity)this).isNoNetwork()) break;
                this.requestLocationUpdate();
                break;
            }
            case 16908332: {
                this.onBackPressed();
                return true;
            }
        }
        return super.onOptionsItemSelected(item);
    }

    public static void createJob(String datetime) {
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest request = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(UpdateTaskService.class).addTag(datetime)).setInitialDelay(60L, TimeUnit.SECONDS)).setConstraints(constraints)).build();
    }

    private void showDialog() {
        if (!Utility.isNetworkAvailable((Context)this)) {
            new AlertDialog.Builder((Context)this).setTitle((CharSequence)"No Internet Connection").setMessage((CharSequence)"Progress will be saved in offline and feteched to server whenever internet connection available").setPositiveButton((CharSequence)"OK", new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id2) {
                }
            }).show();
        }
    }

    protected void OpenCamera() {
        Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.imageUri = this.getOutputMediaFileUri();
        intent.putExtra("output", (Parcelable)this.imageUri);
        this.startActivityForResult(intent, 0);
    }

    /*
     * Unable to fully structure code
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        block2 : switch (requestCode) {
            case 0: {
                if (resultCode != -1) ** GOTO lbl20
                try {
                    if (this.imageUri != null) {
                        try {
                            this.cambmp = BitmapFactory.decodeStream((InputStream)this.getContentResolver().openInputStream(this.imageUri), null, null);
                            this.cambmp = Utility.processImage(this.cambmp);
                            this.snapshot.setImageBitmap(this.cambmp);
                        }
                        catch (FileNotFoundException var4_4) {
                            // empty catch block
                        }
                        this.camstring = Utility.bitmap2string(this.cambmp);
                    }
                    ** GOTO lbl24
                }
                catch (Exception e) {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"please try again", (int)0).show();
                }
                ** GOTO lbl24
lbl20:
                // 1 sources

                if (resultCode == 0) {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"You cancelled image capture", (int)0).show();
                } else {
                    Toast.makeText((Context)this.getApplicationContext(), (CharSequence)"Sorry! Failed to capture image", (int)0).show();
                }
lbl24:
                // 5 sources

                if (this.mediaFile == null) break;
                this.mediaFile.delete();
                break;
            }
            case 1: {
                switch (resultCode) {
                    case -1: {
                        this.requestLocationUpdate();
                        break block2;
                    }
                    case 0: {
                        RequestProgress.getInstance((Activity)this).hideProgressBar();
                        break block2;
                    }
                }
            }
        }
    }

    public Uri getOutputMediaFileUri() {
        this.mediaFile = Utility.getCapturedImageFile();
        Uri uri = null;
        uri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)this, (String)"com.b2lmobitech.fieldcloudplus.provider", (File)this.mediaFile) : Uri.fromFile((File)this.mediaFile);
        return uri;
    }

    private void requestLocationUpdate() {
        if (this.arrayList.size() == 0) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"Add completed activities", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    ProgressForm.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        String progressDate = this.date.getText().toString();
        if (progressDate.isEmpty()) {
            this.snackbar = Snackbar.make((View)this.coordinatorLayout, (CharSequence)"Select progress date", (int)-2).setAction((CharSequence)"Close", new View.OnClickListener(){

                public void onClick(View view) {
                    ProgressForm.this.snackbar.dismiss();
                }
            });
            this.snackbar.show();
            return;
        }
        LocationUpdate locationUpdate = LocationUpdate.getInstance((Context)this);
        locationUpdate.connectLocation(new LocationUpdateListener(){

            @Override
            public void onLocationReceived(String latitude, String longtitude) {
                try {
                    ProgressForm.this.update(latitude, longtitude);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void update(String latitude, String longtitude) throws JSONException {
        MyRequestQueue myRequestQueue = MyRequestQueue.getInstance((Activity)this);
        Preference preference = Preference.getInstance((Context)this);
        StringBuilder csvBuilder = new StringBuilder();
        for (String activity : this.arrayList) {
            csvBuilder.append(activity);
            csvBuilder.append("@#");
        }
        String activities = csvBuilder.toString();
        String finalActivities = activities = activities.substring(0, activities.length() - "@#".length());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("task_id", this.taskid);
        params.put("employee_id", preference.getEmailId());
        params.put("progress_date", this.date.getText().toString());
        params.put("progress", this.progress + "");
        params.put("latitude", latitude);
        params.put("longitude", longtitude);
        params.put("camera", this.camstring);
        params.put("completed_activities", finalActivities);
        params.put("completed_datetime", Utility.getCurrentDateTime());
        myRequestQueue.addToQueue("http://fieldcloud.in/original_new_k_Eversendai/App_developing/api/project/insert_progress.php", params, new MyRequestFinishedListener(){

            @Override
            public void requestResult(String response) {
                try {
                    JSONObject json = new JSONObject(response);
                    int success = json.getInt("s");
                    if (success == 1) {
                        ProgressForm.this.finish();
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

